/* Unit testing for outcomes
(C) 2013-2019 Niall Douglas <http://www.nedproductions.biz/> (5 commits)


Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#include <boost/outcome/outcome.hpp>
#include <boost/test/unit_test.hpp>
#include <boost/test/unit_test_monitor.hpp>

BOOST_OUTCOME_AUTO_TEST_CASE(issues_16, "Default constructor of T is sometimes compiled when T has no default constructor")
{
  using namespace BOOST_OUTCOME_V2_NAMESPACE;
  struct udt
  {
    const char *_v{nullptr};
    udt() = delete;
    constexpr explicit udt(const char *v) noexcept : _v(v) {}
    constexpr udt(udt &&o) noexcept : _v(o._v) { o._v = nullptr; }
    udt(const udt &) = delete;
    constexpr udt &operator=(udt &&o) noexcept
    {
      _v = o._v;
      o._v = nullptr;
      return *this;
    }
    udt &operator=(const udt &) = delete;
    ~udt() = default;
    constexpr const char *operator*() const noexcept { return _v; }
  };
  result<udt> n(boost::system::error_code(ENOMEM, boost::system::generic_category()));
  (void) n;
}
