// Boost.Geometry (aka GGL, Generic Geometry Library)
// Unit Test
//
// Copyright (c) 2007-2012 Barend Gehrels, Amsterdam, the Netherlands.
// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)


#ifndef BOOST_GEOMETRY_TEST_OVERLAY_CASES_HPP
#define BOOST_GEOMETRY_TEST_OVERLAY_CASES_HPP

#include <string>

// See powerpoint

static std::string case_1[2] = {
        "POLYGON((0 1,2 5,5 3,0 1))",
        "POLYGON((3 0,0 3,4 5,3 0))" };

static std::string ccw_case_1[2] = {
        "POLYGON((0 1,5 3,2 5,0 1))",
        "POLYGON((3 0,4 5,0 3,3 0))" };

static std::string open_case_1[2] = {
        "POLYGON((0 1,2 5,5 3))",
        "POLYGON((3 0,0 3,4 5))" };


static std::string case_2[2] = {
        "POLYGON((0 2,2 5,5 3,3 0,0 2))",
        "POLYGON((0 4,4 5,5 1,1 0,0 4))" };

static std::string case_3[2] = {
        "POLYGON((1 2,2 4,4 3,3 1,1 2))",
        "POLYGON((1 1,1 4,4 4,4 1,1 1))" };


static std::string case_4[2] = {
        "POLYGON((0 2,2 5,5 3,3 0,0 2))",
        "POLYGON((0 4,4 5,5 1,1 0,0 4),(1 1,2 1,2 2,1 2,1 1),(3 3,4 3,4 4,3 4,3 3))" };

static std::string case_5[2] = {
        "POLYGON((0 4,1 5,2.5 4,3.5 5,5 4,4 3,5 2,4 1,3.5 0,3 1,2.5 0,2 1,1.5 0,1 3.5,0.25 3,1 2.5,0 2,0 4))",
        "POLYGON((0.5 0.5,0.5 4.5,4.5 4.5,4.5 0.5,0.5 0.5))"
        };

static std::string case_6[2] = {
        "POLYGON((0 1,2 5,5 2,0 1))",
        "POLYGON((1 3,2 5,5 2,1 3))" };

static std::string case_7[2] = {
        "POLYGON((0 1,1 3,5 2,0 1))",
        "POLYGON((1 3,2 5,5 2,1 3))" };

static std::string case_8[2] = {
        "POLYGON((0 0,0 4,4 0,0 0))",
        "POLYGON((1 3,4 4,3 1,1 3))" };

static std::string case_9[2] = {
        "POLYGON((0 0,0 4,4 0,0 0))",
        "POLYGON((2 2,2 4,5 4,2 2))" };

static std::string ccw_case_9[2] = {
        "POLYGON((0 0,4 0,0 4,0 0))",
        "POLYGON((2 2,5 4,2 4,2 2))" };

static std::string open_case_9[2] = {
        "POLYGON((0 0,0 4,4 0))",
        "POLYGON((2 2,2 4,5 4))" };

static std::string case_10[2] = {
        "POLYGON((0 0,2 4,4 0,0 0))",
        "POLYGON((1 2,2 5,3 2,2 4,1 2))" };

static std::string case_11[2] = {
        "POLYGON((0 0,0 4,4 0,0 0))",
        "POLYGON((1 2,2 2,2 1,1 1))" };

static std::string case_12[2] = {
        "POLYGON((0 1,1 4,2 2,3 4,4 1,0 1))",
        "POLYGON((0 3,2 4,4 3,0 3))" };

static std::string case_13[2] = {
        "POLYGON((0 1,1 2,3 0,0 1))",
        "POLYGON((0 3,2 3,2 1,0 3))" };

static std::string case_14[2] = {
        "POLYGON((0 0,0 4,2 2,4 0,0 0))",
        "POLYGON((1 3,4 4,3 1,1 3))" };

static std::string case_15[2] = {
        "POLYGON((0 0,0 4,1.5 2.5,2.5 1.5,4 0,0 0))",
        "POLYGON((1 3,4 4,3 1,1 3))" };

static std::string case_16[2] = {
        "POLYGON((1 2,3 4,2 1,1 2))",
        "POLYGON((1 0,1 2,2 1,3 4,2 3,3 5,4 0,1 0))" };

static std::string case_17[2] = {
        "POLYGON((0 0,0 4,4 0,0 0))",
        "POLYGON((1 1,1 3,3 1,1 1))" };

static std::string case_18[2] = {
        "POLYGON((0 0,0 4,1.5 2.5,2.5 1.5,4 0,0 0))",
        "POLYGON((1 1,1 3,3 1,1 1))" };

static std::string case_19[2] = {
        "POLYGON((2 0,1 3,5 2,2 0))",
        "POLYGON((1 3,2 5,5 2,1 3))" };

static std::string case_20[2] = {
        "POLYGON((2 0,1 3,5 2,2 0))",
        "POLYGON((2 0,1 3,5 2,2 0))" };

static std::string case_21[2] = {
        "POLYGON((1 0,0 5,5 2,1 0),(2 1,3 2,1 3,2 1))",
        "POLYGON((2 1,1 3,3 2,2 1))" };

static std::string case_22[2] = {
        "POLYGON((1 0,0 3,4 2,1 0))",
        "POLYGON((2 4,5 5,4 2,2 4))" };

static std::string case_23[2] = {
        "POLYGON((1 0,0 3,4 2,1 0))",
        "POLYGON((3 3,4 2,1 1,3 3))" };

static std::string case_24[2] = {
        "POLYGON((1 0,0 3,4 2,1 0))",
        "POLYGON((2 2,4 2,1 1,2 2))" };

static std::string case_25[2] = {
        "POLYGON((1 0,0 3,4 2,1 0))",
        "POLYGON((3 1,4 2,5 0,3 1))" };

static std::string case_26[2] = {
        "POLYGON((1 0,0 3,4 2,1 0))",
        "POLYGON((3 1,4 2,5 4,4 0,3 1))" };

static std::string case_27[2] = {
        "POLYGON((1 0,0 3,4 2,1 0))",
        "POLYGON((1 1,4 2,5 0,1 1))" };

static std::string case_28[2] = {
        "POLYGON((1 0,0 3,4 2,1 0))",
        "POLYGON((1 1,4 2,5 4,5 0,1 1))" };

static std::string case_29[2] = {
        "POLYGON((1 0,0 3,4 2,1 0))",
        "POLYGON((4 4,5 1,4 2,1 1,4 4))" };

static std::string case_30[2] = {
        "POLYGON((1 0,0 3,2 2,3 3,1 0))",
        "POLYGON((1 2,2 2,2 4,4 3,3 1,1 2))" };

static std::string case_31[2] = {
        "POLYGON((0 0,0 3,2 2,0 0))",
        "POLYGON((4 1,2 2,3 3,4 1))" };

static std::string case_32[2] = {
        "POLYGON((0 0,0 3,2 2,0 0))",
        "POLYGON((4 1,3 0,2 2,4 1))" };

static std::string case_33[2] = {
        "POLYGON((0 0,0 3,2 2,0 0))",
        "POLYGON((3 3,3 0,2 2,3 3))" };

static std::string case_34[2] = {
        "POLYGON((2 0,0 3,4 2,2 0))",
        "POLYGON((2 1,4 2,5 3,4 1,2 1))" };

static std::string case_35[2] = {
        "POLYGON((1 0,0 3,5 3,4 2,5 1,1 0))",
        "POLYGON((2 2,4 2,4 1,2 2))" };

static std::string case_36[2] = {
        "POLYGON((1 0,0 3,4 2,1 0))",
        "POLYGON((1 5,5 5,4 2,3 3,2 1,1 2,1 5))" };

static std::string case_37[2] = {
        "POLYGON((4 0,2 2,5 5,4 0))",
        "POLYGON((0 2,4 3,2 2,4 1,0 2))" };

static std::string case_38[2] = {
        "POLYGON((4 0,3 3,2 2,4 5,5 2,4 0))",
        "POLYGON((1 1,1 3,4 4,3 3,4 2,1 1))" };

static std::string case_39[2] = {
        "POLYGON((0 4,4 8,7 7,8 4,5 3,4 0,0 4))",
        "POLYGON((0 4,4 8,5 5,8 4,7 1,4 0,0 4))" };

static std::string case_40[2] = {
        "POLYGON((0 1,1 2,2 1,3 2,4 1,5 2,4 0,2 0,0 1))",
        "POLYGON((0 3,2 4,4 4,5 2,4 3,3 2,2 3,1 2,0 3))" };

static std::string case_41[2] = {
        "POLYGON((3 1,1 4,3 3.5,5 3,3 1))",
        "POLYGON((3 1,1 4,5 3,4 2,3 1))" };

static std::string case_42[2] = {
        "POLYGON((3 1,1 4,3 3.5,5 3,5 3,3 1))",
        "POLYGON((3 1,1 4,1 4,5 3,4 2,3 1))" };

// keyholing
static std::string case_43[2] = {
        "POLYGON((1 2,1 1,2 1,2 2.25,3 2.25,3 0,0 0,0 3,3 3,2.75 2,1 2))",
        "POLYGON((1.5 1.5,1.5 2.5,2.5 2.5,2.5 1.5,1.5 1.5))" };
// self-tangency

static std::string case_44[2] = {
        "POLYGON((0 0,0 3,3 3,3 2,0 1.5,3 1,3 0,0 0))",
        "POLYGON((1 1,1 2,2 2,2 1,1 1))" };
// self-intersection

static std::string case_45[2] = {
        "POLYGON((0.5 0,0.5 3,3 3,3 2,0 1.5,3 1,3 0,0.5 0))",
        "POLYGON((1 1,1 2,2 2,2 1,1 1))" };
// self-tangent

static std::string case_46[2] = {
        "POLYGON((2 0,2 3,5 3,5 2,2 1.5,5 1,5 0,2 0))",
        "POLYGON((1.5 1,1.5 2,2.5 2,2.5 1,1.5 1))" };
// self-tangent

static std::string case_47[2] = {
        "POLYGON((2.5 0,2.5 3,5 3,5 2,2 1.5,5 1,5 0,2.5 0))",
        "POLYGON((2 1,2 2,3 2,3 1,2 1))" };

static std::string case_49[2] = {
        "POLYGON((1 0,1 1,2 2,3 3,4 3,4 0,1 0))",
        "POLYGON((0 2,2 5,5 2,5 0,2 0,2 2,0 2))" };


// 50, collinear opposite
static std::string case_50[2] = {
        "POLYGON((0 0,0 3,2 3,4 3,4 0,0 0))",
        "POLYGON((0 3,0 5,5 5,5 0,4 0,4 3,2 3,0 3))" };

// 51, fit
static std::string case_51[2] = {
        "POLYGON((0 0,0 5,5 5,5 0,0 0),(4 1,3 4,1 2,4 1))",
        "POLYGON((1 2,3 4,4 1,1 2))" };

// 52, partially equal, touching each other
static std::string case_52[2] = {
        "POLYGON((0 0,1 4,3 1,4 4,1 4,5 5,5 0,0 0))",
        "POLYGON((0 0,1 4,3 1,4 4,1 4,5 5,4 1,0 0))" };

// 53, wrapping a box, self-touching
static std::string case_53[3] = {
        "POLYGON((2 2,2 3,3 3,3 2,2 2))",
        // ST self-tangent ext. ring, ST_IsValid=false
        "POLYGON((0 2,0 5,5 5,5 0,2 0,2 2,3 2,3 1,4 1,4 4,1 4,1 3,2 3,2 2,0 2))",
        // IET tangent ext/int ring, ST_IsValid=true
        "POLYGON((0 2,0 5,5 5,5 0,2 0,2 2,0 2),(1 3,2 3,2 2,3 2,3 1,4 1,4 4,1 4,1 3))"
    };

static std::string case_54[4] = {
        // ST: self-tangent ext. ring
        "POLYGON((2 2,2 3,4 3,4 0,1 0,1 2,2 2,2 1,3 1,3 2,2 2))",
        // IET: tangent ext/int ring
        "POLYGON((2 2,2 3,4 3,4 0,1 0,1 2,2 2),(2 1,3 1,3 2,2 2,2 1))",
        // other like in case53
        case_53[1], // ST
        case_53[2]  // IET
    };

static std::string case_55[4] = {
        // ST: self-tangent ext. ring
        "POLYGON((2 2,3 3,4 3,4 0,1 0,1 1,2 2,2 1,3 1,3 2,2 2))",
        // IET: tangent ext/int ring
        "POLYGON((2 2,3 3,4 3,4 0,1 0,1 1,2 2),(2 1,3 1,3 2,2 2,2 1))",
        // ST: self-tangent ext. ring
        "POLYGON((0 2,0 5,5 5,5 0,2 0,2 2,3 1,4 1,4 4,1 4,1 3,2 2,0 2))" ,
        // IET: tangent ext/int ring
        "POLYGON((0 2,0 5,5 5,5 0,2 0,2 2,0 2),(1 3,2 2,3 1,4 1,4 4,1 4,1 3))"

        // B, not a 4-fold intersection
        //"POLYGON((2 2,3 3,4 3,4 0,1 0,1 1,2 2),(2 1,3 1,3 2,2.0 1.9,2 1))",
        //"POLYGON((0 2,0 5,5 5,5 0,2 0,2 2,0 2),(1 3,2.1 2.1,3 1,4 1,4 4,1 4,1 3))"
        // C, not a 4-fold intersection,
        //"POLYGON((2 2,3 3,4 3,4 0,1 0,1 1,2 2),(2 1,3 1,3 2,2.0 1.9,2 1))",
        //"POLYGON((0 2,0 5,5 5,5 0,2 0,2 2,0 2),(1 3,1.9 1.9,3 1,4 1,4 4,1 4,1 3))"
    };

static std::string case_56[2] = {
        "POLYGON((0 0,0 1,2 3,3 0,4 2,5 0,0 0))",
        //"POLYGON((0 -1,0 1,2 3,3 0,4 2,5 -1,0 -1))",
        //"POLYGON((0 1,0 4,5 4,5 0,3 0,4 1,4 3,2 3,2 1,3 0,0 0))"
        "POLYGON((1 0,1 4,5 4,5 0,3 0,4 1,4 3,2 3,2 1,3 0,1 0))"
    };

static std::string case_57[2] = {
        case_56[0],
        //"POLYGON((0 2,4 5,5 1,0 2))"
        //"POLYGON((0 -1,0 1,2 3,3 0,4 2,5 -1,0 -1))",
        //"POLYGON((0 0,0 1,2 3,3 0,4 2,6 0,0 0))",
        "POLYGON((0 0,4 5,5 0,0 0))"
    };

// Case 58, either one ring with self-tangencies defining holes,
//          or three inner rings tangent to outer ring
static std::string case_58[3] = {
        "POLYGON((3 3,3 4,4 4,4 3,3 3))",
        // ST: self-tangent
        "POLYGON((0 2,0 5,4 4,1 4,1 3,4 4,2 3,2 2,4 4,3 2,4 2,4 4,5 0,0 2))",
        // IET: inner/ext tangency
        "POLYGON((0 2,0 5,4 4,5 0,0 2),(4 4,1 4,1 3,4 4),(4 4,2 3,2 2,4 4),(4 4,3 2,4 2,4 4))"
    };

static std::string case_59[3] = {
        "POLYGON((0.5 3,3.5 3.5,3 0.5,2 2,0.5 3))",
        case_53[1], // ST: self-tangent
        case_53[2] // IET: inner/ext tangency
    };
static std::string case_60[3] = {
        "POLYGON((1 3,5 5,3 1,1 3))",
        case_53[1], // ST: self-tangent
        case_53[2] // IET: inner/ext tangency
    };

// 60-..., actually there are multi-polygons but expressed here using self-tangencies
static std::string case_61[2] = {
        "POLYGON((1 1,1 2,2 2,2 3,3 3,3 2,2 2,2 1,1 1))",
        "POLYGON((1 2,1 3,2 3,2 4,3 4,3 3,2 3,2 2,1 2))"
    };

// 62..69 TODO, most are multi but can be expressed by self-tangent-polygon as well

static std::string case_70[2] = {
        "POLYGON((1 0,1 3,4 3,4 0,1 0),(2 1,3 1,3 2,2 2,2 1))",
        "POLYGON((1 0,1 2,4 2,4 0,3 0,3 1,2 1,2 0,1 0))"
    };

static std::string case_71[2] = {
        "POLYGON((0 0,0 3,1 3,1 1,3 1,3 2,2 2,2 3,3 3,3 2,4 2,4 0,0 0))",
        "POLYGON((0 2,0 3,3 3,3 2,0 2))"
    };

static std::string case_72[2] = {
        "POLYGON((0 3,4 4,3 0,3 3,2 1,1 2,3 3,0 3))",
        "POLYGON((0 0,1 4,3 3,4 1,0 0))"
    };

static std::string case_79[2] = {
        "POLYGON((0 0,0 5,5 5,5 3,2 3,2 2,5 2,5 0,0 0))",
        "POLYGON((0 0,0 5,5 5,5 0,2 0,2 2,1 2,1 0,0 0))"
    };

static std::string case_many_situations[2] = {
        "POLYGON((2 6,2 14,10 18,18 14,18 6,16 5,14 4,12 3,10 2,8 3,6 4,4 5,2 6))",
        "POLYGON((2 6,2 7,2 8,2 9,2 10,2 11,2 12,1 14"
            ",4 14,4 15,7 15,7 18,8 17,9 20,10 18"
            ",10 15.5,11 17.5,12 17,11 15,12 14.5,13 16.5,14 18.5,15 18,14 16,15 15.5,16 17.5,18 14"
            ",19 13,17 11,19 9,19 7"
            ",17 5,16 5,15 4.5,13 3.5,11 2.5,10 2"
            ",8 3,6 4,4 5,2 6))" };

static std::string collinear_overlaps[2] = {
        "POLYGON((0 2,0 4,2 4,2 5,0 5,0 7,2 7,2 8,6 8,6 7,8 7,8 5,6 5,6 4,8 4,8 2,6 2,6 1,2 1,2 2,0 2))",
        "POLYGON((3 0,3 2,1 2,1 3,3 3,3 4,1 4,1 5,3 5,3 6,1 6,1 7,3 7,3 9,5 9,5 7,7 7,7 6,5 6,5 5,7 5,7 4,5 4,5 3,7 3,7 2,5 2,5 0,3 0))" };


static std::string line_line1[2] = {
        "LINESTRING(0 1,2 5,5 3)", "LINESTRING(3 0,0 3,4 5)"};



// Pies
static std::string pie_23_16_16[2] = {
    "POLYGON((2500 2500,2500 3875,2855 3828,3187 3690,3472 3472,3690 3187,3828 2855,3875 2500,3828 2144,3690 1812,3472 1527,3187 1309,2855 1171,2499 1125,2144 1171,1812 1309,1527 1527,1309 1812,1171 2144,1125 2499,1171 2855,1309 3187,1527 3472,1812 3690,2500 2500))",
    "POLYGON((2500 2500,1525 1937,1413 2208,1375 2499,1413 2791,1525 3062,1704 3295,1937 3474,2208 3586,2499 3625,2791 3586,3062 3474,3295 3295,3474 3062,3586 2791,3625 2500,3586 2208,2500 2500))"
    };

static std::string pie_16_4_12[2] = {
    "POLYGON((2500 2500,2500 3875,2855 3828,3187 3690,3472 3472,3690 3187,3828 2855,3875 2500,3828 2144,3690 1812,3472 1527,3187 1309,2855 1171,2499 1125,2144 1171,1812 1309,1527 1527,2500 2500))",
    "POLYGON((2500 2500,2500 1375,2208 1413,1937 1525,1704 1704,2500 2500))"
    };

static std::string pie_4_13_15[2] = {
    "POLYGON((2500 2500,2500 3875,2855 3828,3187 3690,3472 3472,2500 2500))",
    "POLYGON((2500 2500,1704 1704,1525 1937,1413 2208,1375 2499,1413 2791,1525 3062,1704 3295,1937 3474,2208 3586,2499 3625,2791 3586,3062 3474,3295 3295,2500 2500))"
    };

static std::string pie_16_2_15_0[2] = {
    "POLYGON((2500 2500,2500 3875,2855 3828,3187 3690,3472 3472,3690 3187,3828 2855,3875 2500,3828 2144,3690 1812,3472 1527,3187 1309,2855 1171,2499 1125,2144 1171,1812 1309,1527 1527,2500 2500))",
    "POLYGON((2500 2500,1704 1704,1525 1937,2500 2500))"
    };


// Shifted pies
static std::string pie_20_20_7_100[2] = {
    "POLYGON((2500 2500,2500 3875,2855 3828,3187 3690,3472 3472,3690 3187,3828 2855,3875 2500,3828 2144,3690 1812,3472 1527,3187 1309,2855 1171,2499 1125,2144 1171,1812 1309,1527 1527,1309 1812,1171 2144,1125 2499,1171 2855,2500 2500))",
    "POLYGON((2500 2600,3586 2308,3474 2037,3295 1804,3062 1625,2791 1513,2499 1475,2208 1513,1937 1625,1704 1804,1525 2037,1413 2308,1375 2600,1413 2891,1525 3162,1704 3395,1937 3574,2208 3686,2499 3725,2791 3686,3062 3574,2500 2600))"
    };

static std::string pie_23_23_3_2000[2] = {
    "POLYGON((2500 2500,2500 3875,2855 3828,3187 3690,3472 3472,3690 3187,3828 2855,3875 2500,3828 2144,3690 1812,3472 1527,3187 1309,2855 1171,2499 1125,2144 1171,1812 1309,1527 1527,1309 1812,1171 2144,1125 2499,1171 2855,1309 3187,1527 3472,1812 3690,2500 2500))",
    "POLYGON((2500 3500,3295 4295,3474 4062,3586 3791,3625 3500,3586 3208,3474 2937,3295 2704,3062 2525,2791 2413,2499 2375,2208 2413,1937 2525,1704 2704,1525 2937,1413 3208,1375 3500,1413 3791,1525 4062,1704 4295,1937 4474,2208 4586,2499 4625,2791 4586,2500 3500))"
    };

static std::string pie_23_21_12_500[2] = {
    "POLYGON((2500 2500,2500 3875,2855 3828,3187 3690,3472 3472,3690 3187,3828 2855,3875 2500,3828 2144,3690 1812,3472 1527,3187 1309,2855 1171,2499 1125,2144 1171,1812 1309,1527 1527,1309 1812,1171 2144,1125 2499,1171 2855,1309 3187,1527 3472,1812 3690,2500 2500))",
    "POLYGON((2500 3000,2500 1875,2208 1913,1937 2025,1704 2204,1525 2437,1413 2708,1375 3000,1413 3291,1525 3562,1704 3795,1937 3974,2208 4086,2499 4125,2791 4086,3062 3974,3295 3795,3474 3562,3586 3291,3625 3000,3586 2708,3474 2437,2500 3000))"
    };

// Self-tangent pies (but as single-polygon, this one is NOT VALID and (therefore) (currently) NOT WORKING)
static std::string pie_5_12_12_0_7s[2] =
{
    "POLYGON((2500 2500,2500 3875,2855 3828,3187 3690,3472 3472,3690 3187,2500 2500))",
    "POLYGON((2500 2500,2500 1375,2208 1413,1937 1525,1704 1704,1525 1937,1413 2208,1375 2500,1413 2791,1525 3062,1704 3295,1937 3474,2208 3586,2500 2500,2791 3586,3062 3474,3295 3295,3474 3062,3586 2791,3625 2500,3586 2208,2500 2500))"
};


// Cases coming from High volume (hv) tests
static std::string hv_1[2] = {
    "POLYGON((24.995166778564453 50.011310577392578,46.630809783935547 37.494682312011719,46.661380767822266 12.499360084533691,25.003841400146484 0.020658308640122414,3.3419711589813232 12.491842269897461,3.3638687133789062 37.487174987792969,24.995166778564453 50.011310577392578))",
    "POLYGON((25.025228500366211 49.992599487304688,46.6719970703125 37.482185363769531,46.631874084472656 12.480358123779297,24.974153518676758 -0.011088892817497253,3.3419976234436035 12.524576187133789,3.3529467582702637 37.526435852050781,25.025228500366211 49.992599487304688))"
    };

static std::string hv_2[2] = {
    "POLYGON((24.988700866699219 49.986705780029297,46.643772125244141 37.5079345703125,46.645118713378906 12.514699935913086,25.010652542114258 0.00024537215358577669,3.3652000427246094 12.495694160461426,3.3445985317230225 37.488922119140625,24.988700866699219 49.986705780029297))",
    "POLYGON((24.993022918701172 49.977996826171875,46.643772125244141 37.503200531005859,46.634654998779297 12.51569938659668,25.005790710449219 0.0029967525042593479,3.3705389499664307 12.504646301269531,3.348651647567749 37.492141723632812,24.993022918701172 49.977996826171875))"
    };

static std::string hv_3[2] = {
    "POLYGON((25.007728576660156 49.988899230957031,46.667163848876953 37.501667022705078,46.637229919433594 12.500443458557129,24.993251800537109 -0.01356174610555172,3.3565254211425781 12.512973785400391,3.3410670757293701 37.514209747314453,25.007728576660156 49.988899230957031))",
    "POLYGON((24.998353958129883 49.993511199951172,46.659591674804688 37.507373809814453,46.646518707275391 12.505118370056152,25.002584457397461 -0.0109936548396945,3.3565335273742676 12.501456260681152,3.3392288684844971 37.503707885742188,24.998353958129883 49.993511199951172))"
    };

static std::string hv_4[2] = {
    "POLYGON((25.009130477905273 50.022209167480469,46.670387268066406 37.500617980957031,46.666873931884766 12.480625152587891,24.992231369018555 -0.017777863889932632,3.3260366916656494 12.495262145996094,3.3394229412078857 37.515254974365234,25.009130477905273 50.022209167480469))",
    "POLYGON((25.00263786315918 50.019630432128906,46.669231414794922 37.507579803466797,46.666202545166016 12.487733840942383,24.997152328491211 -0.020060751587152481,3.3308455944061279 12.492485046386719,3.3333024978637695 37.5123291015625,25.00263786315918 50.019630432128906))"
    };

static std::string hv_5[2] = {
    "POLYGON((24.987522125244141 49.997768402099609,46.643741607666016 37.509471893310547,46.654956817626953 12.510490417480469,25.011669158935547 -0.00019846600480377674,3.3563058376312256 12.489578247070313,3.3433761596679687 37.488559722900391,24.987522125244141 49.997768402099609))",
    "POLYGON((25.005760192871094 50.008182525634766,46.648590087890625 37.491542816162109,46.655918121337891 12.489977836608887,24.994773864746094 0.0050580352544784546,3.3391191959381104 12.499494552612305,3.3574333190917969 37.501052856445312,25.005760192871094 50.008182525634766))"
    };

static std::string hv_6[2] = {
    "POLYGON((25.011470794677734 50.017532348632813,42.678981781005859 42.661365509033203,50.017532348632813 24.986530303955078,42.661365509033203 7.3190178871154785,24.986530303955078 -0.019533095881342888,7.3190178871154785 7.336634635925293,-0.019533095881342888 25.011470794677734,7.336634635925293 42.678981781005859,25.011470794677734 50.017532348632813))",
    "POLYGON((25.002880096435547 50.013965606689453,46.671913146972656 37.507381439208984,46.660655975341797 12.488155364990234,24.9951171875 -0.024483053013682365,3.3334629535675049 12.494877815246582,3.3299689292907715 37.514102935791016,25.002880096435547 50.013965606689453))"
    };

static std::string hv_7[2] = {
    "POLYGON((24.983684539794922 49.995647430419922,46.643482208251953 37.513137817382813,46.654392242431641 12.51393985748291,25.014318466186523 -0.0027416276279836893,3.3589246273040771 12.487411499023438,3.3391971588134766 37.486602783203125,24.983684539794922 49.995647430419922))",
    "POLYGON((24.990163803100586 49.9993896484375,46.655281066894531 37.512466430664062,46.654388427734375 12.506458282470703,25.007841110229492 -0.012621366418898106,3.3524465560913086 12.491152763366699,3.3338801860809326 37.497154235839844,24.990163803100586 49.9993896484375))"
    };

static std::string dz_1[2] = {
    "POLYGON((30.526203155517578 56.781166076660156,38.987510681152344 58.710700988769531,41.042613983154297 50.279010772705078,48.390048980712891 45.660350799560547,43.881126403808594 38.245067596435547,45.810657501220703 29.783760070800781,37.378971099853516 27.728654861450195,32.760307312011719 20.381219863891602,25.345026016235352 24.890144348144531,16.883718490600586 22.960611343383789,14.828612327575684 31.392299652099609,7.481177806854248 36.010959625244141,11.990103721618652 43.426242828369141,10.060568809509277 51.887550354003906,18.492258071899414 53.942657470703125,23.110919952392578 61.290092468261719,30.526203155517578 56.781166076660156))",
    "POLYGON((12.580197334289551 33.274467468261719,14.852641105651855 24.577714920043945,21.524574279785156 30.601236343383789,18.734457015991211 22.056488037109375,27.603805541992188 23.51667594909668,20.636968612670898 17.836828231811523,28.887777328491211 14.270085334777832,19.956142425537109 13.258448600769043,24.968837738037109 5.7971897125244141,16.908138275146484 9.7749528884887695,17.091224670410156 0.78807485103607178,12.460672378540039 8.4923257827758789,7.7560214996337891 0.83309894800186157,8.0257854461669922 9.8177928924560547,-0.072908863425254822 5.9179673194885254,5.0115232467651367 13.330527305603027,-3.9099369049072266 14.42827033996582,4.3748917579650879 17.915260314941406,-2.5368332862854004 23.662046432495117,6.3180174827575684 22.116373062133789,3.6104514598846436 30.687637329101563,10.223971366882324 24.600040435791016,12.580197334289551 33.274467468261719))"
    };

static std::string dz_2[2] = {
    "POLYGON((24.587966918945313 61.027225494384766,32.1783447265625 62.988296508789063,34.655326843261719 55.550270080566406,41.730445861816406 52.173538208007812,38.846851348876953 44.883510589599609,42.096187591552734 37.748981475830078,35.201282501220703 34.018035888671875,33.104434967041016 26.46403694152832,25.42442512512207 28.037921905517578,18.962528228759766 23.599054336547852,14.090974807739258 29.741334915161133,6.2876262664794922 30.494592666625977,6.5039811134338379 38.331226348876953,1.0104535818099976 43.924152374267578,6.2134823799133301 49.788291931152344,5.6002583503723145 57.603889465332031,13.355405807495117 58.751640319824219,17.909420013427734 65.132911682128906,24.587966918945313 61.027225494384766))",
    "POLYGON((43.551433563232422 47.905071258544922,46.384872436523438 39.57366943359375,53.589195251464844 44.627212524414063,50.984420776367188 36.221515655517578,59.783241271972656 36.075325012207031,52.735191345214844 30.806018829345703,59.767654418945313 25.51593017578125,50.968441009521484 25.395713806152344,53.548389434814453 16.982362747192383,46.359016418457031 22.057153701782227,43.500991821289063 13.734155654907227,40.667552947998047 22.065553665161133,33.463230133056641 17.012012481689453,36.068000793457031 25.417709350585938,27.269184112548828 25.563901901245117,34.317234039306641 30.833206176757812,27.284770965576172 36.123294830322266,36.083980560302734 36.243511199951172,33.504035949707031 44.6568603515625,40.693408966064453 39.582073211669922,43.551433563232422 47.905071258544922))"
    };

static std::string dz_3[2] = {
    "POLYGON((20.813335418701172 73.060707092285156,22.815366744995117 61.968788146972656,31.383756637573242 69.291458129882813,28.001794815063477 58.539661407470703,38.991741180419922 61.041633605957031,31.000555038452148 53.093067169189453,41.894393920898437 50.201171875,31.124666213989258 46.876754760742188,39.426750183105469 39.253490447998047,28.345697402954102 41.314804077148438,32.154121398925781 30.706569671630859,23.300275802612305 37.681396484375,21.742572784423828 26.518407821655273,17.144247055053711 36.808895111083984,10.5772705078125 27.648460388183594,11.287883758544922 38.897186279296875,1.2160475254058838 33.837848663330078,7.0728073120117187 43.467861175537109,-4.1965517997741699 43.668655395507812,5.4646410942077637 49.473834991455078,-4.4205660820007324 54.888763427734375,6.8317971229553223 55.539215087890625,0.59532338380813599 64.927780151367187,10.861076354980469 60.274494171142578,9.7020368576049805 71.485885620117188,16.629419326782227 62.594875335693359,20.813335418701172 73.060707092285156))",
    "POLYGON((1.6459450721740723 46.720386505126953,10.693820953369141 61.892372131347656,7.2385158538818359 44.568569183349609,23.921955108642578 50.3751220703125,10.139513969421387 39.325347900390625,26.652151107788086 33.049518585205078,8.9915294647216797 33.444084167480469,17.606916427612305 18.02239990234375,4.3317174911499023 29.676681518554687,1.0186206102371216 12.32512378692627,-1.6595441102981567 29.785955429077148,-15.35089111328125 18.623508453369141,-6.1788778305053711 33.720771789550781,-23.842140197753906 33.970470428466797,-7.1116366386413574 39.639987945556641,-20.481979370117188 51.184993743896484,-4.0213727951049805 44.773937225341797,-6.8426628112792969 62.212215423583984,1.6459450721740723 46.720386505126953))"
    };

static std::string dz_4[2] = {
    "POLYGON((36.179050445556641 50.613166809082031,40.804176330566406 39.819438934326172,52.211421966552734 42.607097625732422,48.816398620605469 31.365650177001953,59.346733093261719 26.168684005737305,49.520126342773438 19.73951530456543,54.246284484863281 8.9896402359008789,42.586078643798828 10.381030082702637,39.296642303466797 -0.89176815748214722,31.258771896362305 7.6691346168518066,21.492900848388672 1.1480809450149536,20.83837890625 12.87275505065918,9.1656351089477539 14.154719352722168,16.200717926025391 23.557058334350586,8.0829076766967773 32.042194366455078,19.515800476074219 34.722743988037109,18.751338958740234 46.440761566162109,29.232465744018555 41.145256042480469,36.179050445556641 50.613166809082031))",
    "POLYGON((20.486696243286133 60.650150299072266,24.282432556152344 49.304500579833984,34.362251281738281 55.748767852783203,30.764263153076172 44.3388671875,42.706855773925781 43.627620697021484,33.089447021484375 36.511661529541016,42.333145141601563 28.916570663452148,30.369846343994141 28.81260871887207,33.383872985839844 17.234743118286133,23.644252777099609 24.182485580444336,19.277351379394531 13.044195175170898,15.48161506652832 24.389842987060547,5.40179443359375 17.945577621459961,8.9997835159301758 29.355476379394531,-2.9428071975708008 30.06672477722168,6.6745977401733398 37.182682037353516,-2.5690991878509521 44.777774810791016,9.394200325012207 44.881736755371094,6.3801741600036621 56.459602355957031,16.119794845581055 49.511859893798828,20.486696243286133 60.650150299072266))"
    };


// ticket_17 is keyholed, so has a hole formed by an deliberate intersection
// This will fail the intersection/traversal process
static std::string ticket_17[2] = {
    "POLYGON ((-122.28139163 37.37319149,-122.28100699 37.37273669,-122.28002186 37.37303123,-122.27979681 37.37290072,-122.28007349 37.37240493,-122.27977334 37.37220360,-122.27819720 37.37288580,-122.27714184 37.37275161,-122.27678628 37.37253167,-122.27766437 37.37180973,-122.27804382 37.37121453,-122.27687664 37.37101354,-122.27645829 37.37203386,-122.27604423 37.37249110,-122.27632234 37.37343339,-122.27760980 37.37391082,-122.27812478 37.37800320,-122.26117222 37.39121007,-122.25572289 37.39566631,-122.25547269 37.39564971,-122.25366304 37.39552993,-122.24919976 37.39580268,-122.24417933 37.39366907,-122.24051443 37.39094143,-122.23246277 37.38100418,-122.23606766 37.38141338,-122.24001587 37.37738940,-122.23666848 37.37609347,-122.23057450 37.37882170,-122.22679803 37.37807143,-122.22525727 37.37448817,-122.22523229 37.37443000,-122.23083199 37.37609347,-122.23033486 37.37777891,-122.23169030 37.37732117,-122.23229178 37.37709687,-122.23237761 37.37631249,-122.23297776 37.37438834,-122.23872850 37.37165986,-122.24044511 37.36934068,-122.24671067 37.36865847,-122.24825570 37.36981819,-122.25151719 37.36947713,-122.25357721 37.36756706,-122.26001451 37.36579354,-122.25615213 37.36545239,-122.25486458 37.36245083,-122.25357721 37.36108651,-122.25194642 37.36013139,-122.24885652 37.35958557,-122.24911401 37.35849399,-122.25357721 37.35808470,-122.25675286 37.35897159,-122.25855539 37.35753887,-122.26181687 37.35828939,-122.26713837 37.35897159,-122.26782510 37.36108651,-122.26662339 37.36456559,-122.27288911 37.36722601,-122.27366159 37.36531602,-122.27168740 37.36470213,-122.27391900 37.36374701,-122.27074326 37.36245083,-122.27134408 37.35951742,-122.27426240 37.36135926,-122.27709482 37.36115474,-122.27966974 37.36231438,-122.27958391 37.36463382,-122.27572152 37.36463382,-122.27563569 37.36524779,-122.27700899 37.36593000,-122.27709482 37.36763529,-122.27554978 37.36838573,-122.27667254 37.36931478,-122.27677932 37.36932073,-122.27769362 37.36853987,-122.27942490 37.36830803,-122.28178776 37.36677917,-122.28509559 37.36443500,-122.28845129 37.36413744,-122.29194403 37.36695946,-122.29382577 37.36726817,-122.29600414 37.36898512,-122.29733083 37.36995398,-122.29593239 37.37141436,-122.29416649 37.37075898,-122.29325026 37.37108436,-122.29652910 37.37311697,-122.29584237 37.37374461,-122.29537583 37.37573372,-122.29487677 37.37752502,-122.30923212 37.37593011,-122.31122484 37.38230086,-122.31467994 37.38092472,-122.31715663 37.38252181,-122.32307970 37.38166978,-122.31985618 37.37667694,-122.32210304 37.37580220,-122.32581446 37.37589532,-122.32401730 37.37331839,-122.32960417 37.37189020,-122.33465527 37.37331906,-122.33425328 37.37623680,-122.33620676 37.37726132,-122.33397986 37.37822382,-122.33358918 37.38036590,-122.33202637 37.37986918,-122.33147954 37.38101784,-122.33394080 37.38198017,-122.33545239 37.38587943,-122.33478058 37.38785697,-122.33386050 37.38723721,-122.33350041 37.38571137,-122.33122003 37.38548891,-122.33140008 37.38650606,-122.33366042 37.38817490,-122.33244019 37.39157602,-122.33298157 37.39419201,-122.33164013 37.39477028,-122.33202017 37.39518351,-122.33358038 37.39499282,-122.33376050 37.39597811,-122.33550067 37.39734478,-122.33556069 37.39481797,-122.33344040 37.39292676,-122.33638094 37.38892189,-122.34240644 37.38852719,-122.34906293 37.38726898,-122.35072321 37.39338769,-122.34910291 37.39445252,-122.34796272 37.39410291,-122.34449043 37.39640534,-122.34500223 37.39729709,-122.34936291 37.39670910,-122.35098322 37.39531066,-122.35364623 37.39554510,-122.35434369 37.39612111,-122.35798429 37.39600988,-122.35768430 37.39478621,-122.36334519 37.39206871,-122.36604726 37.39203267,-122.36778592 37.39335592,-122.36518870 37.40022011,-122.36554552 37.40247752,-122.36370519 37.40331974,-122.36270506 37.40530591,-122.36320512 37.40670418,-122.36149849 37.40851392,-122.36730580 37.41054938,-122.37263720 37.41378932,-122.37161871 37.42076600,-122.36566153 37.42006292,-122.36520547 37.42742106,-122.37165953 37.43661157,-122.35943972 37.44459022,-122.35356359 37.44600810,-122.33792254 37.45796329,-122.35228518 37.47478091,-122.35127080 37.48181199,-122.34867342 37.48487322,-122.34359717 37.48801082,-122.33388431 37.48677650,-122.33142321 37.48429747,-122.32929580 37.48473149,-122.32609609 37.48291144,-122.32344850 37.48228229,-122.31924364 37.48410234,-122.31677299 37.48114051,-122.31431751 37.47848973,-122.31259201 37.47682190,-122.31515972 37.47568196,-122.31691389 37.47360309,-122.31292494 37.46960081,-122.31130153 37.46937743,-122.30889894 37.47124987,-122.30612839 37.47011613,-122.30149630 37.46568378,-122.30064277 37.46363784,-122.29283821 37.45922376,-122.28630141 37.45415497,-122.28883099 37.44629920,-122.28316717 37.44197138,-122.27554148 37.42297597,-122.25597410 37.40553692,-122.25196579 37.40129593,-122.25012043 37.40049143,-122.24823207 37.39897758,-122.24754551 37.39740941,-122.24778582 37.39621607,-122.24934787 37.39599102,-122.25005170 37.39871849,-122.25222328 37.39863668,-122.25342491 37.39737529,-122.25520162 37.39667289,-122.25528737 37.39522726,-122.27747460 37.37809616,-122.27977493 37.37858717,-122.28157729 37.37920106,-122.28322534 37.37952846,-122.28416939 37.38092656,-122.28621223 37.37984219,-122.28638389 37.37613857,-122.28382607 37.37843722,-122.27930278 37.37718220,-122.28196361 37.37652740,-122.28295058 37.37568167,-122.28216101 37.37523148,-122.28114822 37.37543608,-122.27934569 37.37528613,-122.27996369 37.37448121,-122.28104521 37.37454944,-122.28185197 37.37422883,-122.28290767 37.37474038,-122.28376597 37.37467224,-122.28428104 37.37399012,-122.28402346 37.37338989,-122.28610922 37.37364914,-122.28651264 37.37327388,-122.28672722 37.37207343,-122.28628398 37.37205448,-122.28574460 37.37166682,-122.28479711 37.37200981,-122.28327731 37.37137228,-122.28285511 37.37100700,-122.28279409 37.37125669,-122.28315527 37.37173756,-122.28321872 37.37220569,-122.28187007 37.37231918,-122.28193109 37.37294908,-122.28139163 37.37319149))",
    "BOX(-122.280 37.377,-122.277 37.379)"};

static std::string snl_1[2] = {
    "POLYGON((184913.4512 606985.7794,184912.9 606987.146,184904.4135 606987.6514,184901.8476 607014.5934,184916.3978 607021.0602,184927.7148 607008.1264,184926.0981 606998.4262,184913.4512 606985.7794),(184907.556 607013.301,184905.782 607009.972,184906.004 607005.978,184908.444 606998.877,184912.215 606994.218,184919.314 606993.996,184922.42 606995.771,184925.747 606998.877,184926.413 607002.872,184925.747 607007.753,184922.42 607012.191,184917.096 607015.298,184911.771 607015.298,184907.556 607013.301))",
    "POLYGON((184861.118 606901.158,184893.787 606898.483,184925.043 606913.4,184927.174 606951.759,184912.9 606987.146,184877.87 606989.232,184885.103 607023.774,184899.058 607022.743,184906.008 607044.948,184966.465 607025.02,184968.442 606961.3,185024.768 606947.402,185024.544 606941.355,185027.007 606937.323,185030.366 606934.187,185035.516 606933.963,185040.442 606935.531,185042.905 606939.115,185088.364 606931.385,185089.139 607015.509,185095.2 607011.3,185118.827 606995.545,185126.813 606991.995,185177.727 606973.799,185181.482 606966.676,185193.571 606977.795,185193.711 606960.3,185189.352 606779.02,185167.515 606783.844,185086.96 606801.241,185011.707 606817.809,185000 606819.304,184994.034 606819.794,184976.398 606819.572,184956.654 606817.131,184934.913 606813.137,184893.097 606804.927,184884.445 606831.555,184866.919 606883.481,184861.118 606901.158),(184907.556 607013.301,184905.782 607009.972,184906.004 607005.978,184908.444 606998.877,184912.215 606994.218,184919.314 606993.996,184922.42 606995.771,184925.747 606998.877,184926.413 607002.872,184925.747 607007.753,184922.42 607012.191,184917.096 607015.298,184911.771 607015.298,184907.556 607013.301))"};


// Isovist (submitted by Brandon during Formal Review)
static std::string isovist[2] =
    {
    "POLYGON((37.29449462890625 1.7902572154998779,  46.296027072709599 -2.4984308554828116,  45.389434814453125 -4.5143837928771973,  47.585065917176543 -6.1314922196594779,  46.523914387974358 -8.5152102535033496,  42.699958801269531 -4.4278755187988281,  42.577877044677734 -4.4900407791137695,  42.577911376953125 -4.4901103973388672,  40.758884429931641 -5.418975830078125,  40.6978759765625 -5.4500408172607422,  41.590042114257813 -7.2021245956420898,  57.297810222148939 -37.546793343968417,  50.974888957147442 -30.277285722290763,  37.140213012695313 1.3446992635726929,  37.000419616699219 1.664225697517395,  37.29449462890625 1.7902572154998779))",
    "POLYGON((43.644271850585938 0.96149998903274536,43.764598846435547 0.93951499462127686,49.071769542946825 0.61489892713413252,48.43512638981781 -0.81299959072453376,47.830955505371094 -0.69758313894271851,47.263670054709685 -1.784876824891044,46.695858001708984 -1.6093428134918213,45.389434814453125 -4.5143837928771973,47.604561877161387 -6.087697464505224,46.559533858616469 -8.435196445683264,42.699958801269531 -4.4278755187988281,42.577877044677734 -4.4900407791137695,42.577911376953125 -4.4901103973388672,40.758884429931641 -5.418975830078125,40.6978759765625 -5.4500408172607422,41.590042114257813 -7.2021245956420898,57.524304765518266 -37.807195733984784,41.988733475572282 -19.945838749437218,41.821544647216797 -19.211688995361328,40.800632476806641 -17.208097457885742,39.966808319091797 -17.625011444091797,38.823680877685547 -16.296066284179688,37.326129913330078 -17.190576553344727,35.963497161865234 -15.476018905639648,35.656356811523438 -15.66030216217041,34.931102752685547 -16.223842620849609,34.634240447128811 -15.85007183479255,34.886280059814453 -14.120697975158691,34.658355712890625 -13.81736946105957,34.328716278076172 -13.992490768432617,33.598796844482422 -14.546377182006836,33.164891643669634 -14.000060288415174,33.566280364990234 -12.450697898864746,33.339523315429688 -12.147735595703125,32.998821258544922 -12.323249816894531,32.274600982666016 -12.879127502441406,31.682494778186321 -12.133624901803865,32.226280212402344 -10.790698051452637,32.000633239746094 -10.488097190856934,31.669155120849609 -10.653837203979492,30.947774887084961 -11.208560943603516,30.207040612748258 -10.275926149505661,30.896280288696289 -9.1206979751586914,30.670633316040039 -8.8180980682373047,30.339155197143555 -8.9838371276855469,29.619997024536133 -9.5368013381958008,29.135100397190627 -8.9262827849488211,32.718830108642578 -4.3281683921813965,32.708168029785156 -2.3611698150634766,32.708126068115234 -2.3611700534820557,32.708126068115234 -2.3611266613006592,30.501169204711914 -2.3718316555023193,27.069889344709196 -4.2926591211028242,26.472516656201325 -3.5380830513658776,36.954700469970703 1.2597870826721191,37.140213012695313 1.3446992635726929,37.000419616699219 1.664225697517395,37.29449462890625 1.7902572154998779,37.43402099609375 1.470055103302002,51.370888500897557 7.4163459734570729,51.20102152843122 7.1738039562841562,42.721500396728516 3.6584999561309814,42.721500396728516 2.2342472076416016,42.399410247802734 1.4956772327423096,43.644271850585938 0.96149998903274536))"
    };

static std::string ggl_list_20110306_javier[2] =
    {
    "POLYGON((-2 2,2002 2,2002 -2002,-2 -2002,-2 2),(0 -147.00000000000003,0 -2000,2000 -2000,2000 0,104 0,440 -240,400 -280,0 -147.00000000000003))",
    "POLYGON((359.99000000000001 -280,0 -182,0 -147,400.00999999999999 -280,359.99000000000001 -280))"
    };
    
static std::string ggl_list_20110307_javier[2] =
    {
    "POLYGON((-2 2, 1842 2, 1842 -2362, -2 -2362, -2 2), (0 0, 0 -2360, 1840 -2360, 1840 0, 0 0))",
    // "POLYGON((-0.01 -1960, 0 -1960, 0 -1880, 0.01 -1960, -0.01 -1960))"
    "POLYGON ((-0.01 -1960, 80.01 -1960, 0 -1880, -0.01 -1960))"
    };
    

static std::string ggl_list_20110627_phillip[2] =
    {
    "POLYGON((537.99678544791459 124.30517362077681,437.36539413622404 142.02728895075373,456.33031803043468 249.50296671450121,556.96217263181723 231.78347688272990,537.99678544791459 124.30517362077681))",
    "POLYGON((437.35 142.03,461.94 281.32,564.5 263.26,539.9 123.97,437.35 142.03))"
    };

static std::string ggl_list_20110716_enrico[2] =
    {
    "POLYGON((1.83691e-014 -300,-259.808 -150,-259.808 150,-5.51073e-014 300,259.808 150,259.808 -150,9.18455e-014 -300,1.83691e-014 -300),(7.65379e-014 -250,216.506 -125,216.506 125,-4.59227e-014 250,-216.506 125,-216.506 -125,1.53076e-014 -250,7.65379e-014 -250))",
    "POLYGON((1.83691e-014 -300,-259.808 -150,-216.506 -125,-216.506 125,-259.808 150,-5.51073e-014 300,-4.59227e-014 250,216.506 125,259.808 150,259.808 -150,216.506 -125,7.65379e-014 -250,9.18455e-014 -300,1.83691e-014 -300),(6.12303e-014 -200,173.205 -100,173.205 100,-3.67382e-014 200,-173.205 100,-173.205 -100,1.22461e-014 -200,6.12303e-014 -200))"
    };


// Send on ggl-list by Christoph/Angus at 2011-08-19/20
// This polygon combination fails to union in <float> but do in <double> or <ttmath>
// It had previosly an error which has been fixed at 2011-08-30
static std::string ggl_list_20110820_christophe[2] = 
{
    "POLYGON((17.763942722600319 32.23605727739968,19.192448808558737 30.807551191441263,16.000000000000000 30.000000000000000,17.763942722600319 32.236057277399681))",
    "POLYGON((0.24806946917841693 26.015444246572663,31.751930530821582 33.984555753427337,32.248069469178418 30.015444246572663,0.24806946917841693 26.015444246572663))" 
};


// GEOS "TestOverlay" test.
// Note that the first one WAS invalid and is made valid using SQL Server 2008 Spatial MakeValid() function
static std::string geos_1_test_overlay[2] =
    {
        // Original: POLYGON((5417148.108 5658342.603,5417139.016 5658338.009,5417126.791 5658331.833,5417116.292 5658327.518,5417112.871 5658325.598,5417110.25  5658324.127,5417106.071 5658321.781,5417104.226 5658320.745,5417093.266  5658315.008,5417091.265 5658313.961,5417085.335 5658310.857,5417060.44  5658326.26,5417064.68 5658327.52,5417088.83 5658336.46,5417088.52  5658337.31,5417102.92 5658342.65,5417103.26 5658341.83,5417111.76  5658345.51,5417121.662 5658349.583,5417121.878 5658349.672,5417125.217  5658351.119,5417131.761 5658353.388,5417137.589 5658356.276,5417142.166  5658359.67,5417146.599 5658364.988,5417151.395 5658370.641,5417150.853  5658371.392,5417152.59741167 5658373.52811061,5417154.92  5658376.37,5417155.18955743 5658376.89699992,5417154.919 5658376.371,5417155.814  5658378.111,5417157.051 5658380.297,5417158.004 5658382.304,5417159.014  5658384.47,5417159.775 5658386.619,5417160.629 5658389.278,5417161.5  5658399.49,5417160.773 5658404.194,5417159.41 5658413.02,5417158.853  5658414.442,5417153.671 5658427.659,5417153.67051161 5658427.6586943,5417153.67  5658427.66,5417152.73 5658427.07,5417149.993 5658436.599,5417148.81  5658439.42,5417149.233 5658439.67,5417148.36 5658440.81,5417146.41  5658446.6,5417144.321 5658453.127,5417144.32092232 5658453.13043826,5417154.59  5658458.01,5417154.99551047 5658455.8409905,5417155.446  5658453.413,5417157.23981414 5658448.75748237,5417157.22660892  5658448.57861162,5417157.22660849 5658448.57860592,5417157.22660865  5658448.57860812,5417157.128 5658447.265,5417157.64950997  5658446.06368023,5417157.64950961 5658446.06368108,5417158.314  5658444.533,5417172.322 5658417.957,5417174.99 5658418.57,5417175.23  5658417.74,5417176.696 5658412.61,5417177.875 5658408.488,5417178.76  5658405.39,5417178.1 5658393.55,5417178.08 5658393.36,5417177.11  5658384.95,5417178.151 5658384.915,5417178.14836289 5658384.91508866,5417178.12  5658384.83,5417177.91415246 5658383.81114117,5417176.927 5658378.944,5417176.603  5658377.341,5417176.73975922 5658378.01762048,5417176.6  5658377.34,5417176.51210558 5658376.89535766,5417176.428 5658376.483,5417175.235  5658370.602,5417171.577 5658362.886,5417170.762 5658360.107,5417168.522  5658357.989,5417166.042 5658355.047,5417164.137 5658352.264,5417162.642  5658351.593,5417160.702 5658350.843,5417160.05417889 5658350.5823586,5417158.82  5658350.09,5417158.82103105 5658350.0862195,5417159.50373263  5658350.36089455,5417158.818 5658350.085,5417159.055 5658349.214,5417155.754  5658347.679,5417156.78066321 5658348.15640928,5417155.7525011  5658347.6811561,5417155.161 5658348.532,5417149.028 5658343.237,5417152.26877967  5658346.03496647,5417149.03 5658343.24,5417148.78133339  5658343.06701453,5417148.108 5658342.603))
    "POLYGON((5417085.33499 5658310.85699,5417060.44 5658326.26001,5417064.67999 5658327.52002,5417088.82999 5658336.46002,5417088.51999 5658337.31,5417102.92001 5658342.65002,5417103.26001 5658341.83002,5417111.76001 5658345.51001,5417121.66199 5658349.58301,5417121.87799 5658349.672,5417125.21701 5658351.11902,5417131.76099 5658353.388,5417137.58899 5658356.276,5417142.16599 5658359.66998,5417146.599 5658364.98798,5417151.39499 5658370.64099,5417150.853 5658371.39203,5417152.59741 5658373.52814,5417154.92001 5658376.37,5417155.18806 5658376.89407,5417155.814 5658378.11102,5417157.05099 5658380.297,5417158.004 5658382.30402,5417159.01401 5658384.46997,5417159.77499 5658386.61902,5417160.629 5658389.27802,5417161.5 5658399.48999,5417160.77301 5658404.19397,5417159.41 5658413.02002,5417158.853 5658414.44202,5417153.67099 5658427.659,5417153.6705 5658427.65869,5417153.67001 5658427.65997,5417152.73001 5658427.07001,5417149.99301 5658436.599,5417148.81 5658439.41998,5417149.233 5658439.66998,5417148.35999 5658440.81,5417146.41 5658446.59998,5417144.32101 5658453.12701,5417144.32092 5658453.13043,5417154.59 5658458.01001,5417154.99551 5658455.841,5417155.44601 5658453.41302,5417157.23981 5658448.75751,5417157.22662 5658448.57861,5417157.12799 5658447.26501,5417157.64951 5658446.06366,5417158.314 5658444.53302,5417172.32199 5658417.95697,5417174.98999 5658418.57001,5417175.23001 5658417.73999,5417176.69601 5658412.60999,5417177.875 5658408.48798,5417178.76001 5658405.39001,5417178.10001 5658393.54999,5417178.07999 5658393.35999,5417177.10999 5658384.95001,5417178.14837 5658384.91507,5417178.12 5658384.83002,5417177.91415 5658383.81116,5417176.927 5658378.94397,5417176.603 5658377.341,5417176.73975 5658378.01764,5417176.60001 5658377.34003,5417176.51212 5658376.89539,5417176.42801 5658376.48297,5417175.23499 5658370.60199,5417171.577 5658362.88599,5417170.76199 5658360.10699,5417168.522 5658357.98901,5417166.04199 5658355.047,5417164.13699 5658352.26398,5417162.642 5658351.59302,5417160.702 5658350.84302,5417160.05417 5658350.58234,5417158.82001 5658350.09003,5417158.82104 5658350.08625,5417158.81799 5658350.08502,5417159.05499 5658349.21399,5417155.754 5658347.67902,5417156.78067 5658348.15643,5417155.7525 5658347.68115,5417155.16101 5658348.53198,5417149.02802 5658343.237,5417152.26877 5658346.03497,5417149.03 5658343.23999,5417148.78134 5658343.06702,5417148.108 5658342.60303,5417139.01599 5658338.00897,5417126.79099 5658331.83301,5417116.29199 5658327.51801,5417112.871 5658325.59802,5417110.25 5658324.12701,5417106.07101 5658321.78101,5417104.22601 5658320.745,5417093.26599 5658315.008,5417091.26501 5658313.961,5417085.33499 5658310.85699))",
    "POLYGON((5417148.36 5658440.81,5417146.41 5658446.6,5417144.321 5658453.127,5417144.32092 5658453.13044,5417154.59 5658458.01,5417154.99551 5658455.84099,5417155.446 5658453.413,5417157.23981 5658448.75748,5417157.22661 5658448.57861,5417157.128 5658447.265,5417157.64951 5658446.06368,5417158.31 5658444.53,5417172.32 5658417.96,5417172.32037 5658417.96009,5417172.322 5658417.957,5417174.99 5658418.57,5417175.23 5658417.74,5417176.696 5658412.61,5417177.875 5658408.488,5417178.76 5658405.39,5417178.1 5658393.55,5417178.08 5658393.36,5417177.11 5658384.95,5417178.14836 5658384.91509,5417178.12 5658384.83,5417177.91415 5658383.81114,5417176.927 5658378.944,5417176.73976 5658378.01762,5417176.6 5658377.34,5417176.51211 5658376.89536,5417176.428 5658376.483,5417175.235 5658370.602,5417171.577 5658362.886,5417171.26172 5658361.81094,5417170.76 5658360.11,5417168.52 5658357.99,5417166.04 5658355.05,5417165.25343 5658353.89499,5417164.137 5658352.264,5417162.642 5658351.593,5417160.702 5658350.843,5417160.05418 5658350.58236,5417158.82 5658350.09,5417158.82103 5658350.08622,5417158.818 5658350.085,5417159.055 5658349.214,5417156.78066 5658348.15641,5417155.7525 5658347.68116,5417155.161 5658348.532,5417152.26878 5658346.03497,5417149.03 5658343.24,5417148.78133 5658343.06701,5417148.108 5658342.603,5417139.016 5658338.009,5417126.791 5658331.833,5417121.76604 5658329.76779,5417116.29 5658327.52,5417112.87 5658325.6,5417110.25 5658324.13,5417106.60319 5658322.07976,5417106.071 5658321.781,5417105.81727 5658321.63853,5417104.23 5658320.75,5417093.61267 5658315.18946,5417093.266 5658315.008,5417091.265 5658313.961,5417085.9075 5658311.15667,5417085.34 5658310.86,5417060.44 5658326.26,5417064.68 5658327.52,5417088.83 5658336.46,5417088.52 5658337.31,5417102.92 5658342.65,5417103.26 5658341.83,5417111.76 5658345.51,5417121.66 5658349.58,5417121.88 5658349.67,5417125.22 5658351.12,5417125.33012 5658351.15822,5417131.761 5658353.388,5417137.589 5658356.276,5417139.98755 5658358.0546,5417142.17 5658359.67,5417145.96673 5658364.22951,5417146.599 5658364.988,5417147.11101 5658365.5915,5417151.4 5658370.64,5417151.13021 5658371.0079,5417150.853 5658371.392,5417152.5974 5658373.5281,5417154.92 5658376.37,5417155.18956 5658376.897,5417155.814 5658378.111,5417157.051 5658380.297,5417158.004 5658382.304,5417159.014 5658384.47,5417159.36624 5658385.46469,5417159.78 5658386.62,5417160.63 5658389.28,5417161.5 5658399.49,5417160.773 5658404.194,5417159.41 5658413.02,5417158.853 5658414.442,5417153.671 5658427.659,5417153.67051 5658427.65869,5417153.67 5658427.66,5417152.73 5658427.07,5417149.993 5658436.599,5417148.81 5658439.42,5417149.233 5658439.67,5417148.36 5658440.81))"
    };

// Coming from "robustness.xml"
static std::string geos_2[2] =
    {
    "POLYGON((742605.987032656 5087763.72510381,742599.903121688 5087760.56016809,742598.666141033 5087762.50894352,742591.100910753 5087758.50480931,742586.861672536 5087766.63211263,742591.417801844 5087769.04526206,742592.428792606 5087767.35034731,742601.541294342 5087772.18101105,742605.987032656 5087763.72510381))",
    "POLYGON((742601.541294537 5087772.18101068,742592.428792606 5087767.35034731,742589.944404072 5087771.51539701,742583.880455986 5087782.54873438,742582.81550675 5087784.27809355,742583.216887765 5087784.43459684,742582.99081514 5087785.0349637,742592.341351823 5087789.67654,742593.375823205 5087787.7060691,742599.28794443 5087776.4640487,742601.541294537 5087772.18101068))"
    };

// Coming from "robustness.xml"
static std::string geos_3[2] =
    {
    "POLYGON ((613697.0000000041909516 2369267.9999981997534633, 613797.0000000043073669 2368322.9999981978908181, 613643.0000000041909516 2367807.9999981969594955, 613674.0000000041909516 2367405.9999981969594955, 613400.0000000041909516 2367299.9999981955625117, 613200.0000000040745363 2366813.9999981950968504, 613252.0000000040745363 2366474.9999981927685440, 613094.0000000040745363 2366400.9999981927685440, 612695.0000000039581209 2365506.9999981909058988, 612326.0000000038417056 2365402.9999981909058988, 612145.0000000037252903 2365470.9999981913715601, 612061.0000000037252903 2365967.9999981918372214, 611724.0000000036088750 2366168.9999981927685440, 611334.0000000034924597 2366316.9999981927685440, 610743.0000000033760443 2366221.9999981932342052, 610174.0000000031432137 2366305.9999981927685440, 609973.0000000031432137 2367066.9999981955625117, 609073.0000000027939677 2367938.9999981974251568, 609061.0000000027939677 2368332.9999981974251568, 609151.0000000027939677 2368684.9999981992878020, 608919.0000000027939677 2368811.9999982002191246, 608801.0000000026775524 2369192.9999982002191246, 609161.0000000027939677 2369096.9999982006847858, 609161.0000000027939677 2369509.9999982025474310, 609857.0000000030267984 2369498.9999982011504471, 609762.0000000030267984 2369689.9999982020817697, 610796.0000000033760443 2369794.9999982025474310, 611332.0000000034924597 2370097.9999982025474310, 613149.0000000040745363 2370460.9999982034787536, 613613.0000000041909516 2369720.9999982016161084, 613697.0000000041909516 2369267.9999981997534633))",
    "POLYGON ((607216.0000000019790605 2370623.9999982002191246, 608128.0000000019790605 2370312.9999982002191246, 608317.0000000030267984 2370101.9999982002191246, 608328.0000000030267984 2369868.9999982002191246, 608644.0000000030267984 2369847.9999982002191246, 608801.0000000030267984 2369192.9999982002191246, 608919.0000000030267984 2368811.9999982002191246, 609151.0000000030267984 2368684.9999982002191246, 609061.0000000030267984 2368332.9999982002191246, 608602.0000000030267984 2368124.9999982002191246, 607980.0000000019790605 2367585.9999982002191246, 607295.0000000019790605 2367062.9999981899745762, 606251.0000000019790605 2366697.9999981899745762, 605456.0000000019790605 2367679.9999982002191246, 605108.0000000019790605 2368377.9999982002191246, 604906.0000000019790605 2369083.9999982002191246, 604191.0000000010477379 2369719.9999982002191246, 604107.0000000010477379 2370057.9999982002191246, 604264.0000000010477379 2370397.9999982002191246, 604141.0000000010477379 2370768.9999982002191246, 604561.0000000010477379 2370448.9999982002191246, 604940.0000000019790605 2370406.9999982002191246, 605460.0000000019790605 2370792.9999982002191246, 605942.0000000019790605 2370945.9999982099980116, 606364.0000000019790605 2370892.9999982002191246, 606881.0000000019790605 2370988.9999982002191246, 607216.0000000019790605 2370623.9999982002191246))"
    };

// Coming from "TestRobustOverlayFixed.xml"
static std::string geos_4[2] =
    {
    "POLYGON ((545 317, 617 379, 581 321, 545 317))",
    "POLYGON ((484 290, 558 359, 543 309, 484 290))"
    };

static std::string ticket_5103[2] =
    {
    "POLYGON((-92810838 3618230,-94606872 1822196,-94999302 2214626,-93203268 4010660,-92810838 3618230))",
    "POLYGON((-95269304 222758,-95260668 419862,-95234760 615696,-95192088 808228,-95132906 996442,-95057214 1178814,-94966028 1354074,-94860110 1520444,-94739968 1676908,-94606618 1822450,-94999048 2214880,-95165164 2033778,-95314770 1838706,-95446850 1631442,-95560388 1413510,-95654368 1186434,-95728282 951992,-95781368 711962,-95813626 468376,-95824294 222758,-95269304 222758))"
    };

static std::string ggl_list_20120229_volker[3] =
    {
    "POLYGON((1716 1554,2076 2250,2436 2352,2796 1248,3156 2484,3516 2688,3516 2688,3156 2484,2796 1248,2436 2352,2076 2250, 1716 1554))",
    "POLYGON((2500 1600,2500 2300,3200 2300,3200 1600,2500 1600))",
    "POLYGON((1716 1554,2076 2250,2436 2352,2796 1248,3156 2484,3516 2688,3156 2483,2796 1247,2436 2351,2076 2249, 1716 1554))",
    };

static std::string buffer_rt_a[2] =
    {
    "POLYGON((1 7,1 8,1.0012 8.04907,1.00482 8.09802,1.01082 8.14673,1.01921 8.19509,1.02997 8.24298,1.04306 8.29028,1.05846 8.33689,1.07612 8.38268,1.09601 8.42756,1.11808 8.4714,1.14227 8.5141,1.16853 8.55557,1.19679 8.5957,1.22699 8.63439,1.25905 8.67156,1.29289 8.70711,1.32844 8.74095,1.36561 8.77301,1.4043 8.80321,1.44443 8.83147,1.4859 8.85773,1.5286 8.88192,1.57244 8.90399,1.61732 8.92388,1.66311 8.94154,1.70972 8.95694,1.75702 8.97003,1.80491 8.98079,1.85327 8.98918,1.90198 8.99518,1.95093 8.9988,2 9,3 9,3.04907 8.9988,3.09802 8.99518,3.14673 8.98918,3.19509 8.98079,3.24298 8.97003,3.29028 8.95694,3.33689 8.94154,3.38268 8.92388,3.42756 8.90399,3.4714 8.88192,3.5141 8.85773,3.55557 8.83147,3.5957 8.80321,3.63439 8.77301,3.67156 8.74095,3.70711 8.70711,3.74095 8.67156,3.77301 8.63439,3.80321 8.5957,3.83147 8.55557,3.85773 8.5141,3.88192 8.4714,3.90399 8.42756,3.92388 8.38268,3.94154 8.33689,3.95694 8.29028,3.97003 8.24298,3.98079 8.19509,3.98918 8.14673,3.99518 8.09802,3.9988 8.04907,4 8,4 7,3.9988 6.95093,3.99518 6.90198,3.98918 6.85327,3.98079 6.80491,3.97003 6.75702,3.95694 6.70972,3.94154 6.66311,3.92388 6.61732,3.90399 6.57244,3.88192 6.5286,3.85773 6.4859,3.83147 6.44443,3.80321 6.4043,3.77301 6.36561,3.74095 6.32844,3.70711 6.29289,3.67156 6.25905,3.63439 6.22699,3.5957 6.19679,3.55557 6.16853,3.5141 6.14227,3.4714 6.11808,3.42756 6.09601,3.38268 6.07612,3.33689 6.05846,3.29028 6.04306,3.24298 6.02997,3.19509 6.01921,3.14673 6.01082,3.09802 6.00482,3.04907 6.0012,3 6,2 6,1.95093 6.0012,1.90198 6.00482,1.85327 6.01082,1.80491 6.01921,1.75702 6.02997,1.70972 6.04306,1.66311 6.05846,1.61732 6.07612,1.57244 6.09601,1.5286 6.11808,1.4859 6.14227,1.44443 6.16853,1.4043 6.19679,1.36561 6.22699,1.32844 6.25905,1.29289 6.29289,1.25905 6.32844,1.22699 6.36561,1.19679 6.4043,1.16853 6.44443,1.14227 6.4859,1.11808 6.5286,1.09601 6.57244,1.07612 6.61732,1.05846 6.66311,1.04306 6.70972,1.02997 6.75702,1.01921 6.80491,1.01082 6.85327,1.00482 6.90198,1.0012 6.95093,1 7))",
    "POLYGON((3 6,4 6,4.04907 5.9988,4.09802 5.99518,4.14673 5.98918,4.19509 5.98079,4.24298 5.97003,4.29028 5.95694,4.33689 5.94154,4.38268 5.92388,4.42756 5.90399,4.4714 5.88192,4.5141 5.85773,4.55557 5.83147,4.5957 5.80321,4.63439 5.77301,4.67156 5.74095,4.70711 5.70711,4.74095 5.67156,4.77301 5.63439,4.80321 5.5957,4.83147 5.55557,4.85773 5.5141,4.88192 5.4714,4.90399 5.42756,4.92388 5.38268,4.94154 5.33689,4.95694 5.29028,4.97003 5.24298,4.98079 5.19509,4.98918 5.14673,4.99518 5.09802,4.9988 5.04907,5 5,5 4,4.9988 3.95093,4.99518 3.90198,4.98918 3.85327,4.98079 3.80491,4.97003 3.75702,4.95694 3.70972,4.94154 3.66311,4.92388 3.61732,4.90399 3.57244,4.88192 3.5286,4.85773 3.4859,4.83147 3.44443,4.80321 3.4043,4.77301 3.36561,4.74095 3.32844,4.70711 3.29289,4.67156 3.25905,4.63439 3.22699,4.5957 3.19679,4.55557 3.16853,4.5141 3.14227,4.4714 3.11808,4.42756 3.09601,4.38268 3.07612,4.33689 3.05846,4.29028 3.04306,4.24298 3.02997,4.19509 3.01921,4.14673 3.01082,4.09802 3.00482,4.04907 3.0012,4 3,3 3,3 3,2 3,1.95093 3.0012,1.90198 3.00482,1.85327 3.01082,1.80491 3.01921,1.75702 3.02997,1.70972 3.04306,1.66311 3.05846,1.61732 3.07612,1.57244 3.09601,1.5286 3.11808,1.4859 3.14227,1.44443 3.16853,1.4043 3.19679,1.36561 3.22699,1.32844 3.25905,1.29289 3.29289,1.25905 3.32844,1.22699 3.36561,1.19679 3.4043,1.16853 3.44443,1.14227 3.4859,1.11808 3.5286,1.09601 3.57244,1.07612 3.61732,1.05846 3.66311,1.04306 3.70972,1.02997 3.75702,1.01921 3.80491,1.01082 3.85327,1.00482 3.90198,1.0012 3.95093,1 4,1 5,1.0012 5.04907,1.00482 5.09802,1.01082 5.14673,1.01921 5.19509,1.02997 5.24298,1.04306 5.29028,1.05846 5.33689,1.07612 5.38268,1.09601 5.42756,1.11808 5.4714,1.14227 5.5141,1.16853 5.55557,1.19679 5.5957,1.22699 5.63439,1.25905 5.67156,1.29289 5.70711,1.32844 5.74095,1.36561 5.77301,1.4043 5.80321,1.44443 5.83147,1.4859 5.85773,1.5286 5.88192,1.57244 5.90399,1.61732 5.92388,1.66311 5.94154,1.70972 5.95694,1.75702 5.97003,1.80491 5.98079,1.85327 5.98918,1.90198 5.99518,1.95093 5.9988,2 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6,3 6))"
    };

static std::string buffer_rt_f[2] =
    {
        "POLYGON((-0.29999999999999999 6.0000000000000000,-0.29999999999999999 7.0000000000000000,-0.30000000000000027 7.7242640687119302,0.21213203435596423 7.2121320343559638,1.2121320343559643 6.2121320343559638,1.7242640687119293 5.7000000000000002,1.0000000000000000 5.7000000000000002,0.00000000000000000 5.7000000000000002,-0.30000000000000027 5.7000000000000002,-0.29999999999999999 6.0000000000000000))",
        "POLYGON((1.3000000000000000 9.0000000000000000,1.3000000000000000 8.0000000000000000,1.3000000000000007 7.7000000000000002,1.0000000000000000 7.7000000000000002,0.00000000000000000 7.7000000000000002,-0.29999999999999982 7.7000000000000002,-0.29999999999999999 8.0000000000000000,-0.29999999999999999 9.0000000000000000,-0.29999999999999982 9.3000000000000007,0.00000000000000000 9.3000000000000007,1.0000000000000000 9.3000000000000007,1.3000000000000007 9.3000000000000007,1.3000000000000000 9.0000000000000000))"
    };

static std::string buffer_rt_g[2] =
    {
        "POLYGON((2.0 8.0,2.0 9.0,2.0 10.0,3.0 10.0,4.0 10.0,6.4142135623730958 10.0,4.7071067811865479 8.2928932188134521,3.7071067811865475 7.2928932188134521,2.0 5.5857864376269051,2.0 8.0))",
        "POLYGON((0.0 6.0,0.0 7.0,0.0 8.0,1.0 8.0,2.0 8.0,4.4142135623730958 8.0,2.7071067811865475 6.2928932188134521,1.7071067811865475 5.2928932188134521,-0.0 3.5857864376269042,0.0 6.0))"
    };

static std::string buffer_rt_g_boxes[5] =
    {
        "POLYGON((0 0,0 4,4 4,4 0,0 0))",
        "POLYGON((2 2,2 4,6 4,6 2,2 2))",
        "POLYGON((2 2,2 4,6 4,8 4,8 2,2 2))",
        "POLYGON((2 2,2 4,6 4,6 6,8 6,8 2,2 2))",

        "POLYGON((0 0,0 4,4 4,4 5,5 5,5 1,4 1,4 0,0 0))"
    };

// From buffer-robustness-test with segment-intersection "touching" with r ~ 1.16
static std::string buffer_rt_i[2] =
    {
        "POLYGON((1.0 1.0,1.0 2.0,1.0 3.0,2.0 3.0,3.0 3.0,5.4142135623730949 3.0,3.7071067811865475 1.2928932188134525,2.7071067811865475 0.29289321881345254,1.0 -1.4142135623730949,1.0 1.0))",
        "POLYGON((2.0 2.0,2.0 3.0,2.0 4.0,3.0 4.0,4.0 4.0,6.4142135623730958 4.0,4.7071067811865479 2.2928932188134525,3.7071067811865475 1.2928932188134525,2.0 -0.41421356237309387,2.0 2.0))"
    };

// Idem, but with a touch-in-the-middle
static std::string buffer_rt_j[2] =
    {
        "POLYGON((1.0 4.0,1.0 5.0,1.0 6.0,2.0 6.0,3.0 6.0,5.4142135623730967 6.0,3.7071067811865475 4.2928932188134521,2.7071067811865475 3.2928932188134525,1.0 1.5857864376269055,1.0 4.0))",
        "POLYGON((-1.0 2.0,-1.0 3.0,-1.0 4.0,0.00 4.0,1.0 4.0,3.4142135623730949 4.0,1.7071067811865475 2.2928932188134525,0.70710678118654746 1.2928932188134525,-1.0 -0.41421356237309492,-1.0 2.0))"
    };

// Nearly-collinear (two segments as-if meeting but not really)
static std::string buffer_rt_l[2] =
    {
        "POLYGON((1.0 5.0,1.0 6.0,1.0 8.4142135623730958,2.7071067811865475 6.7071067811865479,3.7071067811865475 5.7071067811865479,5.4142135623730958 4.0,3.0 4.0,2.0 4.0,1.0 4.0,1.0 5.0))",
        "POLYGON((5.0 1.0,5.0 2.0,5.0 4.4142135623730958,6.7071067811865479 2.7071067811865475,7.7071067811865479 1.7071067811865475,9.4142135623730958 0.00,7.0 0.0,6.0 0.0,5.0 0.0,5.0 1.0))"
    };

static std::string buffer_rt_m1[2] =
    {
        "POLYGON((3.0 2.0,3.0 3.0,3.0 5.4142135623730940,4.7071067811865479 3.7071067811865475,5.7071067811865479 2.7071067811865475,7.4142135623730940 1.0,5.0 1.0,4.0 1.0,3.0 1.0,3.0 2.0))",
        "POLYGON((0.29289321881345254 2.7071067811865475,1.2928932188134525 3.7071067811865475,3.0 5.4142135623730949,3.0 3.0,3.0 2.0,3.0 1.0,2.0 1.0,1.0 1.0,-1.4142135623730949 1.0,0.29289321881345254 2.7071067811865475))"
    };

static std::string buffer_rt_m2[2] =
    {
        "POLYGON((-0.70710678118654746 3.7071067811865475,0.29289321881345254 4.7071067811865479,2.0 6.4142135623730967,2.0 4.0,2.0 3.0,2.0 2.0,1.0 2.0,0.00 2.0,-2.4142135623730949 2.0,-0.70710678118654746 3.7071067811865475))",
        "POLYGON((2.2928932188134525 6.7071067811865479,3.2928932188134525 7.7071067811865479,5.0 9.4142135623730958,5.0 7.0,5.0 6.0,5.0 6.0,5.0 5.0,5.0 4.0,4.0 4.0,3.0 4.0,2.0 4.0,2.0 5.0,2.0 6.0,2.0 6.4142135623730958,2.2928932188134525 6.7071067811865479))"
    };


static std::string buffer_rt_n[2] =
    {
        "POLYGON((-0.70710678118654746 0.70710678118654746,0.29289321881345254 1.7071067811865475,2.0 3.4142135623730949,2.0 1.0,2.0 0.0,2.0 -1.0,1.0 -1.0,0.00 -1.0,-2.4142135623730949 -1.0,-0.70710678118654746 0.70710678118654746))",
        "POLYGON((2.2928932188134525 3.7071067811865475,3.2928932188134525 4.7071067811865479,5.0 6.4142135623730958,5.0 4.0,5.0 3.0,5.0 2.0,4.0 2.0,3.0 2.0,0.58578643762690574 2.0,2.2928932188134525 3.7071067811865475))"
    };

static std::string buffer_rt_q[2] =
    {
        "POLYGON((6.0 6.0,7.0 6.0,9.4142135623730958 6.0,7.7071067811865479 4.2928932188134521,6.7071067811865479 3.2928932188134525,6.4142135623730949 3.0,6.0 3.0,5.0 3.0,4.0 3.0,4.0 4.0,4.0 5.0,4.0 6.0,5.0 6.0,6.0 6.0))",
        "POLYGON((3.0 2.0,3.0 3.0,3.0 4.0,4.0 4.0,5.0 4.0,7.4142135623730958 4.0,5.7071067811865479 2.2928932188134525,4.7071067811865479 1.2928932188134525,3.0 -0.41421356237309581,3.0 2.0))"
    };

static std::string buffer_rt_r[2] =
    {
        "POLYGON((3.7071067811865475 0.29289321881345254,2.7071067811865475 -0.70710678118654746,2.0 -1.4142135623730949,1.2928932188134525 -0.70710678118654746,0.29289321881345254 0.29289321881345254,-0.41421356237309492 1.0,0.29289321881345254 1.7071067811865475,1.2928932188134525 2.7071067811865475,2.0000000000000004 3.4142135623730954,2.7071067811865475 2.7071067811865475,3.7071067811865475 1.7071067811865475,4.4142135623730958 1.0000000000000004,3.7071067811865475 0.29289321881345254))",
        "POLYGON((5.7071067811865479 2.2928932188134525,4.7071067811865479 1.2928932188134525,4.4142135623730958 1.0,4.0 1.0,3.0 1.0,1.3819660112501053 1.0,2.1055728090000843 2.4472135954999579,3.1055728090000843 4.4472135954999583,3.7260485282911020 5.6881650340819956,4.7071067811865479 4.7071067811865479,5.7071067811865479 3.7071067811865475,6.4142135623730958 3.0,5.7071067811865479 2.2928932188134525))"
    };


static std::string buffer_rt_t[2] =
    {
        "POLYGON((0.00000000000000000 3.0,0.00000000000000000 4.0,0.00000000000000000 6.4142135623730958,1.7071067811865475 4.7071067811865479,2.7071067811865475 3.7071067811865475,4.4142135623730940 2.0,2.0 2.0,1.0 2.0,-0.00000000000000000 2.0,0.00000000000000000 3.0))",
        "POLYGON((1.7071067811865475 3.2928932188134525,0.70710678118654746 2.2928932188134525,-1.0 0.58578643762690508,-1.0 3.0,-1.0 4.0,-1.0 4.0,-1.0 5.0,-1.0 7.4142135623730958,0.70710678118654746 5.7071067811865479,1.7071067811865475 4.7071067811865479,2.4142135623730954 4.0,1.7071067811865475 3.2928932188134525))"
    };


#endif // BOOST_GEOMETRY_TEST_OVERLAY_CASES_HPP
