//  (C) Copyright John Maddock 2006-7.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
   static const boost::array<boost::array<T, 4>, 200> gamma_inv_data = { {
      { SC_(9.754039764404296875), SC_(0.12698681652545928955078125), SC_(6.349849983781954486964960115093039567468747967664820851534065876063014180392060424555352423162443804), SC_(13.35954665556050630769710564071384909890705633863167415813992116806093647564994418684947673739937248) }, 
      { SC_(9.754039764404296875), SC_(0.135477006435394287109375), SC_(6.443655518427200469944002789678415067225918847146256390238048987798948404483563975737891105237977816), SC_(13.20648307403762788665455912344161337928185855631083250140430065533748994841668643195553261756810763) }, 
      { SC_(9.754039764404296875), SC_(0.22103404998779296875), SC_(7.262299107203547511919478506673940833772294421637239641242141768466064388735007729524335022945474356), SC_(11.97587613793353953360795933135034836336725275703898828955465276118339699687746564051854946108002967) }, 
      { SC_(9.754039764404296875), SC_(0.308167040348052978515625), SC_(7.97160002999034906812099484768140342301220827266158714468555902274184312977405873043165132107201808), SC_(11.04086573531719578182530917737022531437091511425536985032928875608312723663655612529685653444775069) }, 
      { SC_(9.754039764404296875), SC_(0.6323592662811279296875), SC_(10.49594448867679616659291265911862460649618853634598426379731165830605063134254492272180891868259779), SC_(8.425658710690898403870129948430842533053798281214253294861614223449877730063968146709177371998177282) }, 
      { SC_(9.754039764404296875), SC_(0.814723670482635498046875), SC_(12.4361412533700118513726558060654652709881561861912344653689388650864659162098713582998706613513665), SC_(6.942010644016112027186983623736329615032487299108703218184306594043669003923138791980905906975995029) }, 
      { SC_(9.754039764404296875), SC_(0.835008561611175537109375), SC_(12.72773220471889504229650982423238107961665601639868914273535729539112172086261925240837297640844728), SC_(6.748045775833720602368139518425707341668236119625769419950098701512116894292576121300681462006500869) }, 
      { SC_(9.754039764404296875), SC_(0.905791938304901123046875), SC_(14.04289410800251925225181397652529175357661325918932141591196059344562473318317362439395292198624427), SC_(5.950449506005127213772609250049267524655862647593667247023701745572192142411485108776352863016275192) }, 
      { SC_(9.754039764404296875), SC_(0.9133758544921875), SC_(14.22894231389791438923272291986931994699865499051360224227851330535373836529589979766491736680448836), SC_(5.846919097207863070421132965572838346244481147780105186426552033007650921954238889468080440271030891) }, 
      { SC_(9.754039764404296875), SC_(0.968867778778076171875), SC_(16.33883627400002069452382739015521709223507055939529263776286910527953871886379701300232417366169237), SC_(4.808199239905297896929793615245708425392715583004661735514849678846177677735540465249046080150658016) }, 
      { SC_(12.69868183135986328125), SC_(0.12698681652545928955078125), SC_(8.784921019272498426105463510492037221421052305018408345439418701592122876845445386318018554294593597), SC_(16.81366073413268797817072489278431450377279434529634658485607365405913967176896119547533072607895572) }, 
      { SC_(12.69868183135986328125), SC_(0.135477006435394287109375), SC_(8.896383236591753135866154471087553855363191438952119644843354891974586610224750070854729638914776046), SC_(16.6428583989184708274029070066937822603130962248261232385768762701676877405494336531756951743065766) }, 
      { SC_(12.69868183135986328125), SC_(0.22103404998779296875), SC_(9.862617469220713982665965583371935244918334904047351290421210068334907822439623183798321618935666208), SC_(15.26417216941950344244469055509062778775449055335485936125735788919407017713513029239167766664433603) }, 
      { SC_(12.69868183135986328125), SC_(0.308167040348052978515625), SC_(10.69138713107098569132745297244807793219586717588054769942754175121170431877955989315300122291141203), SC_(14.20948610118405050986416627593847862222152891932304799177300336536994233985896539635674080339978587) }, 
      { SC_(12.69868183135986328125), SC_(0.6323592662811279296875), SC_(13.59160242982394546525659606547105412243476185288599611155553845175046676029707044791838719524314813), SC_(11.21833709961257197262317281372631080045506080803403124590125627441167267860541032250322395715509712) }, 
      { SC_(12.69868183135986328125), SC_(0.814723670482635498046875), SC_(15.78100200803618704628341940958738974144994852378563374179722297850145536660826670260570594353062151), SC_(9.485914242958992367868116579661562385020487098469515689243995498338666786774277962701684145364614028) }, 
      { SC_(12.69868183135986328125), SC_(0.835008561611175537109375), SC_(16.10768378194664520785164274219032682174067248024299096512267552941928679913022155729117705239039614), SC_(9.256972936850435511821520144816528171581971265534873471330923432517135603499344161300868431486273563) }, 
      { SC_(12.69868183135986328125), SC_(0.905791938304901123046875), SC_(17.57451392394839637853072154924202340041250318069820417410699000204190551648457756693657445268580362), SC_(8.308449130090979664905693116847977133757857856259019618478292317862193093391266421876368176026885601) }, 
      { SC_(12.69868183135986328125), SC_(0.9133758544921875), SC_(17.78120431823760905019919358341211310740289167580967695713747245051436762583474385825882605114215371), SC_(8.184415485568589887581204235321277473382157178631551706967674610793002275120884722553261739084022877) }, 
      { SC_(12.69868183135986328125), SC_(0.968867778778076171875), SC_(20.11282386874024435590086548366488795467186497904358012983377190369308090637019960432813568291554008), SC_(6.926292714178635218267544567425104730746607860597889810371943318861426764662000904602232871294882688) }, 
      { SC_(13.5477008819580078125), SC_(0.12698681652545928955078125), SC_(9.498617359584155640484541449649777746948590653761048796276576864898496630551753271666853231765426842), SC_(17.79798162738702993034563024897450568706481511286766154625099454142798060131218953823037970167927363) }, 
      { SC_(13.5477008819580078125), SC_(0.135477006435394287109375), SC_(9.614775988541336468177980597986705226150734696228094899421874133496006187511254461903417884668491441), SC_(17.62246603854661671225539741059758091561101663348222755233043088258876382572931569484985290749081656) }, 
      { SC_(13.5477008819580078125), SC_(0.22103404998779296875), SC_(10.62024247753366364647248032590806061928817183680462172013914582077858242694264811077067842582386142), SC_(16.20444734927429472403282136314761525619629951702035708925978699041651641989369163302848368392689349) }, 
      { SC_(13.5477008819580078125), SC_(0.308167040348052978515625), SC_(11.48074440713744311956915102323568956655968396102279642877750567632034941027764385976065892114500525), SC_(15.11798663605700785721798844766012913782964705441427242735825731730090704196208198202029130036141707) }, 
      { SC_(13.5477008819580078125), SC_(0.6323592662811279296875), SC_(14.48073489935233521068434405601243923057632318972553814212027152167003918483808464961117624784623845), SC_(12.02704788535074788861033001134023233915305447951099028068056347800163392529441090482540307798685386) }, 
      { SC_(13.5477008819580078125), SC_(0.814723670482635498046875), SC_(16.73629927769647849910018442365701917854019482468506890711111946510737737724630051305034264488341527), SC_(10.22854789676807930535872827554978808600380330532012078946908108602774426315925373791179289098191871) }, 
      { SC_(13.5477008819580078125), SC_(0.835008561611175537109375), SC_(17.07230172784082056774938408524950777447191664556885261149433510787212528817435454933590607672697644), SC_(9.990309368635640920525908069461492024128503635857635797215572604259569445124829836044990246725840346) }, 
      { SC_(13.5477008819580078125), SC_(0.905791938304901123046875), SC_(18.57943282010105485302313959593611824730560394665706071991266220247143675877254349827804250110556723), SC_(9.001636639606782454852678177382826256836585776478669141919241268216881268175767097054997378150223672) }, 
      { SC_(13.5477008819580078125), SC_(0.9133758544921875), SC_(18.79161039398503202333296704231244597477482800917637510567121241587484048731001678204759043640360688), SC_(8.87214435725663693979687724717593409790301569787329515668335675276042538894701538490674700483403159) }, 
      { SC_(13.5477008819580078125), SC_(0.968867778778076171875), SC_(21.18220898123781853664088977081053912399151177338095127709466918141500188229626769713849113296402301), SC_(7.555520288994441890520319737969581067992009391440307072440968324932077242074577892941703792815725045) }, 
      { SC_(18.8381977081298828125), SC_(0.12698681652545928955078125), SC_(14.02918384935729977571079399019578265355375175041086767491985182081926418595382713721049797304245723), SC_(23.84832008374570657843601152161922418294473083919872835952225321291493570931568811968119991642189789) }, 
      { SC_(18.8381977081298828125), SC_(0.135477006435394287109375), SC_(14.1717558408285204731229413214355407322131190068678013417143495621020016567545546380260276801404323), SC_(23.64632111226697723902037751132889538735497241553315122704671360973796130353064112449658479893457174) }, 
      { SC_(18.8381977081298828125), SC_(0.22103404998779296875), SC_(15.39773837457043698931455923005861426937604737220294929069977988256266934526501920208779982759587365), SC_(22.00737005060904259496548959136475323951066136822330010407130959831286391755492621135957095646330243) }, 
      { SC_(18.8381977081298828125), SC_(0.308167040348052978515625), SC_(16.43646768947077607639318321456563683537280601605704932668148794751520503628860481405287890652458762), SC_(20.74250608342419959939601354285731771811382267120496031307767419677617204111722564570731321205541112) }, 
      { SC_(18.8381977081298828125), SC_(0.6323592662811279296875), SC_(19.99653216929445027752016902471978241173969183085077185191263145262134409894522028975550586054433757), SC_(17.09143298423542698720439516857081024377513789510279117199898311661457672065997820743891080957454969) }, 
      { SC_(18.8381977081298828125), SC_(0.814723670482635498046875), SC_(22.62358746129058044873195060926203304966862610502008574066534905990680646717129461587254469611865102), SC_(14.92180595415719085073070904750006513006428922906520858581467699319967262726486861699947535207163636) }, 
      { SC_(18.8381977081298828125), SC_(0.835008561611175537109375), SC_(23.01194424835788306886951313659607313837967736007141259992314991255372739949354839136553648245155345), SC_(14.63131053103978287708176139398891940280178575959277638074211442555086572026072794775928325103386684) }, 
      { SC_(18.8381977081298828125), SC_(0.905791938304901123046875), SC_(24.74553536249324418369583464247581935807857304399784054137248564290674116172214116492529377897947574), SC_(13.41680992879640923862967554436512136986000317288750391213712820765557758509207588576227994010120905) }, 
      { SC_(18.8381977081298828125), SC_(0.9133758544921875), SC_(24.98855922949763595286433770295801937073089655019479031344185246094205127481262357818578723948898406), SC_(13.25659011182332365393171901517028916543523390139952132429867952554688374213918135037207609952686158) }, 
      { SC_(18.8381977081298828125), SC_(0.968867778778076171875), SC_(27.71093725208517365530031334759767821069589067584245910071522241255680919312387131304006236541170325), SC_(11.61017672557665827133967679491110764155409662162341161685463542805944124779399300099799766367213288) }, 
      { SC_(22.103404998779296875), SC_(0.12698681652545928955078125), SC_(16.87921759766199342126849411350775507387050679211015114525221613677065459892360198202627022430500249), SC_(27.52866695060767792664819339650311437476668058733486617970407962087418726741094579047667239214454053) }, 
      { SC_(22.103404998779296875), SC_(0.135477006435394287109375), SC_(17.03624081831792660555746518820570556593564019794008053245186521018175266175899459965990428178270342), SC_(27.31219056488829179810473142072026583020173006708355606663204637779009020549444129376789977483880849) }, 
      { SC_(22.103404998779296875), SC_(0.22103404998779296875), SC_(18.38280200054672042703901164144922085301323003202250828998626085385563857355718842506863154624518206), SC_(25.55250527197460171605905310645914682685251606418527730068084279130497333005582624763854398336535367) }, 
      { SC_(22.103404998779296875), SC_(0.308167040348052978515625), SC_(19.51891640723757187740519857537483721812369925364735900280867333488464328776147633436786812992163283), SC_(24.19019057338058769538569164267477649983425551228652172492647049291607738760994739729594234741922399) }, 
      { SC_(22.103404998779296875), SC_(0.6323592662811279296875), SC_(23.38484093592894056053206548807146996056154022326068739030837973664895947981359924373637480574314385), SC_(20.23323491591530584374085996099469644603448841546893530059418301629757627921851420509688475820722468) }, 
      { SC_(22.103404998779296875), SC_(0.814723670482635498046875), SC_(26.21481844611917379564918440327638148836556318688449340963338575524770939892080039289488330837060982), SC_(17.86082149351630669001199626913063819591125960124482479880463485851816752805889040359554778417207339) }, 
      { SC_(22.103404998779296875), SC_(0.835008561611175537109375), SC_(26.63178541700257050291932201267909271640076907575659551807783114540731826091512940564108279941985749), SC_(17.54175229835570897784317564445864904587116131558600188413787964932040985878828758496423978834206092) }, 
      { SC_(22.103404998779296875), SC_(0.905791938304901123046875), SC_(28.48918009049513479619126847901168768171192727453166981334693305488736001659536722011525291865820785), SC_(16.20368457747041017597375489605151855173488805553316169631852028677750092269994738348077833124025365) }, 
      { SC_(22.103404998779296875), SC_(0.9133758544921875), SC_(28.74907434406503885540338463064867238299608043496286372590367877338160013376356459725411676727104891), SC_(16.02663882508617462072013702267698845670274734109552775880276924701099849016235523342513909661129533) }, 
      { SC_(22.103404998779296875), SC_(0.968867778778076171875), SC_(31.65303552609361479975168575519275589014413453517181703778356159084365659722731271821757059436742584), SC_(14.19938811589818650148881538183877612215187175266654868287003926611807186142950549597030347893142744) }, 
      { SC_(27.849822998046875), SC_(0.12698681652545928955078125), SC_(21.96449687824799453528229010819150637558680241355458185511339524821334149314394376638352292444614062), SC_(33.9361829674544606482657255296876936875126431697909801154779408237288652527196155546143850024985245) }, 
      { SC_(27.849822998046875), SC_(0.135477006435394287109375), SC_(22.14455296897329749954717929638011902888081335551785035280767992202218929222808948171036390184861165), SC_(33.69664275483206523455679654579411117949392399432602558414101233977723561451289306840041321101580739) }, 
      { SC_(27.849822998046875), SC_(0.22103404998779296875), SC_(23.68322836472181559188816775465752287417745820074391535254150489195391413137919129765435759758127766), SC_(31.74465938924692742455757667024348843185754482922872145133917814426964705641922325380345921487152468) }, 
      { SC_(27.849822998046875), SC_(0.308167040348052978515625), SC_(24.97443472370917584723368445218036877945320866342702614205150894126540244646789567894281362172863678), SC_(30.2271752270198324006000393964780733209094543469601779481386278574186771755944717001926561116998847) }, 
      { SC_(27.849822998046875), SC_(0.6323592662811279296875), SC_(29.32729548620235056567601132167080553205081374706237729706780857931307910947954390172195836019735553), SC_(25.78325676865791003064549447567409781842126940504842337342064889067712591991085441597942606495993107) }, 
      { SC_(27.849822998046875), SC_(0.814723670482635498046875), SC_(32.48038279179138211812973737621724479954462602581093474479163716448725472880987595605911786959294129), SC_(23.08789395474467608954664594129213736148700258320035643867984418932677524932393955246565209178953301) }, 
      { SC_(27.849822998046875), SC_(0.835008561611175537109375), SC_(32.94291809332502085241874235738805699903395903222794798431356987655708892216039119581809140162797222), SC_(22.72329945659565354305612328972814090669772124992070421467993313244460693683113928939355046805399676) }, 
      { SC_(27.849822998046875), SC_(0.905791938304901123046875), SC_(34.99755018219287209238723601299295467938608672566062339487379637960883197742503736398500872619492719), SC_(21.18827387563054957307343841932336178524984829028047157652393381438852509550780350392361262497646018) }, 
      { SC_(27.849822998046875), SC_(0.9133758544921875), SC_(35.28432879113015423334218327183442091652643692837564831891811605186090291551191273889204114743271386), SC_(20.98439634698876713750468369875359155197503275983239980174553343708122558250463054132520606065129298) }, 
      { SC_(27.849822998046875), SC_(0.968867778778076171875), SC_(38.47779138537878955340038620378120402906282037921215268261318917532885749645776398315236205232818098), SC_(18.86852708464915925270056910082500850810201789596348545537632392212843033672714264184115129752136738) }, 
      { SC_(30.81670379638671875), SC_(0.12698681652545928955078125), SC_(24.61712904846231062577703079579199404406864324496619111440088423268270569425847015916146454341072259), SC_(37.21729725181859340891899347210030614624220786517851391377468763017459794763941317096563803817978599) }, 
      { SC_(30.81670379638671875), SC_(0.135477006435394287109375), SC_(24.80813958526573079956034553148541512924082365306093683387711815595731533140635303349847775372609575), SC_(36.96679118810503753041544695305737949621904476084153084939340540688448805363026288614906280800374876) }, 
      { SC_(30.81670379638671875), SC_(0.22103404998779296875), SC_(26.43816215828649376532958526872310980007666571886098347267398882267240789426981595717031639278390697), SC_(34.92339292910525527149580064984739963585594995219835455082478231997934157430535105442199512710482949) }, 
      { SC_(30.81670379638671875), SC_(0.308167040348052978515625), SC_(27.80308957824476240324865859805772888341529234460875416273050438163208947670980716145256922131012151), SC_(33.33215917391845085577361868370068600775422165994276871773428482011985205188137199868513824572076361) }, 
      { SC_(30.81670379638671875), SC_(0.6323592662811279296875), SC_(32.38735522928575516280480164458899201426183389427462932920842668593341705716633039351801957590601049), SC_(28.65682605129866390406573509987640074811212915105368403392660710893619935947286814062573322974108579) }, 
      { SC_(30.81670379638671875), SC_(0.814723670482635498046875), SC_(35.69401134817254278816644666811744543863415968402290305201413925343216859088130133173084212959258305), SC_(25.8079534722337638199897887587823828676684635502783666153649411292993785191353925198833824753417643) }, 
      { SC_(30.81670379638671875), SC_(0.835008561611175537109375), SC_(36.17820890487087604737189182382052108749701073344265524348831586171054803598724239546233445873333437), SC_(25.42171256571933187670223947650551506583339192504255791430274375329561902839459622433281478838237188) }, 
      { SC_(30.81670379638671875), SC_(0.905791938304901123046875), SC_(38.32662130607642623893473052768363638753264387777373510974852248920903756183231685503197343341362915), SC_(23.79300967264726575757727452167855274543374487279938473795492375794093979950149202816496235524197305) }, 
      { SC_(30.81670379638671875), SC_(0.9133758544921875), SC_(38.62618510879634456062107526710433673687792135586813292118102301337800462038273136943991550162088032), SC_(23.57636632869819889255187535455524161590936522120376040710062043531316575388646187908564081104950208) }, 
      { SC_(30.81670379638671875), SC_(0.968867778778076171875), SC_(41.95736968846922692302007474537804225205320769255955237321919691281845341850870244478611089943470409), SC_(21.32310064034471783203915167013305700271915487443645588390868296536476289664577568586388320019196431) }, 
      { SC_(54.68814849853515625), SC_(0.12698681652545928955078125), SC_(46.37703484579566479953419349194355365657314752994915749696195458702746163677706678502947721546853607), SC_(63.20021845016932724944747515975932641862959071345003008024375084405729892557298809379034635456193875) }, 
      { SC_(54.68814849853515625), SC_(0.135477006435394287109375), SC_(46.64171889199341967679473390559633658789387014904228309477115441196396334503047840865889657677946178), SC_(62.87599247637962688638650357758938180380917193774980277068316609611329085584539113443934475099221899) }, 
      { SC_(54.68814849853515625), SC_(0.22103404998779296875), SC_(48.88586116277522199637460996631644034163920164681566399730767318636620675538586175713923920691248246), SC_(60.21819913393248254727442150735368969111002518355955918473119146905834089579617556270620942468807558) }, 
      { SC_(54.68814849853515625), SC_(0.308167040348052978515625), SC_(50.74617645972698679037977419811379709436407293810034464960963769461161303769685942899595732951386793), SC_(58.1314615560847500816758505080551983762099376271109005681009098885749104475914483991384741042058717) }, 
      { SC_(54.68814849853515625), SC_(0.6323592662811279296875), SC_(56.88487238152372439929332418281353696545182573101505262981972075058324617097333296188519127946019756), SC_(51.90165845736251584164676492467250275977258458635724969879532295198497068756369723403097600362616624) }, 
      { SC_(54.68814849853515625), SC_(0.814723670482635498046875), SC_(61.22331451599806720706782050423188360558211596945645513566980703695272186904560507599669113920822525), SC_(48.02123983559173781580390435737131565684756653557591233742999677234385664830485583808344259109872549) }, 
      { SC_(54.68814849853515625), SC_(0.835008561611175537109375), SC_(61.85310223221161597977549271008625396309826275879682300040802411953448060994428675295851881536571112), SC_(47.48947321214053858216550150902644828356544218354867433274926665691227682466777893184934995005351213) }, 
      { SC_(54.68814849853515625), SC_(0.905791938304901123046875), SC_(64.63199659962665075311151327226617314824577750183999197966906061461185202176297356015733989674250854), SC_(45.23070744446056415288177300496498231031831622081588520701104587202112750223630172549604627595774537) }, 
      { SC_(54.68814849853515625), SC_(0.9133758544921875), SC_(65.01754227023427734073991030554914555733715818169955513352549559995008699281517643213002108121851258), SC_(44.92816111390889293807724505379406754064684464155086224775272845406721693750968415789796417674267557) }, 
      { SC_(54.68814849853515625), SC_(0.968867778778076171875), SC_(69.27542721691201940262962302518511572051340861330724423089552549175396535704759329988062087131850174), SC_(41.74952122122039436486747916533838177003620897635231178762102663248750648786837796330176285292076592) }, 
      { SC_(54.722057342529296875), SC_(0.12698681652545928955078125), SC_(46.40832116394066727487136922151512210480821127151827993097800946998937614657747591038335037578694622), SC_(63.23674976986583361001993885937793789217940741604088629649280738743839981800625940101557365962393413) }, 
      { SC_(54.722057342529296875), SC_(0.135477006435394287109375), SC_(46.67309676258900284835187806416809777033625743121661412180738725025463287707225383023905059955933602), SC_(62.91243220671926238584899458639842714331843439358041152246237116838485966160449146520522833945065271) }, 
      { SC_(54.722057342529296875), SC_(0.22103404998779296875), SC_(48.91800201258973280826907616826578162563450960150092673427822373996299238662981140247160749293993553), SC_(60.25387566608863489507314941843556428885887156553344482686279988136752415500161199853426858674933469) }, 
      { SC_(54.722057342529296875), SC_(0.308167040348052978515625), SC_(50.77893260114525153853506526210105389832933111963461643562567611884088356014968107469737828963063105), SC_(58.16652270450208245557438870406299289841658372833755999957332521119616597134081253276193672728664831) }, 
      { SC_(54.722057342529296875), SC_(0.6323592662811279296875), SC_(56.91955877025147636355852648554083855820017441895222245763764561951794154761149320322114190852423883), SC_(51.93478932693185643484465284361965034079238269892193568772149195570523475517324096372033472656767649) }, 
      { SC_(54.722057342529296875), SC_(0.814723670482635498046875), SC_(61.2592823148419492307638665478506875102979190731251703179782917229121117133708582068516203892259305), SC_(48.05308948574877450448923178946529538083893182189006498124521307980175508723121621581360719797793384) }, 
      { SC_(54.722057342529296875), SC_(0.835008561611175537109375), SC_(61.88925088170639105288049409729786376311823649334669072880010612350696792347393394006607448580118853), SC_(47.52114206288455998677394576848964543350129150279863853436492863053249399380778481795258433485047851) }, 
      { SC_(54.722057342529296875), SC_(0.905791938304901123046875), SC_(64.66892857890611553461013122678473356775195314475210728215791006734858098898712378845755543327038087), SC_(45.26159329878386137460422871444796964059031584599895271947744358328705207138041810961279258906405718) }, 
      { SC_(54.722057342529296875), SC_(0.9133758544921875), SC_(65.05458109756790459822359652538545355632212606369889802991144579775782406333693088467048073860548172), SC_(44.9589401829448551993710354036394428086401867127655338871924481106422302417506735508607723352728735) }, 
      { SC_(54.722057342529296875), SC_(0.968867778778076171875), SC_(69.31361803596088984366852805609998605981546912364802274290753372702100577045401929828628679007939693), SC_(41.77914935438802571270949950679829588109066733810638790894703225787560246259892639594483794921568264) }, 
      { SC_(63.235927581787109375), SC_(0.12698681652545928955078125), SC_(54.28774620688215754587248234589840995966642734889020811990610366296380318976985937412371554722175069), SC_(72.38505430842719942132305655003763327281699698810237666470387727082985676408652590143090390646764168) }, 
      { SC_(63.235927581787109375), SC_(0.135477006435394287109375), SC_(54.57467277657262830930027516895440555764202162943460354137238268364491624297854139464996898083095488), SC_(72.03857776831619809114788620220279920757473706311327787619467312623929854119247857157291676498066309) }, 
      { SC_(63.235927581787109375), SC_(0.22103404998779296875), SC_(57.00417100598394580306275271970644669627308398076668927654629645377425182281450492884222416391116142), SC_(69.19538075194769345457695763155495190242014307651492410335844604724067709832632050205093590205792077) }, 
      { SC_(63.235927581787109375), SC_(0.308167040348052978515625), SC_(59.01395471135973585168392822713875957058818545181739725277932120389846576006988871845048062854065685), SC_(66.95915469030241504462587431541989692653401699361788053876309232704591124633796403399070181536762974) }, 
      { SC_(63.235927581787109375), SC_(0.6323592662811279296875), SC_(65.62153118660087958190016457606220818891181278342304805566761088236864487293718490454298992537996321), SC_(60.26046416667538552855637900269915049454845469977573391344845596257457664269832986518780224630885702) }, 
      { SC_(63.235927581787109375), SC_(0.814723670482635498046875), SC_(70.27125227776944897321358074466405530722806832147458527016709965428272433462605414424418170732438877), SC_(56.06880814124086368519571291216504008863094268263275059992447042134127010221254372900250848661474739) }, 
      { SC_(63.235927581787109375), SC_(0.835008561611175537109375), SC_(70.94497399469393700778968484998210389129248075526059109608646475415313904965907079833760032341422221), SC_(55.49311868243167717358603545284098123646316143316361275943018467142657218624359382764454130796228005) }, 
      { SC_(63.235927581787109375), SC_(0.905791938304901123046875), SC_(73.91417030127397559668620666343930268193297534687819287900803557002224321637505000886342303307074356), SC_(53.04412362512229019235767672895889868874811693453133689104681702032491290827947393734920132229825199) }, 
      { SC_(63.235927581787109375), SC_(0.9133758544921875), SC_(74.32567473151852110677992487397685363601799520603661262899132723436590947971551651472291482024274269), SC_(52.71563221440989330040906973160126549065189413960679123620868644779637781275243507169398765612524957) }, 
      { SC_(63.235927581787109375), SC_(0.968867778778076171875), SC_(78.86345709124417190590867450456837590178439404527842315298419218758516375476865737220519136079551199), SC_(49.25732504361311945895048190977096545063433438461604237779638285758347225463267434316859222057037937) }, 
      { SC_(81.4723663330078125), SC_(0.12698681652545928955078125), SC_(71.29619027201815156792385572460546440288784180121615628852600833369510229757398829019233860237167938), SC_(91.84947204076969498023274631177333253332131350104895972499780154891239617121715541200563833678301888) }, 
      { SC_(81.4723663330078125), SC_(0.135477006435394287109375), SC_(71.62600225074562076390867694903232184508873677810768403238202786386732022848106501639018183389790031), SC_(91.46009860144632085198486241032898564792404799182433619238960983644693855717654003115157336257240399) }, 
      { SC_(81.4723663330078125), SC_(0.22103404998779296875), SC_(74.41284225185473602550591574042977694257116658543458184669825020763289835549390386979567818468442899), SC_(88.25949165561279552570334754867545683613263710289541479874416668653301776977660119272393067727222666) }, 
      { SC_(81.4723663330078125), SC_(0.308167040348052978515625), SC_(76.71074103601732575642765708957157918116890591695557780864643636804182646782037292640422411816033798), SC_(85.73512184625072466650721481458608154446048151668940812839995766997224195471692737178754587592344035) }, 
      { SC_(81.4723663330078125), SC_(0.6323592662811279296875), SC_(84.22203602898695773791651554669349953519949365308313868563824885137721110765020486583414538276982072), SC_(78.13270299370015119056303871995152334343111003799992186461358219207616708595819299182340801080810291) }, 
      { SC_(81.4723663330078125), SC_(0.814723670482635498046875), SC_(89.47175672529716601307937633687430806172156183450052915782650511305741259527839119495807144719967953), SC_(73.34110670507223748841341252287394282512323424311191667377272005479791658367146096372572537230041018) }, 
      { SC_(81.4723663330078125), SC_(0.835008561611175537109375), SC_(90.23017158007244681724112594499562033786660406739583489457530168944342105355996535076570960201631849), SC_(72.68074005707520421936427446884429743356316561012127059558459421800719006567547442902916733982886776) }, 
      { SC_(81.4723663330078125), SC_(0.905791938304901123046875), SC_(93.56625643683243831460708950245555204356607899830117317737825375488303258641020430534406161544029494), SC_(69.86496024178838047661430589115751362047622713313530960161076907249376782463152652035781899891770685) }, 
      { SC_(81.4723663330078125), SC_(0.9133758544921875), SC_(94.02781275297839272196662390216964359810120829981703807381112795515158003221939065649728102437395132), SC_(69.48643649137981904208493627542488277675377033731545013808034158285213438834583793834755807845304628) }, 
      { SC_(81.4723663330078125), SC_(0.968867778778076171875), SC_(99.10537139756835922848645178267919055087403191751152773958481875433252196840037584254582311319630489), SC_(65.48868194671689544231970937477099765493627170497912285433834892901898527668756964714438731877882586) }, 
      { SC_(83.5008544921875), SC_(0.12698681652545928955078125), SC_(73.19703892868824041598676487430240507066236187348940063664920054360317721682757017049677280459997144), SC_(94.00559837805303742559791529250140454392459765158485756480467100097478488160083234138542838132968486) }, 
      { SC_(83.5008544921875), SC_(0.135477006435394287109375), SC_(73.53130915894433511987609169038668350222081706836556527591998372061238030137868917999741830794478824), SC_(93.61176572079343976128152223765803578761332738710928949389561088674927975688829123033338599481784128) }, 
      { SC_(83.5008544921875), SC_(0.22103404998779296875), SC_(76.35529504561858499846621525203034940857915999660435450314286057777849907307615437300349113556577942), SC_(90.3740071573341145699253653723371796466143293032911923991942754182333615885730138411029234752237424) }, 
      { SC_(83.5008544921875), SC_(0.308167040348052978515625), SC_(78.68314112480631820884112343690972182109682520350796414586848593439617553195360832017099603760506859), SC_(87.81968764228195343370610031118399491938157024343042607767074150689385704899681154801101232812225894) }, 
      { SC_(83.5008544921875), SC_(0.6323592662811279296875), SC_(86.28836481294416474332619370859574047419570240578447151851952923800385744778028513467449588848417352), SC_(80.12333926966668376891268541010191465890896635993282285358835157678016998516182307767600485382445958) }, 
      { SC_(83.5008544921875), SC_(0.814723670482635498046875), SC_(91.60044953864571101887455519676545914151124556836156422594528675504349037546306691377449971024876726), SC_(75.2693839415761116196627540056096812583062254945886143599807899747508978159783914741728333576499263) }, 
      { SC_(83.5008544921875), SC_(0.835008561611175537109375), SC_(92.36766796414533776456602525131989867108328558561044911548178476628064777782195730215791007935991303), SC_(74.60021506412382609940555860448944283536750694767788299806905937251682849013564421194657422988914495) }, 
      { SC_(83.5008544921875), SC_(0.905791938304901123046875), SC_(95.74189193385518903646499673342541672607418929092579499687915614344122491818492794628187664092821885), SC_(71.74630486574835137961127480988471274427827687408373211770063733293902146802607133723920913885271055) }, 
      { SC_(83.5008544921875), SC_(0.9133758544921875), SC_(96.20865161064573301504666975011964011076125594941064126883474714131995460614308050226194637684913151), SC_(71.36257939885466395883992532308135162863674798772779712266968584550016851211000478919235917462177202) }, 
      { SC_(83.5008544921875), SC_(0.968867778778076171875), SC_(101.3423310622841226130372973960392795152246870881696149786835081230813929693808598032012913101837891), SC_(67.30873171816536788749398511362102143152242278162467485213122758888542732132210038498977500703031664) }, 
      { SC_(90.579193115234375), SC_(0.12698681652545928955078125), SC_(79.84175221240810682981804044548095650478414092371984638737681539075812308148871629074272386127624744), SC_(101.5175581821499316379158994716000174083757645388563277304905989158882325907280691579523858340962527) }, 
      { SC_(90.579193115234375), SC_(0.135477006435394287109375), SC_(80.19116910019171471751506416770800543661948723266912568902629360730537390266354957543607727615001925), SC_(101.1085758356704635430888993149807560037299737762870263280497813295996305438417447346603872690730152) }, 
      { SC_(90.579193115234375), SC_(0.22103404998779296875), SC_(83.14135323472378589217475207473003674168990946246256156115072461453085956688821993427808842142537494), SC_(97.74460104296141714676089120078494736341069828223213444018890150534666510088401425903691158854352444) }, 
      { SC_(90.579193115234375), SC_(0.308167040348052978515625), SC_(85.57093846065158264326656137454250502798545447926311920317173493886822834107708161119360128524617158), SC_(95.08853481933919306881362485200882139218927780030147589531143302482961382004522061642865982573976234) }, 
      { SC_(90.579193115234375), SC_(0.6323592662811279296875), SC_(93.49525692928177413315200076663773033814657619782970412810918826246077592180948572156197024657388461), SC_(87.07308907876851809564811653286634606031165275453653509383848561680031950012423854958426677835693976) }, 
      { SC_(90.579193115234375), SC_(0.814723670482635498046875), SC_(99.01920797497934944355647265747410491254674668232698929079999061892985722460343900856203453935663303), SC_(82.00728308328940060989242377429097306390721713991831270421189893974183791230666203292919592474210575) }, 
      { SC_(90.579193115234375), SC_(0.835008561611175537109375), SC_(99.81633500587285085407956877396865118230934735400460295379313717407365698396538986967145181133258546), SC_(81.30820980797334971867735134301845021848015652742540874774656202815851287085936269965804029144325566) }, 
      { SC_(90.579193115234375), SC_(0.905791938304901123046875), SC_(103.3201326814194787996113270125884077145674683495281344531029776742154605765190051453253134340324093), SC_(78.32475329016406943717517024694239863707652640693810266880748623401104177538133801387593352409778148) }, 
      { SC_(90.579193115234375), SC_(0.9133758544921875), SC_(103.8045706236168505853701254154801083174472388089203502714544732048643714617064351817110972731859817), SC_(77.92335471589570797608955642307028160820673363884106184091445886925757098842384343604208093362576951) }, 
      { SC_(90.579193115234375), SC_(0.968867778778076171875), SC_(109.1289260187349451542429911657874249624428319908094561233253592098987942215099913837877434318463875), SC_(73.67891790501625525726587661010340081700926918094322012272323200665876797487681035809670239109759401) }, 
      { SC_(91.33758544921875), SC_(0.12698681652545928955078125), SC_(80.55470942127042066936632015313401327445187047496964033284121871287571214336050449309933332986266301), SC_(102.3213852338357228517997851710241718661682891694714066018144357282717161738512635384951018953620892) }, 
      { SC_(91.33758544921875), SC_(0.135477006435394287109375), SC_(80.90571343760774497081998718824956843148588700104520877743188609279531236164016487392211148245036099), SC_(101.910815461971514278754518364843951261918323936566661450283934209127682325895107122078547692173385) }, 
      { SC_(91.33758544921875), SC_(0.22103404998779296875), SC_(83.86912090350992385308180592914601168079126811955538048023940035230896936424477286326599140987099811), SC_(98.53361557738737048190581573982543569446348223788769275746696528609106007406062972637706066659819128) }, 
      { SC_(91.33758544921875), SC_(0.308167040348052978515625), SC_(86.30936634290232676471187611505242970136193922486436562496224852202872847233337842006448872413567024), SC_(95.86688839997597973891126777969476711202163968961890823789197071746859237100356311361748306398330133) }, 
      { SC_(91.33758544921875), SC_(0.6323592662811279296875), SC_(94.26711895589561227702740335985771600147679266384727244733348900604583030422872888937743996867014066), SC_(87.81800826172970743690326176449486530514563837080793143166027496029484182724915663426045624699528214) }, 
      { SC_(91.33758544921875), SC_(0.814723670482635498046875), SC_(99.81326921422746787560320796288081477552924454708582065666066593371092467171426783882056575141495564), SC_(82.73000458605764141912849052480945956523784759765708787383685293520838825613577460520665330230578783) }, 
      { SC_(91.33758544921875), SC_(0.835008561611175537109375), SC_(100.6135301046329302380769833035397124459236625973564439663421018074406391086331637424550021289051344), SC_(82.0277978631755217915832571581478079563666173686046958602779438536997105502894593805428703897018651) }, 
      { SC_(91.33758544921875), SC_(0.905791938304901123046875), SC_(104.1309048952937343480901597892106892404140640027659427565383628152146258331634608916359022452913204), SC_(79.03076691165164577903469432640031156432173780160284889686347233770168043623260716140204106566823805) }, 
      { SC_(91.33758544921875), SC_(0.9133758544921875), SC_(104.6171952507842757671220388362614112514493402913179711736626797841255751890435833615537964472043323), SC_(78.62751642912450274309270917028457352003332933068717921576263126589456179403012860663869334115384046) }, 
      { SC_(91.33758544921875), SC_(0.968867778778076171875), SC_(109.9615311893670237000620350267082224291177338704412356503708758083428187162676324516996474432855136), SC_(74.36310757520278137699647890644860880165951779755309524146879028306176854705499984346991583313445025) }, 
      { SC_(95.7506866455078125), SC_(0.12698681652545928955078125), SC_(84.70709725546155305557473921691138205287309818101589371184901868961444039089515981954041515541716532), SC_(106.9951975491050031767655859228053766179626225010268705351075732101285952117825152177237525493907427) }, 
      { SC_(95.7506866455078125), SC_(0.135477006435394287109375), SC_(85.06720867357064602810985397070260129603684678081034808427795228464287439180388935168418513775907925), SC_(106.5755187418851258499188933077995960570184264182402386853477454110525648871848796447339615217784007) }, 
      { SC_(95.7506866455078125), SC_(0.22103404998779296875), SC_(88.10649462691111941963748534218329189409759936220074216169641059785429479537864993229192521534634851), SC_(103.1224306812075760906755958616922906132424736499012364996135759782327598992197705974926320430872999) }, 
      { SC_(95.7506866455078125), SC_(0.308167040348052978515625), SC_(90.60790998246389585551363686090293388092202973025062190244201380020359261745570455467350109381388301), SC_(100.3945295134808169115671077384546551191351431424503826146072248413975203145286475988883591297564991) }, 
      { SC_(95.7506866455078125), SC_(0.6323592662811279296875), SC_(98.75751085223438797379949043614472338672554374893220316533310803642986250787163272087838741859028974), SC_(92.15379972445146037548855116091818614346239163331270435359001670198044863142860931051035663509802997) }, 
      { SC_(95.7506866455078125), SC_(0.814723670482635498046875), SC_(104.4310431781802048505261488275858182403809062126774572297150124139631023428137767694710937471029547), SC_(86.93842241451993312105235750909193838866513021090338601967079336145848071876097709023085891034460879) }, 
      { SC_(95.7506866455078125), SC_(0.835008561611175537109375), SC_(105.2492867669474260992245597479965927800541302232811288130596139166824197855151072036214880672013574), SC_(86.21823526035073958985770975653279499531922339748481146612403762839451531762247572034072236781689142) }, 
      { SC_(95.7506866455078125), SC_(0.905791938304901123046875), SC_(108.8445704767840987866479170746614726925774354472826306350316613868195009161323130293841293515910082), SC_(83.14331014654886313660311225808183905221284934075565854014125461525738817219263762303355064628802463) }, 
      { SC_(95.7506866455078125), SC_(0.9133758544921875), SC_(109.3414905596746490817233424811163781706270202086969055042667631657018487326153861628725649462342907), SC_(82.72943271608211391542555552414805926519799944531816550122127101623220880364426707612559186750036326) }, 
      { SC_(95.7506866455078125), SC_(0.968867778778076171875), SC_(114.8004831907863234890701734636484327238767969046585415152597983471340795113178735593950878428349183), SC_(78.35041395285272012339968017689162204010315148488754492497140762846636499068662347314738828431489766) }, 
      { SC_(96.48885345458984375), SC_(0.12698681652545928955078125), SC_(85.40224841570944638734227688423893433855458772234486768972915837485986575928657672649635117618498298), SC_(107.7763796517941403050191975480102923537258879116567951235523333381552131584750702102640261211678372) }, 
      { SC_(96.48885345458984375), SC_(0.135477006435394287109375), SC_(85.76386251923861953411158141479414219175520126160270389455592068586888734454609842651493737410307223), SC_(107.355197900557971580171152013628344457543628574577422257759623095192652931240239873125678032841095) }, 
      { SC_(96.48885345458984375), SC_(0.22103404998779296875), SC_(88.81566799665044092744595886289529036607780903234653146828139052389457111286467963605861430389924168), SC_(103.8895887821161642562813145433045663638035217668183230013539711623214806941804452662410996925715041) }, 
      { SC_(96.48885345458984375), SC_(0.308167040348052978515625), SC_(91.32717591526663550290360602434059313431549465806685558773754677760031734788863076189049095027720393), SC_(101.1515944064119508827462337472282493152515205016306631012848195887068586486481326769950293608001619) }, 
      { SC_(96.48885345458984375), SC_(0.6323592662811279296875), SC_(99.50842996001980570093492893545129760529687182434782170521934298627158520145339373459124566770891621), SC_(92.87921122174092819447365167780955457328429254963518059312175391928652696661704878419202206228541363) }, 
      { SC_(96.48885345458984375), SC_(0.814723670482635498046875), SC_(105.2029792838659943587200025142545208759887382041822746300575519413044047054722309005955305036161377), SC_(87.64281824886126340786290265727047796829995176261916595167200070261399325976826176454758255622090373) }, 
      { SC_(96.48885345458984375), SC_(0.835008561611175537109375), SC_(106.0241899009105585829981778185725663794090155163934444806888492668631324979036876101314574132110467), SC_(86.91966442528721613834997221916303625301151697302422529937237691169490488131478246669789917860181866) }, 
      { SC_(96.48885345458984375), SC_(0.905791938304901123046875), SC_(109.632328199431186948728697681102647622513560608216860137973465578512450993365248288605876185488063), SC_(83.831887058824506730781125226296666699739941877662585243806150953849984463678829297116813212627646) }, 
      { SC_(96.48885345458984375), SC_(0.9133758544921875), SC_(110.1310021528084660149240587302351814159490648063853530597896206111097939221527935389306929055552969), SC_(83.41625619786673946357580258076679845000023541178136246022830883747669157052264119768074837953252578) }, 
      { SC_(96.48885345458984375), SC_(0.968867778778076171875), SC_(115.6089130958749299514883584085033759636221605217619269705849543570783654779111750581571984448805251), SC_(79.01832652875479939372093655751198778535669443440143855308435747468988132057271401542733720175779538) }, 
      { SC_(96.76949310302734375), SC_(0.12698681652545928955078125), SC_(85.66657750874739469547512498154347522235188231648565220634305107484234320567666091367915494015416444), SC_(108.0733297219970995289044878724552964709801970908861066154758974833813501997292082482169847849842687) }, 
      { SC_(96.76949310302734375), SC_(0.135477006435394287109375), SC_(86.02876139898260672726600243973192770706439640865219156595172309673122716789298224371535188963723919), SC_(107.6515780867799770117661808014199064971238982913450221569986285857250999570093723690322859133017628) }, 
      { SC_(96.76949310302734375), SC_(0.22103404998779296875), SC_(89.08531400744336186067252664677283783814199671377820398006060143891977565526059606865036262120216651), SC_(104.1812212603686696841219085268070231633920490669485235449415011417880247786907830292023203722582168) }, 
      { SC_(96.76949310302734375), SC_(0.308167040348052978515625), SC_(91.60064879701576510534749689011907172659393504122722555758328411997347916008970916841672273584793764), SC_(101.4393997711157079405600101069862599321398650689581381488009945469269770041338953448110448172892026) }, 
      { SC_(96.76949310302734375), SC_(0.6323592662811279296875), SC_(99.79390498583282267747367640192760345340242419618915080320329241522875454065363373143904510056165602), SC_(93.15501435937740064521981311484302896929993188228186524291695956100977073816945515857001929552597095) }, 
      { SC_(96.76949310302734375), SC_(0.814723670482635498046875), SC_(105.4964234743595005609188265306032885940660970929811549527177570196863403032205916377074972062264123), SC_(87.91065272397658470438080075718364119140918058622597797720593096563608412568220142395981935781917024) }, 
      { SC_(96.76949310302734375), SC_(0.835008561611175537109375), SC_(106.3187591228176309855276419225562432785653104517382593360529234982297445615720549508412768532099608), SC_(87.18637400398396729454873004425612179479901834703760966616501063632011746505615593282942009300179105) }, 
      { SC_(96.76949310302734375), SC_(0.905791938304901123046875), SC_(109.9317716055940761122201143094980392464036326491210952369698916672198597495550324149880065760473155), SC_(84.09372333199673608894932811772448706853763070273309780826650202973992001995002859576724818134913197) }, 
      { SC_(96.76949310302734375), SC_(0.9133758544921875), SC_(110.4311105903100081342306281781082071328418466292197456125956889729803536963582441336296302888028325), SC_(83.67742760521194208943145201595227174608840519679603038059666880122541634308754504144269691845150911) }, 
      { SC_(96.76949310302734375), SC_(0.968867778778076171875), SC_(115.9161949889672865872656944872656195582808138908715335015430022493129005386628428325182877039995528), SC_(79.27232726643702452907227271525181594407865345866654791457885273052858866012143096861812371516819179) }, 
      { SC_(96.88677978515625), SC_(0.12698681652545928955078125), SC_(85.77705461275145448884184059670145747521324447364087355443564066717292942873712266655592894528945075), SC_(108.1974259266303739342129335428037209741781454705698436168676387012127325183089364902420555366305249) }, 
      { SC_(96.88677978515625), SC_(0.135477006435394287109375), SC_(86.13947638660273537607617797225818302967596277706316272497449385980828904225751838598285834339519238), SC_(107.7754363673111045358250989623133895971276161674093725616390243200830616475322308551119601859130334) }, 
      { SC_(96.88677978515625), SC_(0.22103404998779296875), SC_(89.19801090135184939390245706193405169176549635487039248489026590941180753301388663412721735576321637), SC_(104.303097394495799294372250781586897128195400654164057731103146194763518182779182946576641478069721) }, 
      { SC_(96.88677978515625), SC_(0.308167040348052978515625), SC_(91.71494339117641802078300859375955112036353245403466238208206609501713738531687709888727846374220247), SC_(101.5596781040232907041174239729021685664962703423596338499551294822205119304087839696845462359932232) }, 
      { SC_(96.88677978515625), SC_(0.6323592662811279296875), SC_(99.91321041399301890022248019929425333093777275293504995176977393792207303217751781884016953326513252), SC_(93.27028182373934286726143682979876487457174316526593549555606409814744254116785632934954719197063508) }, 
      { SC_(96.88677978515625), SC_(0.814723670482635498046875), SC_(105.6190559898476156470186567579393301754748152475973702217991816082889685177874122562146896005249944), SC_(88.02259331001012120627028106232129904822055055556600307087377855217320920333717783932291335717822205) }, 
      { SC_(96.88677978515625), SC_(0.835008561611175537109375), SC_(106.4418613337789150662834465967539150510046334986089761472345980178424275895338147417938388378383452), SC_(87.29784495072955079812818934548098966769091817510334571872237486624733050376758448869012427921348781) }, 
      { SC_(96.88677978515625), SC_(0.905791938304901123046875), SC_(110.0569087676460965549175443673536809664664474411088689872017507564098916733669125115542247049201894), SC_(84.20315969338196572854989530819363045048574233294597930405622554273285477875183350125731165187977316) }, 
      { SC_(96.88677978515625), SC_(0.9133758544921875), SC_(110.5565254003095472952924400285409013273476504290357273156728780589299796669406748094430938087789149), SC_(83.78658638753611514607257793963173397254674898146787358050233273515081350499995107177237482387571899) }, 
      { SC_(96.88677978515625), SC_(0.968867778778076171875), SC_(116.0446046920873528112033609608677991511189155730617459927921222740219988503465630098188771574112136), SC_(79.37849231515456241832266533882883215341998528772913479392294938930751337258526935579401070862595695) }, 
      { SC_(99.2881317138671875), SC_(0.12698681652545928955078125), SC_(88.03988401755240312059902805285183521237299995487686023059008881496181934461141706605374564277485821), SC_(110.7372992692725573731697591393548589103394841966076790991646614865573118064484762681255166487645814) }, 
      { SC_(99.2881317138671875), SC_(0.135477006435394287109375), SC_(88.40714494536321930498314541057705121558781002694191911704447280462237009318667590621848989831217393), SC_(110.3104697481858991610699642415404049205540549382020546666969615332025792346398477535378399730503648) }, 
      { SC_(99.2881317138671875), SC_(0.22103404998779296875), SC_(91.50599625629075695333925558823944000033068037616404547594790241831618127835838880946155946667230488), SC_(106.7978091882579180957227826327399587317254598205887947452130155885496447480794670408964903808852888) }, 
      { SC_(99.2881317138671875), SC_(0.308167040348052978515625), SC_(94.05542966722570497040226539391420130180692037513060042769613095280747364242278963119073910822820164), SC_(104.0218869621341187749106671918013336314305862052064089048569771555329392581844795819010636668843943) }, 
      { SC_(99.2881317138671875), SC_(0.6323592662811279296875), SC_(102.3556282071769826944006172794969028033974462498658650696807922850126796685689047547579596993931716), SC_(95.63055847544334211087138998067211381097918211020892885108659046928523862524001913745220040268349381) }, 
      { SC_(99.2881317138671875), SC_(0.814723670482635498046875), SC_(108.1291543562602928024304751748147804453998345888983839614623715132630298762313311048580828345727242), SC_(90.31519355853058782089312287195256334067426270863324117470164569056437169804425894072388785174414288) }, 
      { SC_(99.2881317138671875), SC_(0.835008561611175537109375), SC_(108.9615144259886825743527192622351022097444435851716881383594981271001329308716835208190947446502812), SC_(89.58089159449409507162289598004762894727083770234022756966805353276045874719787836940516270710021009) }, 
      { SC_(99.2881317138671875), SC_(0.905791938304901123046875), SC_(112.6179577986881681054950590064902019242389712272583112203724181108477339819399828823424603515837391), SC_(86.44481769564459753753709972148206867820207960268756150487253069049902935247326722392696033050460213) }, 
      { SC_(99.2881317138671875), SC_(0.9133758544921875), SC_(113.1232225034369918026921896528672269476075103218287973199007233652864695087604791431815686564542933), SC_(86.02259769219673888125653444633780832251026932468113275214161763610722920488400091593471887527263333) }, 
      { SC_(99.2881317138671875), SC_(0.968867778778076171875), SC_(118.6722260958635779664708398764065569812316717572450903065068638638609506808950759768663333735117402), SC_(81.55360245504441686527910864220010764542026336630740606229239169661041788764418800722537023927646871) }, 
      { SC_(99.6461334228515625), SC_(0.12698681652545928955078125), SC_(88.37737888107073636627500424906781041431096054016259174725751830523083014165218482437664265598787634), SC_(111.1158076628131535311143363083607562906226185676374371847096774914864724460972364755857498710894997) }, 
      { SC_(99.6461334228515625), SC_(0.135477006435394287109375), SC_(88.74535620460806340987854361816128428024320481905389016348646200088835179377114089479753531259500676), SC_(110.6882616289176406115134461249367870803764967094106173548894808946298474490315397099426966057522927) }, 
      { SC_(99.6461334228515625), SC_(0.22103404998779296875), SC_(91.85017604570320860123048741031650279971434577969683060829287638362971682925038461612569617055793725), SC_(107.1696318444364396459981501446757609223861217010281426345016448193737147409852464617600305678038153) }, 
      { SC_(99.6461334228515625), SC_(0.308167040348052978515625), SC_(94.40442088829506749763117819247805230794301031739748106412466854828283371649057563467379541863694276), SC_(104.388897894676876174661084670063039489707876655517563928756296867121616845615313628471178466624892) }, 
      { SC_(99.6461334228515625), SC_(0.6323592662811279296875), SC_(102.7197092844094654604597714681631790586173807125641768128671855549332709686069679473684528779727183), SC_(95.98247945192366927890502346818486620765311827085464016312581482129126586465008442638253208379782958) }, 
      { SC_(99.6461334228515625), SC_(0.814723670482635498046875), SC_(108.5032548424476463598183504899336466748975635468938732532626605779594870328299994789652482831953253), SC_(90.6570957304451106144185164419238349454797081258790911488865971436148449646391904615295180665722972) }, 
      { SC_(99.6461334228515625), SC_(0.835008561611175537109375), SC_(109.3370293976377603308634730796822871722180822156146079704298307111056783571551863417375442399229845), SC_(89.92137944342759462480459816579961426775458462692578398945994611785848960085110828841885491701675714) }, 
      { SC_(99.6461334228515625), SC_(0.905791938304901123046875), SC_(112.999601070860905668295141701157176040361351555369172846468529901685867407811198602410255587767563), SC_(86.7791783017191311959905806085341928361560825596664875827422581491589972224048336103416333886978357) }, 
      { SC_(99.6461334228515625), SC_(0.9133758544921875), SC_(113.5057019266017757553572395745632780679072776470909404929295494401706417401173397780562513398354094), SC_(86.35612234649621027962836929188910335213017738233582627676662911520231216242529540127044730529945437) }, 
      { SC_(99.6461334228515625), SC_(0.968867778778076171875), SC_(119.0637249422376961671341002862243780120617645758579051054825546123558214039984323476889351592427586), SC_(81.87811103947525043911330324465564757254090604246213044539733449282580273670542563644266281418367064) }
   } };
#undef SC_


