/*
 *
 * Copyright (c) 1998-2000
 * Dr John Maddock
 *
 * Use, modification and distribution are subject to the 
 * Boost Software License, Version 1.0. (See accompanying file 
 * LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
 *
 */

#include <string>
#include <map>
#include <regex>
#include <functional>

// purpose:
// takes the contents of a file in the form of a string
// and searches for all the C++ class definitions, storing
// their locations in a map of strings/int's

typedef std::map<std::string, int, std::less<std::string> > map_type;

class class_index
{
   jm::regex expression;
   map_type index;
   std::string::const_iterator base;
   typedef reg_match<std::string::const_iterator, regex::alloc_type> arg_type;

   bool grep_callback(const reg_match<std::string::const_iterator, regex::alloc_type>& what);
public:
   map_type& get_map() { return index; }
   typedef bool (__closure* grep_callback_type)(const arg_type&);
   void IndexClasses(const std::string& file);
   class_index()
      : index(),
        expression("^(template[[:space:]]*<[^;:{]+>[[:space:]]*)?"
                   "(class|struct)[[:space:]]*(\\<\\w+\\>([[:blank:]]*\\([^)]*\\))?"
                   "[[:space:]]*)*(\\<\\w*\\>)[[:space:]]*(<[^;:{]+>[[:space:]]*)?"
                   "(\\{|:[^;\\{()]*\\{)"
                   ){}
};

bool class_index::grep_callback(const reg_match<std::string::const_iterator, regex::alloc_type>& what)
{
   // what[0] contains the whole string
   // what[5] contains the class name.
   // what[6] contains the template specialisation if any.
   // add class name and position to map:
   index[std::string(what[5].first, what[5].second) + std::string(what[6].first, what[6].second)] =
               what[5].first - base;
   return true;
}

void class_index::IndexClasses(const std::string& file)
{
   std::string::const_iterator start, end;
   start = file.begin();
   end = file.end();
   base = start;
   class_index::grep_callback_type cl = &(this->grep_callback);
   reg_grep(cl,
            start,
            end,
            expression,
            match_default);
}


using namespace std;

#include <fileiter.h>
#include <iostream>

int main(int argc, const char** argv)
{
   for(int i = 1; i < argc; ++i)
   {
      cout << "Processing file " << argv[i] << endl;
      mapfile f(argv[i]);
      std::string text(f.begin(), f.end());
      class_index i;
      i.IndexClasses(text);
      cout << i.get_map().size() << " matches found" << endl;
      map_type::iterator c, d;
      c = i.get_map().begin();
      d = i.get_map().end();
      while(c != d)
      {
         cout << "class \"" << (*c).first << "\" found at index: " << (*c).second << endl;
         ++c;
      }
   }
   return 0;
}



