#ifndef BOOST_PREPROCESSOR_FOR_HPP
#define BOOST_PREPROCESSOR_FOR_HPP

/* Copyright (C) 2001
 * Housemarque Oy
 * http://www.housemarque.com
 *
 * Permission to copy, use, modify, sell and distribute this software is
 * granted provided this copyright notice appears in all copies. This
 * software is provided "as is" without express or implied warranty, and
 * with no claim as to its suitability for any purpose.
 *
 * See http://www.boost.org for most recent version.
 */

#include <boost/preprocessor/if.hpp>
#include <boost/preprocessor/tuple/eat.hpp>

/** <p>Repeats <code>I(R,X)</code> and iterates <code>F(R,X)</code> while
<code>C(R,X)</code> is true.</p>

<p>In other words, expands to the sequence:</p>

<pre>
  I(R,X)  I(R,F(R,X))  I(R,F(R,F(R,X)))  ...  I(R,F(R,F(...F(R,X)...)))
</pre>

<p>The length of the sequence is determined by <code>C(R,X)</code>.</p>

<h3>Legend</h3>
<ul>
  <li><b>X</b> is the current state of iteration. The state is usually a tuple.</li>
  <li><b>C</b> is the condition for iteration. It must expand to a decimal
      integer literal.</li>
  <li><b>F</b> is the iterated macro. Note that if the state is a tuple, then
      F(R,X) usually expands to a tuple of the same number of elements.</li>
  <li><b>I</b> is the state instantiation macro.</li>
  <li><b>R</b> is the recursion depth and should only be used as a parameter to
      other macros using BOOST_PP_FOR() or for invoking BOOST_PP_FOR##R()
      directly. For each macro using BOOST_PP_FOR(), there is a version of the
      macro, distinguished by the R suffix, that accepts an additional
      recursion depth as the first parameter. This technique is necessary to
      avoid recursively expanding the same macro again, which is not permitted
      by the C++ preprocessor.</li>
</ul>

<h3>BOOST_PP_REPEAT() vs BOOST_PP_FOR()</h3>

<p>BOOST_PP_FOR() is a generalization of BOOST_PP_REPEAT(). This means that
BOOST_PP_REPEAT() can be implemented using BOOST_PP_FOR(). However,
BOOST_PP_REPEAT() was introduced earlier, is generally easier to use, and is
still quite useful on its own.</p>

<h3>2D and 3D repetition</h3>

<p>BOOST_PP_FOR() can be used for multidimensional repetition simply by
invoking BOOST_PP_FOR##R() directly.</p>

<h3>Test</h3>
<ul>
  <li><a href="../../test/for_test.cpp">for_test.cpp</a></li>
</ul>
*/
#define BOOST_PP_FOR(X,C,F,I) BOOST_PP_FOR0(X,C,F,I)

#ifndef DOXYGEN_SHOULD_SKIP_THIS
#define BOOST_PP_FOR_C0(C,R,X,I) BOOST_PP_IF(C(R,X),I,BOOST_PP_TUPLE2_EAT)
#define BOOST_PP_FOR_C1(C,R,X) BOOST_PP_IF(C(R,X),BOOST_PP_FOR##R,BOOST_PP_TUPLE4_EAT)
#define BOOST_PP_FOR0(X,C,F,I) BOOST_PP_FOR_C0(C,1,X,I)(1,X) BOOST_PP_FOR_C1(C,1,X)(F(1,X),C,F,I)
#define BOOST_PP_FOR1(X,C,F,I) BOOST_PP_FOR_C0(C,2,X,I)(2,X) BOOST_PP_FOR_C1(C,2,X)(F(2,X),C,F,I)
#define BOOST_PP_FOR2(X,C,F,I) BOOST_PP_FOR_C0(C,3,X,I)(3,X) BOOST_PP_FOR_C1(C,3,X)(F(3,X),C,F,I)
#define BOOST_PP_FOR3(X,C,F,I) BOOST_PP_FOR_C0(C,4,X,I)(4,X) BOOST_PP_FOR_C1(C,4,X)(F(4,X),C,F,I)
#define BOOST_PP_FOR4(X,C,F,I) BOOST_PP_FOR_C0(C,5,X,I)(5,X) BOOST_PP_FOR_C1(C,5,X)(F(5,X),C,F,I)
#define BOOST_PP_FOR5(X,C,F,I) BOOST_PP_FOR_C0(C,6,X,I)(6,X) BOOST_PP_FOR_C1(C,6,X)(F(6,X),C,F,I)
#define BOOST_PP_FOR6(X,C,F,I) BOOST_PP_FOR_C0(C,7,X,I)(7,X) BOOST_PP_FOR_C1(C,7,X)(F(7,X),C,F,I)
#define BOOST_PP_FOR7(X,C,F,I) BOOST_PP_FOR_C0(C,8,X,I)(8,X) BOOST_PP_FOR_C1(C,8,X)(F(8,X),C,F,I)
#define BOOST_PP_FOR8(X,C,F,I) BOOST_PP_FOR_C0(C,9,X,I)(9,X) BOOST_PP_FOR_C1(C,9,X)(F(9,X),C,F,I)
#define BOOST_PP_FOR9(X,C,F,I) BOOST_PP_FOR_C0(C,10,X,I)(10,X) BOOST_PP_FOR_C1(C,10,X)(F(10,X),C,F,I)
#define BOOST_PP_FOR10(X,C,F,I) BOOST_PP_FOR_C0(C,11,X,I)(11,X) BOOST_PP_FOR_C1(C,11,X)(F(11,X),C,F,I)
#define BOOST_PP_FOR11(X,C,F,I) BOOST_PP_FOR_C0(C,12,X,I)(12,X) BOOST_PP_FOR_C1(C,12,X)(F(12,X),C,F,I)
#define BOOST_PP_FOR12(X,C,F,I) BOOST_PP_FOR_C0(C,13,X,I)(13,X) BOOST_PP_FOR_C1(C,13,X)(F(13,X),C,F,I)
#define BOOST_PP_FOR13(X,C,F,I) BOOST_PP_FOR_C0(C,14,X,I)(14,X) BOOST_PP_FOR_C1(C,14,X)(F(14,X),C,F,I)
#define BOOST_PP_FOR14(X,C,F,I) BOOST_PP_FOR_C0(C,15,X,I)(15,X) BOOST_PP_FOR_C1(C,15,X)(F(15,X),C,F,I)
#define BOOST_PP_FOR15(X,C,F,I) BOOST_PP_FOR_C0(C,16,X,I)(16,X) BOOST_PP_FOR_C1(C,16,X)(F(16,X),C,F,I)
#define BOOST_PP_FOR16(X,C,F,I) BOOST_PP_FOR_C0(C,17,X,I)(17,X) BOOST_PP_FOR_C1(C,17,X)(F(17,X),C,F,I)
#define BOOST_PP_FOR17(X,C,F,I) BOOST_PP_FOR_C0(C,18,X,I)(18,X) BOOST_PP_FOR_C1(C,18,X)(F(18,X),C,F,I)
#define BOOST_PP_FOR18(X,C,F,I) BOOST_PP_FOR_C0(C,19,X,I)(19,X) BOOST_PP_FOR_C1(C,19,X)(F(19,X),C,F,I)
#define BOOST_PP_FOR19(X,C,F,I) BOOST_PP_FOR_C0(C,20,X,I)(20,X) BOOST_PP_FOR_C1(C,20,X)(F(20,X),C,F,I)
#define BOOST_PP_FOR20(X,C,F,I) BOOST_PP_FOR_C0(C,21,X,I)(21,X) BOOST_PP_FOR_C1(C,21,X)(F(21,X),C,F,I)
#define BOOST_PP_FOR21(X,C,F,I) BOOST_PP_FOR_C0(C,22,X,I)(22,X) BOOST_PP_FOR_C1(C,22,X)(F(22,X),C,F,I)
#define BOOST_PP_FOR22(X,C,F,I) BOOST_PP_FOR_C0(C,23,X,I)(23,X) BOOST_PP_FOR_C1(C,23,X)(F(23,X),C,F,I)
#define BOOST_PP_FOR23(X,C,F,I) BOOST_PP_FOR_C0(C,24,X,I)(24,X) BOOST_PP_FOR_C1(C,24,X)(F(24,X),C,F,I)
#define BOOST_PP_FOR24(X,C,F,I) BOOST_PP_FOR_C0(C,25,X,I)(25,X) BOOST_PP_FOR_C1(C,25,X)(F(25,X),C,F,I)
#define BOOST_PP_FOR25(X,C,F,I) BOOST_PP_FOR_C0(C,26,X,I)(26,X) BOOST_PP_FOR_C1(C,26,X)(F(26,X),C,F,I)
#define BOOST_PP_FOR26(X,C,F,I) BOOST_PP_FOR_C0(C,27,X,I)(27,X) BOOST_PP_FOR_C1(C,27,X)(F(27,X),C,F,I)
#define BOOST_PP_FOR27(X,C,F,I) BOOST_PP_FOR_C0(C,28,X,I)(28,X) BOOST_PP_FOR_C1(C,28,X)(F(28,X),C,F,I)
#define BOOST_PP_FOR28(X,C,F,I) BOOST_PP_FOR_C0(C,29,X,I)(29,X) BOOST_PP_FOR_C1(C,29,X)(F(29,X),C,F,I)
#define BOOST_PP_FOR29(X,C,F,I) BOOST_PP_FOR_C0(C,30,X,I)(30,X) BOOST_PP_FOR_C1(C,30,X)(F(30,X),C,F,I)
#define BOOST_PP_FOR30(X,C,F,I) BOOST_PP_FOR_C0(C,31,X,I)(31,X) BOOST_PP_FOR_C1(C,31,X)(F(31,X),C,F,I)
#define BOOST_PP_FOR31(X,C,F,I) BOOST_PP_FOR_C0(C,32,X,I)(32,X) BOOST_PP_FOR_C1(C,32,X)(F(32,X),C,F,I)
#define BOOST_PP_FOR32(X,C,F,I) BOOST_PP_FOR_C0(C,33,X,I)(33,X) BOOST_PP_FOR_C1(C,33,X)(F(33,X),C,F,I)
#define BOOST_PP_FOR33(X,C,F,I) BOOST_PP_FOR_C0(C,34,X,I)(34,X) BOOST_PP_FOR_C1(C,34,X)(F(34,X),C,F,I)
#define BOOST_PP_FOR34(X,C,F,I) BOOST_PP_FOR_C0(C,35,X,I)(35,X) BOOST_PP_FOR_C1(C,35,X)(F(35,X),C,F,I)
#define BOOST_PP_FOR35(X,C,F,I) BOOST_PP_FOR_C0(C,36,X,I)(36,X) BOOST_PP_FOR_C1(C,36,X)(F(36,X),C,F,I)
#define BOOST_PP_FOR36(X,C,F,I) BOOST_PP_FOR_C0(C,37,X,I)(37,X) BOOST_PP_FOR_C1(C,37,X)(F(37,X),C,F,I)
#define BOOST_PP_FOR37(X,C,F,I) BOOST_PP_FOR_C0(C,38,X,I)(38,X) BOOST_PP_FOR_C1(C,38,X)(F(38,X),C,F,I)
#define BOOST_PP_FOR38(X,C,F,I) BOOST_PP_FOR_C0(C,39,X,I)(39,X) BOOST_PP_FOR_C1(C,39,X)(F(39,X),C,F,I)
#define BOOST_PP_FOR39(X,C,F,I) BOOST_PP_FOR_C0(C,40,X,I)(40,X) BOOST_PP_FOR_C1(C,40,X)(F(40,X),C,F,I)
#define BOOST_PP_FOR40(X,C,F,I) BOOST_PP_FOR_C0(C,41,X,I)(41,X) BOOST_PP_FOR_C1(C,41,X)(F(41,X),C,F,I)
#define BOOST_PP_FOR41(X,C,F,I) BOOST_PP_FOR_C0(C,42,X,I)(42,X) BOOST_PP_FOR_C1(C,42,X)(F(42,X),C,F,I)
#define BOOST_PP_FOR42(X,C,F,I) BOOST_PP_FOR_C0(C,43,X,I)(43,X) BOOST_PP_FOR_C1(C,43,X)(F(43,X),C,F,I)
#define BOOST_PP_FOR43(X,C,F,I) BOOST_PP_FOR_C0(C,44,X,I)(44,X) BOOST_PP_FOR_C1(C,44,X)(F(44,X),C,F,I)
#define BOOST_PP_FOR44(X,C,F,I) BOOST_PP_FOR_C0(C,45,X,I)(45,X) BOOST_PP_FOR_C1(C,45,X)(F(45,X),C,F,I)
#define BOOST_PP_FOR45(X,C,F,I) BOOST_PP_FOR_C0(C,46,X,I)(46,X) BOOST_PP_FOR_C1(C,46,X)(F(46,X),C,F,I)
#define BOOST_PP_FOR46(X,C,F,I) BOOST_PP_FOR_C0(C,47,X,I)(47,X) BOOST_PP_FOR_C1(C,47,X)(F(47,X),C,F,I)
#define BOOST_PP_FOR47(X,C,F,I) BOOST_PP_FOR_C0(C,48,X,I)(48,X) BOOST_PP_FOR_C1(C,48,X)(F(48,X),C,F,I)
#define BOOST_PP_FOR48(X,C,F,I) BOOST_PP_FOR_C0(C,49,X,I)(49,X) BOOST_PP_FOR_C1(C,49,X)(F(49,X),C,F,I)
#define BOOST_PP_FOR49(X,C,F,I) BOOST_PP_FOR_C0(C,50,X,I)(50,X) BOOST_PP_FOR_C1(C,50,X)(F(50,X),C,F,I)
#define BOOST_PP_FOR50(X,C,F,I) BOOST_PP_FOR_C0(C,51,X,I)(51,X) BOOST_PP_FOR_C1(C,51,X)(F(51,X),C,F,I)
#define BOOST_PP_FOR51(X,C,F,I) BOOST_PP_FOR_C0(C,52,X,I)(52,X) BOOST_PP_FOR_C1(C,52,X)(F(52,X),C,F,I)
#define BOOST_PP_FOR52(X,C,F,I) BOOST_PP_FOR_C0(C,53,X,I)(53,X) BOOST_PP_FOR_C1(C,53,X)(F(53,X),C,F,I)
#define BOOST_PP_FOR53(X,C,F,I) BOOST_PP_FOR_C0(C,54,X,I)(54,X) BOOST_PP_FOR_C1(C,54,X)(F(54,X),C,F,I)
#define BOOST_PP_FOR54(X,C,F,I) BOOST_PP_FOR_C0(C,55,X,I)(55,X) BOOST_PP_FOR_C1(C,55,X)(F(55,X),C,F,I)
#define BOOST_PP_FOR55(X,C,F,I) BOOST_PP_FOR_C0(C,56,X,I)(56,X) BOOST_PP_FOR_C1(C,56,X)(F(56,X),C,F,I)
#define BOOST_PP_FOR56(X,C,F,I) BOOST_PP_FOR_C0(C,57,X,I)(57,X) BOOST_PP_FOR_C1(C,57,X)(F(57,X),C,F,I)
#define BOOST_PP_FOR57(X,C,F,I) BOOST_PP_FOR_C0(C,58,X,I)(58,X) BOOST_PP_FOR_C1(C,58,X)(F(58,X),C,F,I)
#define BOOST_PP_FOR58(X,C,F,I) BOOST_PP_FOR_C0(C,59,X,I)(59,X) BOOST_PP_FOR_C1(C,59,X)(F(59,X),C,F,I)
#define BOOST_PP_FOR59(X,C,F,I) BOOST_PP_FOR_C0(C,60,X,I)(60,X) BOOST_PP_FOR_C1(C,60,X)(F(60,X),C,F,I)
#define BOOST_PP_FOR60(X,C,F,I) BOOST_PP_FOR_C0(C,61,X,I)(61,X) BOOST_PP_FOR_C1(C,61,X)(F(61,X),C,F,I)
#define BOOST_PP_FOR61(X,C,F,I) BOOST_PP_FOR_C0(C,62,X,I)(62,X) BOOST_PP_FOR_C1(C,62,X)(F(62,X),C,F,I)
#define BOOST_PP_FOR62(X,C,F,I) BOOST_PP_FOR_C0(C,63,X,I)(63,X) BOOST_PP_FOR_C1(C,63,X)(F(63,X),C,F,I)
#define BOOST_PP_FOR63(X,C,F,I) BOOST_PP_FOR_C0(C,64,X,I)(64,X) BOOST_PP_FOR_C1(C,64,X)(F(64,X),C,F,I)
#define BOOST_PP_FOR64(X,C,F,I) BOOST_PP_FOR_C0(C,65,X,I)(65,X) BOOST_PP_FOR_C1(C,65,X)(F(65,X),C,F,I)
#define BOOST_PP_FOR65(X,C,F,I) BOOST_PP_FOR_C0(C,66,X,I)(66,X) BOOST_PP_FOR_C1(C,66,X)(F(66,X),C,F,I)
#define BOOST_PP_FOR66(X,C,F,I) BOOST_PP_FOR_C0(C,67,X,I)(67,X) BOOST_PP_FOR_C1(C,67,X)(F(67,X),C,F,I)
#define BOOST_PP_FOR67(X,C,F,I) BOOST_PP_FOR_C0(C,68,X,I)(68,X) BOOST_PP_FOR_C1(C,68,X)(F(68,X),C,F,I)
#define BOOST_PP_FOR68(X,C,F,I) BOOST_PP_FOR_C0(C,69,X,I)(69,X) BOOST_PP_FOR_C1(C,69,X)(F(69,X),C,F,I)
#define BOOST_PP_FOR69(X,C,F,I) BOOST_PP_FOR_C0(C,70,X,I)(70,X) BOOST_PP_FOR_C1(C,70,X)(F(70,X),C,F,I)
#define BOOST_PP_FOR70(X,C,F,I) BOOST_PP_FOR_C0(C,71,X,I)(71,X) BOOST_PP_FOR_C1(C,71,X)(F(71,X),C,F,I)
#define BOOST_PP_FOR71(X,C,F,I) BOOST_PP_FOR_C0(C,72,X,I)(72,X) BOOST_PP_FOR_C1(C,72,X)(F(72,X),C,F,I)
#define BOOST_PP_FOR72(X,C,F,I) BOOST_PP_FOR_C0(C,73,X,I)(73,X) BOOST_PP_FOR_C1(C,73,X)(F(73,X),C,F,I)
#define BOOST_PP_FOR73(X,C,F,I) BOOST_PP_FOR_C0(C,74,X,I)(74,X) BOOST_PP_FOR_C1(C,74,X)(F(74,X),C,F,I)
#define BOOST_PP_FOR74(X,C,F,I) BOOST_PP_FOR_C0(C,75,X,I)(75,X) BOOST_PP_FOR_C1(C,75,X)(F(75,X),C,F,I)
#define BOOST_PP_FOR75(X,C,F,I) BOOST_PP_FOR_C0(C,76,X,I)(76,X) BOOST_PP_FOR_C1(C,76,X)(F(76,X),C,F,I)
#define BOOST_PP_FOR76(X,C,F,I) BOOST_PP_FOR_C0(C,77,X,I)(77,X) BOOST_PP_FOR_C1(C,77,X)(F(77,X),C,F,I)
#define BOOST_PP_FOR77(X,C,F,I) BOOST_PP_FOR_C0(C,78,X,I)(78,X) BOOST_PP_FOR_C1(C,78,X)(F(78,X),C,F,I)
#define BOOST_PP_FOR78(X,C,F,I) BOOST_PP_FOR_C0(C,79,X,I)(79,X) BOOST_PP_FOR_C1(C,79,X)(F(79,X),C,F,I)
#define BOOST_PP_FOR79(X,C,F,I) BOOST_PP_FOR_C0(C,80,X,I)(80,X) BOOST_PP_FOR_C1(C,80,X)(F(80,X),C,F,I)
#define BOOST_PP_FOR80(X,C,F,I) BOOST_PP_FOR_C0(C,81,X,I)(81,X) BOOST_PP_FOR_C1(C,81,X)(F(81,X),C,F,I)
#define BOOST_PP_FOR81(X,C,F,I) BOOST_PP_FOR_C0(C,82,X,I)(82,X) BOOST_PP_FOR_C1(C,82,X)(F(82,X),C,F,I)
#define BOOST_PP_FOR82(X,C,F,I) BOOST_PP_FOR_C0(C,83,X,I)(83,X) BOOST_PP_FOR_C1(C,83,X)(F(83,X),C,F,I)
#define BOOST_PP_FOR83(X,C,F,I) BOOST_PP_FOR_C0(C,84,X,I)(84,X) BOOST_PP_FOR_C1(C,84,X)(F(84,X),C,F,I)
#define BOOST_PP_FOR84(X,C,F,I) BOOST_PP_FOR_C0(C,85,X,I)(85,X) BOOST_PP_FOR_C1(C,85,X)(F(85,X),C,F,I)
#define BOOST_PP_FOR85(X,C,F,I) BOOST_PP_FOR_C0(C,86,X,I)(86,X) BOOST_PP_FOR_C1(C,86,X)(F(86,X),C,F,I)
#define BOOST_PP_FOR86(X,C,F,I) BOOST_PP_FOR_C0(C,87,X,I)(87,X) BOOST_PP_FOR_C1(C,87,X)(F(87,X),C,F,I)
#define BOOST_PP_FOR87(X,C,F,I) BOOST_PP_FOR_C0(C,88,X,I)(88,X) BOOST_PP_FOR_C1(C,88,X)(F(88,X),C,F,I)
#define BOOST_PP_FOR88(X,C,F,I) BOOST_PP_FOR_C0(C,89,X,I)(89,X) BOOST_PP_FOR_C1(C,89,X)(F(89,X),C,F,I)
#define BOOST_PP_FOR89(X,C,F,I) BOOST_PP_FOR_C0(C,90,X,I)(90,X) BOOST_PP_FOR_C1(C,90,X)(F(90,X),C,F,I)
#define BOOST_PP_FOR90(X,C,F,I) BOOST_PP_FOR_C0(C,91,X,I)(91,X) BOOST_PP_FOR_C1(C,91,X)(F(91,X),C,F,I)
#define BOOST_PP_FOR91(X,C,F,I) BOOST_PP_FOR_C0(C,92,X,I)(92,X) BOOST_PP_FOR_C1(C,92,X)(F(92,X),C,F,I)
#define BOOST_PP_FOR92(X,C,F,I) BOOST_PP_FOR_C0(C,93,X,I)(93,X) BOOST_PP_FOR_C1(C,93,X)(F(93,X),C,F,I)
#define BOOST_PP_FOR93(X,C,F,I) BOOST_PP_FOR_C0(C,94,X,I)(94,X) BOOST_PP_FOR_C1(C,94,X)(F(94,X),C,F,I)
#define BOOST_PP_FOR94(X,C,F,I) BOOST_PP_FOR_C0(C,95,X,I)(95,X) BOOST_PP_FOR_C1(C,95,X)(F(95,X),C,F,I)
#define BOOST_PP_FOR95(X,C,F,I) BOOST_PP_FOR_C0(C,96,X,I)(96,X) BOOST_PP_FOR_C1(C,96,X)(F(96,X),C,F,I)
#define BOOST_PP_FOR96(X,C,F,I) BOOST_PP_FOR_C0(C,97,X,I)(97,X) BOOST_PP_FOR_C1(C,97,X)(F(97,X),C,F,I)
#define BOOST_PP_FOR97(X,C,F,I) BOOST_PP_FOR_C0(C,98,X,I)(98,X) BOOST_PP_FOR_C1(C,98,X)(F(98,X),C,F,I)
#define BOOST_PP_FOR98(X,C,F,I) BOOST_PP_FOR_C0(C,99,X,I)(99,X) BOOST_PP_FOR_C1(C,99,X)(F(99,X),C,F,I)
#define BOOST_PP_FOR99(X,C,F,I) BOOST_PP_FOR_C0(C,100,X,I)(100,X) BOOST_PP_FOR_C1(C,100,X)(F(100,X),C,F,I)
#define BOOST_PP_FOR100(X,C,F,I) BOOST_PP_FOR_C0(C,101,X,I)(101,X) BOOST_PP_FOR_C1(C,101,X)(F(101,X),C,F,I)
#define BOOST_PP_FOR101(X,C,F,I) BOOST_PP_FOR_C0(C,102,X,I)(102,X) BOOST_PP_FOR_C1(C,102,X)(F(102,X),C,F,I)
#define BOOST_PP_FOR102(X,C,F,I) BOOST_PP_FOR_C0(C,103,X,I)(103,X) BOOST_PP_FOR_C1(C,103,X)(F(103,X),C,F,I)
#define BOOST_PP_FOR103(X,C,F,I) BOOST_PP_FOR_C0(C,104,X,I)(104,X) BOOST_PP_FOR_C1(C,104,X)(F(104,X),C,F,I)
#define BOOST_PP_FOR104(X,C,F,I) BOOST_PP_FOR_C0(C,105,X,I)(105,X) BOOST_PP_FOR_C1(C,105,X)(F(105,X),C,F,I)
#define BOOST_PP_FOR105(X,C,F,I) BOOST_PP_FOR_C0(C,106,X,I)(106,X) BOOST_PP_FOR_C1(C,106,X)(F(106,X),C,F,I)
#define BOOST_PP_FOR106(X,C,F,I) BOOST_PP_FOR_C0(C,107,X,I)(107,X) BOOST_PP_FOR_C1(C,107,X)(F(107,X),C,F,I)
#define BOOST_PP_FOR107(X,C,F,I) BOOST_PP_FOR_C0(C,108,X,I)(108,X) BOOST_PP_FOR_C1(C,108,X)(F(108,X),C,F,I)
#define BOOST_PP_FOR108(X,C,F,I) BOOST_PP_FOR_C0(C,109,X,I)(109,X) BOOST_PP_FOR_C1(C,109,X)(F(109,X),C,F,I)
#define BOOST_PP_FOR109(X,C,F,I) BOOST_PP_FOR_C0(C,110,X,I)(110,X) BOOST_PP_FOR_C1(C,110,X)(F(110,X),C,F,I)
#define BOOST_PP_FOR110(X,C,F,I) BOOST_PP_FOR_C0(C,111,X,I)(111,X) BOOST_PP_FOR_C1(C,111,X)(F(111,X),C,F,I)
#define BOOST_PP_FOR111(X,C,F,I) BOOST_PP_FOR_C0(C,112,X,I)(112,X) BOOST_PP_FOR_C1(C,112,X)(F(112,X),C,F,I)
#define BOOST_PP_FOR112(X,C,F,I) BOOST_PP_FOR_C0(C,113,X,I)(113,X) BOOST_PP_FOR_C1(C,113,X)(F(113,X),C,F,I)
#define BOOST_PP_FOR113(X,C,F,I) BOOST_PP_FOR_C0(C,114,X,I)(114,X) BOOST_PP_FOR_C1(C,114,X)(F(114,X),C,F,I)
#define BOOST_PP_FOR114(X,C,F,I) BOOST_PP_FOR_C0(C,115,X,I)(115,X) BOOST_PP_FOR_C1(C,115,X)(F(115,X),C,F,I)
#define BOOST_PP_FOR115(X,C,F,I) BOOST_PP_FOR_C0(C,116,X,I)(116,X) BOOST_PP_FOR_C1(C,116,X)(F(116,X),C,F,I)
#define BOOST_PP_FOR116(X,C,F,I) BOOST_PP_FOR_C0(C,117,X,I)(117,X) BOOST_PP_FOR_C1(C,117,X)(F(117,X),C,F,I)
#define BOOST_PP_FOR117(X,C,F,I) BOOST_PP_FOR_C0(C,118,X,I)(118,X) BOOST_PP_FOR_C1(C,118,X)(F(118,X),C,F,I)
#define BOOST_PP_FOR118(X,C,F,I) BOOST_PP_FOR_C0(C,119,X,I)(119,X) BOOST_PP_FOR_C1(C,119,X)(F(119,X),C,F,I)
#define BOOST_PP_FOR119(X,C,F,I) BOOST_PP_FOR_C0(C,120,X,I)(120,X) BOOST_PP_FOR_C1(C,120,X)(F(120,X),C,F,I)
#define BOOST_PP_FOR120(X,C,F,I) BOOST_PP_FOR_C0(C,121,X,I)(121,X) BOOST_PP_FOR_C1(C,121,X)(F(121,X),C,F,I)
#define BOOST_PP_FOR121(X,C,F,I) BOOST_PP_FOR_C0(C,122,X,I)(122,X) BOOST_PP_FOR_C1(C,122,X)(F(122,X),C,F,I)
#define BOOST_PP_FOR122(X,C,F,I) BOOST_PP_FOR_C0(C,123,X,I)(123,X) BOOST_PP_FOR_C1(C,123,X)(F(123,X),C,F,I)
#define BOOST_PP_FOR123(X,C,F,I) BOOST_PP_FOR_C0(C,124,X,I)(124,X) BOOST_PP_FOR_C1(C,124,X)(F(124,X),C,F,I)
#define BOOST_PP_FOR124(X,C,F,I) BOOST_PP_FOR_C0(C,125,X,I)(125,X) BOOST_PP_FOR_C1(C,125,X)(F(125,X),C,F,I)
#define BOOST_PP_FOR125(X,C,F,I) BOOST_PP_FOR_C0(C,126,X,I)(126,X) BOOST_PP_FOR_C1(C,126,X)(F(126,X),C,F,I)
#define BOOST_PP_FOR126(X,C,F,I) BOOST_PP_FOR_C0(C,127,X,I)(127,X) BOOST_PP_FOR_C1(C,127,X)(F(127,X),C,F,I)
#define BOOST_PP_FOR127(X,C,F,I) BOOST_PP_FOR_C0(C,128,X,I)(128,X) BOOST_PP_FOR_C1(C,128,X)(F(128,X),C,F,I)
#define BOOST_PP_FOR128(X,C,F,I) BOOST_PP_FOR_C0(C,129,X,I)(129,X) BOOST_PP_FOR_C1(C,129,X)(F(129,X),C,F,I)
#define BOOST_PP_FOR129(C,F,I,X) RECURSION DEPTH EXCEEDED!
#endif
#endif
