
#ifndef BOOST_RE_OPT_H
#define BOOST_RE_OPT_H

/* #define BOOST_RE_AUTO_CONFIGURE */
#ifdef BOOST_RE_AUTO_CONFIGURE

/* Compiler options: */

/* BOOST_NO_STDC_NAMESPACE         C library not in namespace std */
/* #define BOOST_NO_STDC_NAMESPACE */

/* BOOST_RE_NO_MUTABLE             Disables use of mutable keyword. */
/* #define BOOST_RE_NO_MUTABLE */

/* BOOST_RE_INT32_LONG            If 32-bit integers are long */
/* #define BOOST_RE_INT32_LONG */

/* BOOST_RE_NO_TEMPLATE_FRIEND     If template friend declarations are not supported */
/* #define BOOST_RE_NO_TEMPLATE_FRIEND */

/* BOOST_RE_PLATFORM_WINDOWS       Platform is MS Windows. */
/* #define BOOST_RE_PLATFORM_WINDOWS */

/* BOOST_RE_PLATFORM_DOS           Platform if MSDOS. */
/* #define BOOST_RE_PLATFORM_DOS */

/* BOOST_RE_PLATFORM_W32           Platform is MS Win32 */
/* #define BOOST_RE_PLATFORM_W32 */

/* BOOST_RE_NO_W32               Disable Win32 support even when present */
/* #define BOOST_RE_NO_W32 */

/* BOOST_RE_NO_BOOL                If bool is not a distict type. */
/* #define BOOST_RE_NO_BOOL */

/* BOOST_RE_NO_WCHAR_H             If there is no <wchar.h> */
/* #define BOOST_RE_NO_WCHAR_H */

/* BOOST_RE_NO_WCTYPE_H            If there is no <wctype.h> */
/* #define BOOST_RE_NO_WCTYPE_H */

/* BOOST_RE_NO_WCSTRING            If there are no wcslen and wcsncmp functions available. */
/* #define BOOST_RE_NO_WCSTRING */

/* BOOST_RE_NO_SWPRINTF            If there is no swprintf available. */
/* #define BOOST_RE_NO_SWPRINTF */

/* BOOST_RE_NO_WSPRINTF            If there is no wsprintf available. */
/* #define BOOST_RE_NO_WSPRINTF */

/* BOOST_RE_NO_MEMBER_TEMPLATES    If member function templates or nested template classes are not allowed. */
/* #define BOOST_RE_NO_MEMBER_TEMPLATES */

/* BOOST_RE_NO_TEMPLATE_RETURNS    If template functions based on return type are not supported. */
/* #define BOOST_RE_NO_TEMPLATE_RETURNS */

/* BOOST_RE_NO_PARTIAL_FUNC_SPEC   If partial template function specialisation is not supported */
/* #define BOOST_RE_NO_PARTIAL_FUNC_SPEC */

/* BOOST_RE_NO_INT64               If 64bit integers are not supported. */
/* BOOST_RE_INT64t                 The type of a 64-bit signed integer if available. */
/* BOOST_RE_IMM64(val)             Declares a 64-bit immediate value by appending any
                             necessary suffix to val. */
/* BOOST_RE_INT64_T                0 = NA
                             1 = short
                      2 = int
                      3 = long
                      4 = int64_t
                      5 = long long
                      6 = __int64 */
/* #define BOOST_RE_INT64_T_0 */
/* #define BOOST_RE_INT64_T_1 */
/* #define BOOST_RE_INT64_T_2 */
/* #define BOOST_RE_INT64_T_3 */
/* #define BOOST_RE_INT64_T_4 */
/* #define BOOST_RE_INT64_T_5 */
/* #define BOOST_RE_INT64_T_6 */

/* BOOST_RE_NO_CAT                 Define if the compiler does not support POSIX style
                             message categories (catopen catgets catclose). */
/* #define BOOST_RE_NO_CAT */

/* BOOST_RE_THREADS                Define if the compiler supports multiple threads in
                             the current translation mode. */
/* #define BOOST_RE_THREADS */

/* BOOST_RE_NESTED_TEMPLATE_DECL   Defaults to template, the standard prefix when accessing
                             nested template classes, can be redefined to nothing if
                             the compiler does not support this. */
/* #define BOOST_RE_NESTED_TEMPLATE_DECL */

/* BOOST_RE_NO_TEMPLATE_INST       If explicit template instantiation with the "template class X<T>"
                             syntax is not supported */
/* #define BOOST_RE_NO_TEMPLATE_INST */

/* BOOST_RE_NO_TEMPLATE_MERGE      If template in separate translation units don't merge at link time */
/* #define BOOST_RE_NO_TEMPLATE_MERGE */

/* BOOST_RE_NO_TEMPLATE_MERGE_A    If template merging from library archives is not supported */
/* #define BOOST_RE_NO_TEMPLATE_MERGE_A */

/* BOOST_RE_NO_TEMPLATE_SWITCH_MERGE If merging of templates containing switch statements is not supported */
/* #define BOOST_RE_NO_TEMPLATE_SWITCH_MERGE */

/* BOOST_RE_CALL                   Optionally define a calling convention for C++ functions */
/* #define BOOST_RE_CALL */

/* BOOST_RE_CCALL                  Optionally define a calling convention for C functions */
/* #define BOOST_RE_CCALL */

/* BOOST_RE_SIZEOF_SHORT           sizeof(short) */
/* #define BOOST_RE_SIZEOF_SHORT */

/* BOOST_RE_SIZEOF_INT             sizeof(int) */
/* #define BOOST_RE_SIZEOF_INT */

/* BOOST_RE_SIZEOF_LONG            sizeof(long) */
/* #define BOOST_RE_SIZEOF_LONG */

/* BOOST_RE_SIZEOF_WCHAR_T         sizeof(wchar_t) */
/* #define BOOST_RE_SIZEOF_WCHAR_T */


/* STL options: */

/* BOOST_RE_NO_ITERATOR_H          Define if you do not have a version of <iterator>. */
/* #define BOOST_RE_NO_ITERATOR_H */

/* BOOST_RE_NO_MEMORY_H            Define if <memory> does not fully comply with the
                             latest standard, and is not auto-recognised,
                             that means nested template classes
                             which hardly any compilers support at present. */
/* #define BOOST_RE_NO_MEMORY_H */

/* BOOST_RE_NO_LOCALE_H            Define if there is no verion of the standard
                             <locale> header available. */
/* #define BOOST_RE_NO_LOCALE_H */

/* BOOST_RE_NO_STL                 Disables the use of any supporting STL code. */
/* #define BOOST_RE_NO_STL */

/* BOOST_RE_NO_NOT_EQUAL           Disables the generation of operator!= if this
                             clashes with the STL version. */

/* BOOST_RE_NO_STRING_DEF_ARGS     Define if std::basic_string<charT> not allowed - in
                             other words if the template is missing its required
                      default arguments. */
/* #define BOOST_RE_NO_STRING_DEF_ARGS */

/* BOOST_RE_USE_ALGO               If <algo.h> not <algorithm> is present */
/* #define BOOST_RE_USE_ALGO */

/* BOOST_RE_OLD_IOSTREAM           If the new iostreamm classes are not available */
/* #define BOOST_RE_OLD_IOSTREAM */

/* BOOST_RE_DISTANCE_T             For std::distance:
                             0 = NA
                      1 = std::distance(i, j, n)
                      2 = n = std::distance(i, j) */
/* #define BOOST_RE_DISTANCE_T_0 */
/* #define BOOST_RE_DISTANCE_T_1 */
/* #define BOOST_RE_DISTANCE_T_2 */

/* BOOST_RE_ITERATOR_T             Defines generic standard iterator type if available, use this as
                             a shortcut to define all the other iterator types.
                             1 = std::iterator<std::tag_type, T, D, T*, T&>
                      2 = std::iterator<std::tag_type, T, D> */
/* #define BOOST_RE_ITERATOR_T_0 */
/* #define BOOST_RE_ITERATOR_T_1 */
/* #define BOOST_RE_ITERATOR_T_2 */

/* BOOST_RE_OI_T                   For output iterators:
                             0 = NA
                      1 = std::iterator<std::output_iterator_tag, T, D, T*, T&>
                      2 = std::iterator<std::output_iterator_tag, T, D>
                      3 = std::output_iterator */
/* #define BOOST_RE_OI_T_0 */
/* #define BOOST_RE_OI_T_1 */
/* #define BOOST_RE_OI_T_2 */
/* #define BOOST_RE_OI_T_3 */

/* BOOST_RE_II_T                   For input iterators:
                             0 = NA
                      1 = std::iterator<std::input_iterator_tag, T, D, T*, T&>
                      2 = std::iterator<std::input_iterator_tag, T, D>
                      3 = std::input_iterator<T, D>
                      4 = std::input_iterator<T> */
/* #define BOOST_RE_II_T_0 */
/* #define BOOST_RE_II_T_1 */
/* #define BOOST_RE_II_T_2 */
/* #define BOOST_RE_II_T_3 */
/* #define BOOST_RE_II_T_4 */


/* BOOST_RE_FI_T                   For forward iterators:
                             0 = NA
                      1 = std::iterator<std::forward_iterator_tag, T, D, T*, T&>
                      2 = std::iterator<std::forward_iterator_tag, T, D>
                      3 = std::forward_iterator<T, D> */
/* #define BOOST_RE_FI_T_0 */
/* #define BOOST_RE_FI_T_1 */
/* #define BOOST_RE_FI_T_2 */
/* #define BOOST_RE_FI_T_3 */

/* BOOST_RE_BI_T                   For bidirectional iterators:
                             0 = NA
                      1 = std::iterator<std::bidirectional_iterator_tag, T, D, T*, T&>
                      2 = std::iterator<std::bidirectional_iterator_tag, T, D>
                      3 = std::bidirectional_iterator<T, D> */
/* #define BOOST_RE_BI_T_0 */
/* #define BOOST_RE_BI_T_1 */
/* #define BOOST_RE_BI_T_2 */
/* #define BOOST_RE_BI_T_3 */

/* BOOST_RE_RI_T                   For random access iterators:
                             0 = NA
                             1 = std::iterator<std::random_access_iterator_tag, T, D, T*, T&>
                      2 = std::iterator<std::random_access_iterator_tag, T, D>
                      3 = std::random_access_iterator<T, D> */
/* #define BOOST_RE_RI_T_0 */
/* #define BOOST_RE_RI_T_1 */
/* #define BOOST_RE_RI_T_2 */
/* #define BOOST_RE_RI_T_3 */

/* BOOST_RE_NO_OI_ASSIGN           If output iterators ostream_iterator<>, back_insert_iterator<> and 
                             front_insert_iterator<> do not have assignment operators */
/* #define BOOST_RE_NO_OI_ASSIGN */


#ifdef BOOST_RE_INT64_T_0
#define BOOST_RE_NO_INT64
#elif defined(BOOST_RE_INT64_T_1)
#define BOOST_RE_INT64t short
#define BOOST_RE_IMM64(val) val
#elif defined(BOOST_RE_INT64_T_2)
#define BOOST_RE_INT64t int
#define BOOST_RE_IMM64(val) val
#elif defined(BOOST_RE_INT64_T_3)
#define BOOST_RE_INT64t long
#define BOOST_RE_IMM64(val) val##L
#elif defined(BOOST_RE_INT64_T_4)
#define BOOST_RE_INT64t int64_t
#define BOOST_RE_IMM64(val) INT64_C(val)
#elif defined(BOOST_RE_INT64_T_5)
#define BOOST_RE_INT64t long long
#define BOOST_RE_IMM64(val) val##LL
#elif defined(BOOST_RE_INT64_T_6)
#define BOOST_RE_INT64t __int64
#define BOOST_RE_IMM64(val) val##i64
#else
syntax error: unknown value for BOOST_RE_INT64_T
#endif

#ifdef BOOST_RE_DISTANCE_T_0
#  define BOOST_RE_DISTANCE(i, j, n) n = j - i
#elif defined(BOOST_RE_DISTANCE_T_1)
#  define BOOST_RE_DISTANCE(i, j, n) n = std::distance(i, j)
#elif defined(BOOST_RE_DISTANCE_T_2)
#  define BOOST_RE_DISTANCE(i, j, n) (n = 0, std::distance(i, j, n))
#else
syntax erorr
#endif

#ifdef BOOST_RE_ITERATOR_T_0
#ifndef BOOST_RE_OI_T_0
#define BOOST_RE_OI_T_0 BOOST_RE_ITERATOR_T_0
#endif
#ifndef BOOST_RE_II_T_0
#define BOOST_RE_II_T_0 BOOST_RE_ITERATOR_T_0
#endif
#ifndef BOOST_RE_FI_T_0
#define BOOST_RE_FI_T_0 BOOST_RE_ITERATOR_T_0
#endif
#ifndef BOOST_RE_BI_T_0
#define BOOST_RE_BI_T_0 BOOST_RE_ITERATOR_T_0
#endif
#ifndef BOOST_RE_RI_T_0
#define BOOST_RE_RI_T_0 BOOST_RE_ITERATOR_T_0
#endif
#endif

#ifdef BOOST_RE_ITERATOR_T_1
#ifndef BOOST_RE_OI_T_1
#define BOOST_RE_OI_T_1 BOOST_RE_ITERATOR_T_1
#endif
#ifndef BOOST_RE_II_T_1
#define BOOST_RE_II_T_1 BOOST_RE_ITERATOR_T_1
#endif
#ifndef BOOST_RE_FI_T_1
#define BOOST_RE_FI_T_1 BOOST_RE_ITERATOR_T_1
#endif
#ifndef BOOST_RE_BI_T_1
#define BOOST_RE_BI_T_1 BOOST_RE_ITERATOR_T_1
#endif
#ifndef BOOST_RE_RI_T_1
#define BOOST_RE_RI_T_1 BOOST_RE_ITERATOR_T_1
#endif
#endif

#ifdef BOOST_RE_ITERATOR_T_2
#ifndef BOOST_RE_OI_T_2
#define BOOST_RE_OI_T_2 BOOST_RE_ITERATOR_T_2
#endif
#ifndef BOOST_RE_II_T_2
#define BOOST_RE_II_T_2 BOOST_RE_ITERATOR_T_2
#endif
#ifndef BOOST_RE_FI_T_2
#define BOOST_RE_FI_T_2 BOOST_RE_ITERATOR_T_2
#endif
#ifndef BOOST_RE_BI_T_2
#define BOOST_RE_BI_T_2 BOOST_RE_ITERATOR_T_2
#endif
#ifndef BOOST_RE_RI_T_2
#define BOOST_RE_RI_T_2 BOOST_RE_ITERATOR_T_2
#endif
#endif

#ifdef BOOST_RE_ITERATOR_T_3
#ifndef BOOST_RE_OI_T_3
#define BOOST_RE_OI_T_3 BOOST_RE_ITERATOR_T_3
#endif
#ifndef BOOST_RE_II_T_3
#define BOOST_RE_II_T_3 BOOST_RE_ITERATOR_T_3
#endif
#ifndef BOOST_RE_FI_T_3
#define BOOST_RE_FI_T_3 BOOST_RE_ITERATOR_T_3
#endif
#ifndef BOOST_RE_BI_T_3
#define BOOST_RE_BI_T_3 BOOST_RE_ITERATOR_T_3
#endif
#ifndef BOOST_RE_RI_T_3
#define BOOST_RE_RI_T_3 BOOST_RE_ITERATOR_T_3
#endif
#endif

#ifdef BOOST_RE_ITERATOR_T_4
#ifndef BOOST_RE_OI_T_4
#define BOOST_RE_OI_T_4 BOOST_RE_ITERATOR_T_4
#endif
#ifndef BOOST_RE_II_T_4
#define BOOST_RE_II_T_4 BOOST_RE_ITERATOR_T_4
#endif
#ifndef BOOST_RE_FI_T_4
#define BOOST_RE_FI_T_4 BOOST_RE_ITERATOR_T_4
#endif
#ifndef BOOST_RE_BI_T_4
#define BOOST_RE_BI_T_4 BOOST_RE_ITERATOR_T_4
#endif
#ifndef BOOST_RE_RI_T_4
#define BOOST_RE_RI_T_4 BOOST_RE_ITERATOR_T_4
#endif
#endif

#ifdef BOOST_RE_OI_T_0
# define BOOST_RE_OUTPUT_ITERATOR(T, D) boost::re_detail::dummy_iterator_base<T>
#elif defined(BOOST_RE_OI_T_1)
# define BOOST_RE_OUTPUT_ITERATOR(T, D) std::iterator<std::output_iterator_tag, T, D, T*, T&>
#elif defined(BOOST_RE_OI_T_2)
# define BOOST_RE_OUTPUT_ITERATOR(T, D) std::iterator<std::output_iterator_tag, T, D>
#elif defined(BOOST_RE_OI_T_3)
# define BOOST_RE_OUTPUT_ITERATOR(T, D) std::output_iterator
#else
syntax error
#endif

#ifdef BOOST_RE_II_T_0
# define BOOST_RE_INPUT_ITERATOR(T, D) boost::re_detail::dummy_iterator_base<T>
#elif defined(BOOST_RE_II_T_1)
#define BOOST_RE_INPUT_ITERATOR(T, D) std::iterator<std::input_iterator_tag, T, D, T*, T&>
#elif defined(BOOST_RE_II_T_2)
#define BOOST_RE_INPUT_ITERATOR(T, D) std::iterator<std::input_iterator_tag, T, D>
#elif defined(BOOST_RE_II_T_3)
# define BOOST_RE_INPUT_ITERATOR(T, D) std::input_iterator<T, D>
#elif defined(BOOST_RE_II_T_4)
# define BOOST_RE_INPUT_ITERATOR(T, D) std::input_iterator<T>
#else
syntax error
#endif

#ifdef BOOST_RE_FI_T_0
# define BOOST_RE_FWD_ITERATOR(T, D) boost::re_detail::dummy_iterator_base<T>
#elif defined(BOOST_RE_FI_T_1)
# define BOOST_RE_FWD_ITERATOR(T, D) std::iterator<std::forward_iterator_tag, T, D, T*, T&>
#elif defined(BOOST_RE_FI_T_2)
# define BOOST_RE_FWD_ITERATOR(T, D) std::iterator<std::forward_iterator_tag, T, D>
#elif defined(BOOST_RE_FI_T_3)
# define BOOST_RE_FWD_ITERATOR(T, D) std::forward_iterator<T, D>
#else
syntax error
#endif

#ifdef BOOST_RE_BI_T_0
# define BOOST_RE_BIDI_ITERATOR(T, D) boost::re_detail::dummy_iterator_base<T>
#elif defined(BOOST_RE_BI_T_1)
# define BOOST_RE_BIDI_ITERATOR(T, D) std::iterator<std::bidirectional_iterator_tag, T, D, T*, T&>
#elif defined(BOOST_RE_BI_T_2)
# define BOOST_RE_BIDI_ITERATOR(T, D) std::iterator<std::bidirectional_iterator_tag, T, D>
#elif defined(BOOST_RE_BI_T_3)
# define BOOST_RE_BIDI_ITERATOR(T, D) std::bidirectional_iterator<T, D>
#else
syntax error
#endif

#ifdef BOOST_RE_RI_T_0
# define BOOST_RE_RA_ITERATOR(T, D) boost::re_detail::dummy_iterator_base<T>
#elif defined(BOOST_RE_RI_T_1)
# define BOOST_RE_RA_ITERATOR(T, D) std::iterator<std::random_access_iterator_tag, T, D, T*, T&>
#elif defined(BOOST_RE_RI_T_2)
# define BOOST_RE_RA_ITERATOR(T, D) std::iterator<std::random_access_iterator_tag, T, D>
#elif defined(BOOST_RE_RI_T_3)
# define BOOST_RE_RA_ITERATOR(T, D) std::random_access_iterator<T, D>
#else
syntax error
#endif


#ifndef BOOST_RE_NO_EXCEPTION_H
#include <exception>
#endif

#ifndef BOOST_RE_NO_ITERATOR_H
#include <iterator>
#ifdef BOOST_RE_USE_ALGO
#include <algo.h>
#else
#include <algorithm>
#endif
#endif

#if defined(BOOST_RE_NO_MEMORY_H) || defined(__GNUC__)
 #define BOOST_RE_OLD_ALLOCATORS
 #define REBIND_INSTANCE(x, y, inst) re_alloc_binder<x, y>(inst)
 #define REBIND_TYPE(x, y) re_alloc_binder<x, y>
 #define BOOST_RE_DEF_ALLOC_PARAM(x) BOOST_RE_DEFAULT_PARAM( boost::re_detail::jm_def_alloc )
 #define BOOST_RE_DEF_ALLOC(x) boost::re_detail::jm_def_alloc

 #define BOOST_RE_NEED_BINDER
 #define BOOST_RE_NEED_ALLOC
#else
#include <memory>
 #define REBIND_INSTANCE(x, y, inst) y::BOOST_RE_NESTED_TEMPLATE_DECL rebind<x>::other(inst)
 #define REBIND_TYPE(x, y) y::BOOST_RE_NESTED_TEMPLATE_DECL rebind<x>::other
 #define BOOST_RE_DEF_ALLOC_PARAM(x) BOOST_RE_TRICKY_DEFAULT_PARAM( std::allocator<x> )
 #define BOOST_RE_DEF_ALLOC(x) std::allocator<x>
#endif


#endif // BOOST_RE_AUTO_CONFIGURE


#endif /* BOOST_RE_OPT_H */











