DynamicBitset, part of collection of the [Boost C++ Libraries](http://github.com/boostorg), is similar to std::bitset however the size is specified at run-time instead of at compile-time.

### License

Distributed under the [Boost Software License, Version 1.0](http://www.boost.org/LICENSE_1_0.txt).

### Properties

* C++11
* Header-only

### Build Status

Branch          | GHA CI | Appveyor | Coverity Scan | codecov.io | Deps | Docs | Tests |
:-------------: | ------ | -------- | ------------- | ---------- | ---- | ---- | ----- |
[`master`](https://github.com/boostorg/dynamic_bitset/tree/master) | [![Build Status](https://github.com/boostorg/dynamic_bitset/actions/workflows/ci.yml/badge.svg?branch=master)](https://github.com/boostorg/dynamic_bitset/actions?query=branch:master) | [![Build status](https://ci.appveyor.com/api/projects/status/n7bki5ka3v918r5r?svg=true)](https://ci.appveyor.com/project/cppalliance/dynamic-bitset) | [![Coverity Scan Build Status](https://scan.coverity.com/projects/16167/badge.svg)](https://scan.coverity.com/projects/boostorg-dynamic_bitset) | [![codecov](https://codecov.io/gh/boostorg/dynamic_bitset/branch/master/graph/badge.svg)](https://codecov.io/gh/boostorg/dynamic_bitset/branch/master)| [![Deps](https://img.shields.io/badge/deps-master-brightgreen.svg)](https://pdimov.github.io/boostdep-report/master/dynamic_bitset.html) | [![Documentation](https://img.shields.io/badge/docs-master-brightgreen.svg)](https://www.boost.org/doc/libs/master/libs/dynamic_bitset/dynamic_bitset.html) | [![Enter the Matrix](https://img.shields.io/badge/matrix-master-brightgreen.svg)](http://www.boost.org/development/tests/master/developer/dynamic_bitset.html)
[`develop`](https://github.com/boostorg/dynamic_bitset/tree/develop) | [![Build Status](https://github.com/boostorg/dynamic_bitset/actions/workflows/ci.yml/badge.svg?branch=develop)](https://github.com/boostorg/dynamic_bitset/actions?query=branch:develop) | [![Build status](https://ci.appveyor.com/api/projects/status/n7bki5ka3v918r5r/branch/develop?svg=true)](https://ci.appveyor.com/project/cppalliance/dynamic-bitset/branch/develop) | [![Coverity Scan Build Status](https://scan.coverity.com/projects/16167/badge.svg)](https://scan.coverity.com/projects/boostorg-dynamic_bitset) | [![codecov](https://codecov.io/gh/boostorg/dynamic_bitset/branch/develop/graph/badge.svg)](https://codecov.io/gh/boostorg/dynamic_bitset/branch/develop) | [![Deps](https://img.shields.io/badge/deps-develop-brightgreen.svg)](https://pdimov.github.io/boostdep-report/develop/dynamic_bitset.html) | [![Documentation](https://img.shields.io/badge/docs-develop-brightgreen.svg)](https://www.boost.org/doc/libs/develop/libs/dynamic_bitset/dynamic_bitset.html) | [![Enter the Matrix](https://img.shields.io/badge/matrix-develop-brightgreen.svg)](http://www.boost.org/development/tests/develop/developer/dynamic_bitset.html)

### Directories

| Name        | Purpose                        |
| ----------- | ------------------------------ |
| `example`   | examples                       |
| `doc`       | documentation                  |
| `include`   | headers                        |
| `test`      | unit tests                     |

### More information

* [Ask questions](http://stackoverflow.com/questions/ask?tags=c%2B%2B,boost,boost-dynamic_bitset)
* [Report bugs](https://github.com/boostorg/dynamic_bitset/issues): Be sure to mention Boost version, platform and compiler you're using. A small compilable code sample to reproduce the problem is always good as well.
* Submit your patches as pull requests against **develop** branch. Note that by submitting patches you agree to license your modifications under the [Boost Software License, Version 1.0](http://www.boost.org/LICENSE_1_0.txt).
* Discussions about the library are held on the [Boost developers mailing list](http://www.boost.org/community/groups.html#main). Be sure to read the [discussion policy](http://www.boost.org/community/policy.html) before posting and add the `[dynamic_bitset]` tag at the beginning of the subject line.

