// Copyright John Maddock 2008.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)
#ifndef SC_
#define SC_(x) static_cast<typename table_type<T>::type>(BOOST_JOIN(x, L))
#endif
   static const boost::array<boost::array<typename table_type<T>::type, 5>, 209-7> nct = {{
      {{ SC_(0.563786208629608154296875), SC_(-0.50740754604339599609375), SC_(-0.0316227786242961883544921875), SC_(0.6862274577179818450132372470056769938949), SC_(0.3137725422820181549867627529943230061051) }},
      {{ SC_(0.956796348094940185546875), SC_(-0.947228372097015380859375), SC_(-0.079056940972805023193359375), SC_(0.8115615601997266002916301508229723403909), SC_(0.1884384398002733997083698491770276596091) }},
      {{ SC_(2.380512714385986328125), SC_(-2.378132343292236328125), SC_(-6.34435558319091796875), SC_(0.1181983559218041139443788725932712768639), SC_(0.8818016440781958860556211274067287231361) }},
      {{ SC_(2.70792388916015625), SC_(2.70792388916015625), SC_(6.96782016754150390625), SC_(0.8962869141158998144131448676176096050228), SC_(0.1037130858841001855868551323823903949772) }},
      {{ SC_(3.5548775196075439453125), SC_(3.555233001708984375), SC_(7.444825649261474609375), SC_(0.8868528863556108953156241536058758129831), SC_(0.1131471136443891046843758463941241870169) }},
      {{ SC_(6.36666584014892578125), SC_(-6.37303256988525390625), SC_(-10.0381336212158203125), SC_(0.1297164612941840729663335994423583046378), SC_(0.8702835387058159270336664005576416953622) }},
      {{ SC_(6.889312267303466796875), SC_(6.95820522308349609375), SC_(10.67599391937255859375), SC_(0.8692923253313482797187029403902244593628), SC_(0.1307076746686517202812970596097755406372) }},
      {{ SC_(7.14243221282958984375), SC_(-7.856675624847412109375), SC_(-11.8699207305908203125), SC_(0.1313759752665446453920643109581266741211), SC_(0.8686240247334553546079356890418733258789) }},
      {{ SC_(7.288346767425537109375), SC_(-8.74601650238037109375), SC_(-13.08834171295166015625), SC_(0.1317487167403902234213465542239538177641), SC_(0.8682512832596097765786534457760461822359) }},
      {{ SC_(9.2343730926513671875), SC_(-12.0046844482421875), SC_(-16.784832000732421875), SC_(0.1371773284108319849485042712205994589836), SC_(0.8628226715891680150514957287794005410164) }},
      {{ SC_(10.24338054656982421875), SC_(-15.365070343017578125), SC_(-20.9577732086181640625), SC_(0.1376443537392091127705735460070325295078), SC_(0.8623556462607908872294264539929674704922) }},
      // Accuracy for cdf was 1.622351158972134369182482692488613274872e-35 reverting to ibeta method
      {{ SC_(10.79011821746826171875), SC_(21.5802364349365234375), SC_(29.537731170654296875), SC_(0.8756990872254366689422087613232016840613), SC_(0.1243009127745633310577912386767983159387) }},
      // Accuracy for cdf was 4.160454383617042892649968592965892889131e-33 reverting to ibeta method
      {{ SC_(13.519168853759765625), SC_(40.557506561279296875), SC_(53.932964324951171875), SC_(0.8875082903101746924904055764230529369583), SC_(0.1124917096898253075095944235769470630417) }},
      // Accuracy for cdf was 1.604620391037388264598463685671917292006e-31 reverting to ibeta method
      {{ SC_(15.17095088958740234375), SC_(60.683803558349609375), SC_(80.29798126220703125), SC_(0.8999784514511157146615339407607497230611), SC_(0.1000215485488842853384660592392502769389) }},
      // Accuracy for complement cdf was 1.877283192112248869020882051946325886895e-31 reverting to ibeta method
      {{ SC_(19.42644500732421875), SC_(-97.13222503662109375), SC_(-127.0076446533203125), SC_(0.07762632640481949429728015088679192552401), SC_(0.922373673595180505702719849113208074476) }},
      {{ SC_(19.50817108154296875), SC_(-1.950817108154296875), SC_(-4.251358509063720703125), SC_(0.03051855543632768793517707982155241831073), SC_(0.9694814445636723120648229201784475816893) }},
      {{ SC_(21.9724407196044921875), SC_(5.493110179901123046875), SC_(9.84743499755859375), SC_(0.992986065543250281397900520551747563875), SC_(0.007013934456749718602099479448252436125022) }},
      {{ SC_(22.492992401123046875), SC_(-11.2464962005615234375), SC_(-20.0706157684326171875), SC_(0.001741152139887334291426335869016989927262), SC_(0.9982588478601126657085736641309830100727) }},
      // Accuracy for cdf was 1.377945317134861778664593003010615381153e-35 reverting to ibeta method
      {{ SC_(23.7996234893798828125), SC_(17.8497180938720703125), SC_(33.418292999267578125), SC_(0.9996211766573392792339813291721999010055), SC_(0.0003788233426607207660186708278000989945169) }},
      {{ SC_(25.036640167236328125), SC_(-22.5329761505126953125), SC_(-23.5968837738037109375), SC_(0.4134518081460681240313822521036373281691), SC_(0.5865481918539318759686177478963626718309) }},
      {{ SC_(25.1794147491455078125), SC_(24.92761993408203125), SC_(26.6859874725341796875), SC_(0.6429374782181830684645655350039514639861), SC_(0.3570625217818169315354344649960485360139) }},
      {{ SC_(25.3974514007568359375), SC_(25.3720550537109375), SC_(28.144287109375), SC_(0.7259483462797133090367177861426920725105), SC_(0.2740516537202866909632822138573079274895) }},
      {{ SC_(25.9813289642333984375), SC_(-25.9813289642333984375), SC_(-29.77846527099609375), SC_(0.2056285524153440036454579324861282902585), SC_(0.7943714475846559963545420675138717097415) }},
      {{ SC_(27.0954875946044921875), SC_(27.09819793701171875), SC_(31.5578861236572265625), SC_(0.828431929449262988498157070696003843914), SC_(0.171568070550737011501842929303996156086) }},
      {{ SC_(27.7249755859375), SC_(-27.7527027130126953125), SC_(-32.620880126953125), SC_(0.1533040128385550877036403158398526326095), SC_(0.8466959871614449122963596841601473673905) }},
      {{ SC_(28.377353668212890625), SC_(-28.6611270904541015625), SC_(-33.646392822265625), SC_(0.1517071461091471563002300276017556302873), SC_(0.8482928538908528436997699723982443697127) }},
      {{ SC_(29.8228816986083984375), SC_(-32.805171966552734375), SC_(-38.3089447021484375), SC_(0.1518216968394176742712403142990093487196), SC_(0.8481783031605823257287596857009906512804) }},
      {{ SC_(29.85888671875), SC_(-35.83066558837890625), SC_(-41.81766510009765625), SC_(0.1517913318103332394681789642601874730845), SC_(0.8482086681896667605318210357398125269155) }},
      {{ SC_(30.8877696990966796875), SC_(-40.1540985107421875), SC_(-46.704540252685546875), SC_(0.151820911717382118330639220492336736004), SC_(0.848179088282617881669360779507663263996) }},
      {{ SC_(31.522701263427734375), SC_(47.28404998779296875), SC_(54.9264984130859375), SC_(0.8498252445594378197691615470039570119257), SC_(0.1501747554405621802308384529960429880743) }},
      {{ SC_(31.6116008758544921875), SC_(63.223201751708984375), SC_(74.14052581787109375), SC_(0.8664876685568435851658590203027698501092), SC_(0.1335123314431564148341409796972301498908) }},
      {{ SC_(32.522430419921875), SC_(97.567291259765625), SC_(115.3452301025390625), SC_(0.8831031107955767113232711697542937898518), SC_(0.1168968892044232886767288302457062101482) }},
      {{ SC_(34.23741912841796875), SC_(136.949676513671875), SC_(162.8426971435546875), SC_(0.8979978036187864055320169695913375830185), SC_(0.1020021963812135944679830304086624169815) }},
      {{ SC_(34.7731170654296875), SC_(173.8655853271484375), SC_(210.820098876953125), SC_(0.9231547098404640045345676119885187046564), SC_(0.07684529015953599546543238801148129534355) }},
      {{ SC_(37.374603271484375), SC_(-3.7374603748321533203125), SC_(-6.06284999847412109375), SC_(0.02989407974199651137619128615323098044931), SC_(0.9701059202580034886238087138467690195507) }},
      {{ SC_(37.67647552490234375), SC_(9.4191188812255859375), SC_(14.2204608917236328125), SC_(0.9942432836401959725307634033893315517704), SC_(0.005756716359804027469236596610668448229627) }},
      {{ SC_(39.31912994384765625), SC_(-19.659564971923828125), SC_(-30.221057891845703125), SC_(0.001018579099877846617752492244992008361556), SC_(0.9989814209001221533822475077550079916384) }},
      {{ SC_(41.613689422607421875), SC_(-31.21026611328125), SC_(-50.417530059814453125), SC_(0.0001504952224329608441786737013794940554069), SC_(0.9998495047775670391558213262986205059446) }},
      {{ SC_(42.04189300537109375), SC_(-37.837703704833984375), SC_(-38.973720550537109375), SC_(0.4241964739668615107939485538821951273245), SC_(0.5758035260331384892060514461178048726755) }},
      {{ SC_(42.384944915771484375), SC_(41.96109771728515625), SC_(43.941558837890625), SC_(0.6324772961255670448387378401509919194938), SC_(0.3675227038744329551612621598490080805062) }},
      {{ SC_(43.4476470947265625), SC_(43.404201507568359375), SC_(46.65811920166015625), SC_(0.7171851424088798130212692227040859394821), SC_(0.2828148575911201869787307772959140605179) }},
      {{ SC_(44.20688629150390625), SC_(-44.20688629150390625), SC_(-48.7362060546875), SC_(0.2114948742992961572807034016738007587978), SC_(0.7885051257007038427192965983261992412022) }},
      {{ SC_(44.7624664306640625), SC_(44.76694488525390625), SC_(50.073467254638671875), SC_(0.8245850473011781305822593524388817446911), SC_(0.1754149526988218694177406475611182553089) }},
      {{ SC_(46.03128814697265625), SC_(-46.077320098876953125), SC_(-51.90364837646484375), SC_(0.1561987365681882768738847432273329720561), SC_(0.8438012634318117231261152567726670279439) }},
      {{ SC_(48.70507049560546875), SC_(-49.192119598388671875), SC_(-55.244049072265625), SC_(0.1545907695642567335795228865061980095925), SC_(0.8454092304357432664204771134938019904075) }},
      {{ SC_(50.216846466064453125), SC_(-55.23853302001953125), SC_(-61.89676666259765625), SC_(0.1544995294701398525596552628473387177431), SC_(0.8455004705298601474403447371526612822569) }},
      {{ SC_(50.856510162353515625), SC_(-61.027812957763671875), SC_(-68.31215667724609375), SC_(0.1545232378558417400408592895047673900682), SC_(0.8454767621441582599591407104952326099318) }},
      {{ SC_(51.019100189208984375), SC_(66.3248291015625), SC_(74.21913909912109375), SC_(0.8456541431034008370031368689430412936904), SC_(0.1543458568965991629968631310569587063096) }},
      {{ SC_(51.5017242431640625), SC_(77.25258636474609375), SC_(86.4451904296875), SC_(0.8474644525606726641165548052803633498981), SC_(0.1525355474393273358834451947196366501019) }},
      {{ SC_(55.205089569091796875), SC_(110.41017913818359375), SC_(123.955841064453125), SC_(0.8647754825744024885372806932758253507646), SC_(0.1352245174255975114627193067241746492354) }},
      {{ SC_(55.38466644287109375), SC_(-166.15399169921875), SC_(-188.0928497314453125), SC_(0.1176367155276893515668241466414954864808), SC_(0.8823632844723106484331758533585045135192) }},
      {{ SC_(55.699718475341796875), SC_(-222.7988739013671875), SC_(-254.2837982177734375), SC_(0.1019403002101509742082139198401058375579), SC_(0.8980596997898490257917860801598941624421) }},
      {{ SC_(57.167877197265625), SC_(285.839385986328125), SC_(331.14361572265625), SC_(0.9243557983861765858351445901197402396614), SC_(0.07564420161382341416485540988025976033856) }},
      {{ SC_(59.405956268310546875), SC_(-5.9405956268310546875), SC_(-8.3420429229736328125), SC_(0.02940324430636967427049432143992117341216), SC_(0.9705967556936303257295056785600788265878) }},
      {{ SC_(59.9664154052734375), SC_(14.991603851318359375), SC_(20.4055805206298828125), SC_(0.9951502301879146945725572007339419287614), SC_(0.004849769812085305427442799266058071238551) }},
      {{ SC_(60.3826904296875), SC_(-30.19134521484375), SC_(-42.621673583984375), SC_(0.0006766671899196952261749430708777551897478), SC_(0.9993233328100803047738250569291222448103) }},
      {{ SC_(61.63347625732421875), SC_(46.22510528564453125), SC_(68.86083984375), SC_(0.999921480846639591866272783169362504029), SC_(7.851915336040813372721683063749597101964e-05) }},
      {{ SC_(63.310153961181640625), SC_(56.979137420654296875), SC_(58.197040557861328125), SC_(0.5691117562119799871740176343388579182663), SC_(0.4308882437880200128259823656611420817337) }},
      {{ SC_(63.419963836669921875), SC_(-62.7857666015625), SC_(-64.99910736083984375), SC_(0.3738322953142596763505873683039233783243), SC_(0.6261677046857403236494126316960766216757) }},
      {{ SC_(66.48972320556640625), SC_(66.4232330322265625), SC_(70.19112396240234375), SC_(0.7119390284265793812685305565956948386364), SC_(0.2880609715734206187314694434043051613636) }},
      {{ SC_(67.42459869384765625), SC_(-67.42459869384765625), SC_(-72.7297515869140625), SC_(0.2148706954365362031394123362488999649409), SC_(0.7851293045634637968605876637511000350591) }},
      {{ SC_(68.07720947265625), SC_(-68.084014892578125), SC_(-74.32244873046875), SC_(0.1776439566292221945541793890548658391722), SC_(0.8223560433707778054458206109451341608278) }},
      {{ SC_(69.99681854248046875), SC_(-70.0668182373046875), SC_(-76.93597412109375), SC_(0.1577535764502030296887928772651871118171), SC_(0.8422464235497969703112071227348128881829) }},
      {{ SC_(70.33196258544921875), SC_(-71.0352783203125), SC_(-78.0343017578125), SC_(0.1558634226083869070482127670970449973749), SC_(0.8441365773916130929517872329029550026251) }},
      {{ SC_(70.55254364013671875), SC_(-77.6078033447265625), SC_(-85.2329864501953125), SC_(0.1556562126060282523263838362925862437733), SC_(0.8443437873939717476736161637074137562267) }},
      {{ SC_(71.26909637451171875), SC_(85.522918701171875), SC_(93.863372802734375), SC_(0.8443386617309688556005324345130120474997), SC_(0.1556613382690311443994675654869879525003) }},
      {{ SC_(72.2588653564453125), SC_(93.9365234375), SC_(103.01971435546875), SC_(0.844491406920337327662789045605334054664), SC_(0.155508593079662672337210954394665945336) }},
      {{ SC_(76.08922576904296875), SC_(114.1338348388671875), SC_(124.9094085693359375), SC_(0.8462455172091029135550405319225529771034), SC_(0.1537544827908970864449594680774470228966) }},
      {{ SC_(76.3117523193359375), SC_(152.623504638671875), SC_(168.1202545166015625), SC_(0.8642245358680997765157973865161523708951), SC_(0.1357754641319002234842026134838476291049) }},
      {{ SC_(77.4592437744140625), SC_(232.3777313232421875), SC_(257.64971923828125), SC_(0.8822460282057177670054617261080172681685), SC_(0.1177539717942822329945382738919827318315) }},
      {{ SC_(77.714019775390625), SC_(-310.8560791015625), SC_(-347.13818359375), SC_(0.1016627586995156636256699525275530770775), SC_(0.8983372413004843363743300474724469229225) }},
      {{ SC_(78.445465087890625), SC_(392.227325439453125), SC_(444.172149658203125), SC_(0.9251952554103925652189675447975151362173), SC_(0.0748047445896074347810324552024848637827) }},
      {{ SC_(78.46414947509765625), SC_(-7.846415042877197265625), SC_(-10.3206844329833984375), SC_(0.02908026560846077815486950206875373595512), SC_(0.9709197343915392218451304979312462640449) }},
      {{ SC_(78.9817047119140625), SC_(-19.745426177978515625), SC_(-25.6398372650146484375), SC_(0.00438383428342180536783922758878730206115), SC_(0.9956161657165781946321607724112126979388) }},
      {{ SC_(79.74776458740234375), SC_(-39.873882293701171875), SC_(-53.80655670166015625), SC_(0.0005228576912257536245328204786653287401733), SC_(0.9994771423087742463754671795213346712598) }},
      {{ SC_(80.84175872802734375), SC_(60.631317138671875), SC_(86.1278228759765625), SC_(0.9999494656184139932380947921912622194169), SC_(5.053438158600676190520780873778058313339e-05) }},
      {{ SC_(81.7462921142578125), SC_(73.57166290283203125), SC_(74.8529052734375), SC_(0.5655840801077873664237520358202778390053), SC_(0.4344159198922126335762479641797221609947) }},
      {{ SC_(82.53336334228515625), SC_(-81.70803070068359375), SC_(-84.10645294189453125), SC_(0.3772901925024934280799760328614783682602), SC_(0.6227098074975065719200239671385216317398) }},
      {{ SC_(84.3523101806640625), SC_(84.2679595947265625), SC_(88.38256072998046875), SC_(0.7095092141414201401595613557076085674612), SC_(0.2904907858585798598404386442923914325388) }},
      {{ SC_(84.41759490966796875), SC_(-84.41759490966796875), SC_(-90.21768951416015625), SC_(0.2163237673254140132965728518405243664117), SC_(0.7836762326745859867034271481594756335883) }},
      {{ SC_(84.63307952880859375), SC_(-84.64154052734375), SC_(-91.45754241943359375), SC_(0.1785481960614030672991952102246403868729), SC_(0.8214518039385969327008047897753596131271) }},
      {{ SC_(87.748931884765625), SC_(-87.8366851806640625), SC_(-95.3781280517578125), SC_(0.1583748894523595322365118318645909249134), SC_(0.8416251105476404677634881681354090750866) }},
      {{ SC_(89.1172943115234375), SC_(-90.0084686279296875), SC_(-97.72855377197265625), SC_(0.1564796419002191746060667690099037742646), SC_(0.8435203580997808253939332309900962257354) }},
      {{ SC_(91.2066192626953125), SC_(100.3272857666015625), SC_(108.81313323974609375), SC_(0.8436881491498766749138579299643346271245), SC_(0.1563118508501233250861420700356653728755) }},
      {{ SC_(91.5978851318359375), SC_(109.9174652099609375), SC_(119.18065643310546875), SC_(0.8436998684250685584554679000155809441252), SC_(0.1563001315749314415445320999844190558748) }},
      {{ SC_(93.87818145751953125), SC_(122.04163360595703125), SC_(132.1806793212890625), SC_(0.8438388267176051940156151919229634663964), SC_(0.1561611732823948059843848080770365336036) }},
      {{ SC_(94.6578216552734375), SC_(-141.986724853515625), SC_(-153.80615234375), SC_(0.1542575078724520656934634164864737570272), SC_(0.8457424921275479343065365835135262429728) }},
      {{ SC_(94.95178985595703125), SC_(-189.9035797119140625), SC_(-206.92413330078125), SC_(0.1360186009574374276611518252559314655877), SC_(0.8639813990425625723388481747440685344123) }},
      {{ SC_(97.0751800537109375), SC_(291.22552490234375), SC_(319.10357666015625), SC_(0.8822655381642828923075490778187253383656), SC_(0.1177344618357171076924509221812746616344) }},
      {{ SC_(97.51383209228515625), SC_(-390.055328369140625), SC_(-430.13201904296875), SC_(0.1014157604642255949734297362476750672209), SC_(0.8985842395357744050265702637523249327791) }},
      {{ SC_(97.9529266357421875), SC_(489.7646484375), SC_(547.08740234375), SC_(0.9257845109655273426610446674444422602715), SC_(0.0742154890344726573389553325555577397285) }},
      {{ SC_(98.11785888671875), SC_(-9.81178569793701171875), SC_(-12.3620128631591796875), SC_(0.02880258322680070072360530321279147954814), SC_(0.9711974167731992992763946967872085204519) }},
      {{ SC_(99.67285919189453125), SC_(24.9182147979736328125), SC_(31.296527862548828125), SC_(0.9959694490932389280305926013689480489171), SC_(0.004030550906761071969407398631051951082947) }},
      {{ SC_(100.7325897216796875), SC_(50.36629486083984375), SC_(65.76190185546875), SC_(0.9995760725264885593399305628081933864539), SC_(0.0004239274735114406600694371918066135461242) }},
      {{ SC_(101.19145965576171875), SC_(-75.89359283447265625), SC_(-104.10439300537109375), SC_(3.54024190807848363176773512852495399553e-05), SC_(0.99996459758091921516368232264871475046) }},
      {{ SC_(105.47434234619140625), SC_(94.92690277099609375), SC_(96.2816619873046875), SC_(0.5624910084759677073227339129906321568067), SC_(0.4375089915240322926772660870093678431933) }},
      {{ SC_(106.15955352783203125), SC_(-105.09796142578125), SC_(-107.70069122314453125), SC_(0.3801792420690054321577824583932170007409), SC_(0.6198207579309945678422175416067829992591) }},
      {{ SC_(109.3763427734375), SC_(-109.2669677734375), SC_(-113.81548309326171875), SC_(0.2927995498143171608585155353713416434627), SC_(0.7072004501856828391414844646286583565373) }},
      {{ SC_(109.443145751953125), SC_(-109.443145751953125), SC_(-115.89563751220703125), SC_(0.2177624693580852564433792136980025275263), SC_(0.7822375306419147435566207863019974724737) }},
      {{ SC_(109.44416046142578125), SC_(-109.455108642578125), SC_(-117.0474700927734375), SC_(0.1794332717267585034746088854338468831837), SC_(0.8205667282732414965253911145661531168163) }},
      {{ SC_(109.94477081298828125), SC_(-110.054718017578125), SC_(-118.3541717529296875), SC_(0.1588744738364745390285859042272772458576), SC_(0.8411255261635254609714140957727227541424) }},
      {{ SC_(112.3115386962890625), SC_(113.43465423583984375), SC_(121.9545135498046875), SC_(0.8430439030845827751147867946083673858892), SC_(0.1569560969154172248852132053916326141108) }},
      {{ SC_(113.56436920166015625), SC_(124.920806884765625), SC_(134.2415008544921875), SC_(0.8432361922916767972051117996988035319071), SC_(0.1567638077083232027948882003011964680929) }},
      {{ SC_(113.7647705078125), SC_(136.517730712890625), SC_(146.684326171875), SC_(0.8432636502679420499850627754284501945478), SC_(0.1567363497320579500149372245715498054522) }},
      {{ SC_(114.7509765625), SC_(149.17626953125), SC_(160.2314910888671875), SC_(0.8434395730286564834535058574522090382322), SC_(0.1565604269713435165464941425477909617678) }},
      {{ SC_(116.19138336181640625), SC_(174.287078857421875), SC_(187.203094482421875), SC_(0.8453612453543327105256773894190790913364), SC_(0.1546387546456672894743226105809209086636) }},
      {{ SC_(117.0528564453125), SC_(-234.105712890625), SC_(-252.7595062255859375), SC_(0.1361894404038173982628789126245928912158), SC_(0.8638105595961826017371210873754071087842) }},
      {{ SC_(117.0535888671875), SC_(351.1607666015625), SC_(381.44635009765625), SC_(0.8823142099011073148123321849803243946278), SC_(0.1176857900988926851876678150196756053722) }},
      {{ SC_(118.56481170654296875), SC_(-474.259246826171875), SC_(-517.987548828125), SC_(0.1011800541212895573156790456985475776735), SC_(0.8988199458787104426843209543014524223265) }},
      {{ SC_(118.9007568359375), SC_(-594.5037841796875), SC_(-657.0604248046875), SC_(0.07371169147327842617679797459789743563627), SC_(0.9262883085267215738232020254021025643637) }},
      {{ SC_(123.20897674560546875), SC_(-12.3208980560302734375), SC_(-14.9669208526611328125), SC_(0.02850291698157446967958375316774236074953), SC_(0.9714970830184255303204162468322576392505) }},
      {{ SC_(126.471893310546875), SC_(31.61797332763671875), SC_(38.57413482666015625), SC_(0.9962946030639488349324523906456210771521), SC_(0.00370539693605116506754760935437892284785) }},
      {{ SC_(127.95270538330078125), SC_(63.976352691650390625), SC_(81.082427978515625), SC_(0.9996552702110278615720509818794660321576), SC_(0.0003447297889721384279490181205339678423975) }},
      {{ SC_(128.7922210693359375), SC_(-96.5941619873046875), SC_(-128.1116180419921875), SC_(2.443897930623329769288635209840173004311e-05), SC_(0.99997556102069376670230711364790159827) }},
      {{ SC_(129.26263427734375), SC_(116.33636474609375), SC_(117.75792694091796875), SC_(0.5602919656795008147639767650043945121865), SC_(0.4397080343204991852360232349956054878135) }},
      {{ SC_(131.0196380615234375), SC_(-129.709442138671875), SC_(-132.5057220458984375), SC_(0.3823227560515488195983633797288191267849), SC_(0.6176772439484511804016366202711808732151) }},
      {{ SC_(131.095611572265625), SC_(-130.9645233154296875), SC_(-135.8533172607421875), SC_(0.2942282537327334016814883447113353928694), SC_(0.7057717462672665983185116552886646071306) }},
      {{ SC_(131.148162841796875), SC_(-131.148162841796875), SC_(-138.1118621826171875), SC_(0.2186336299667598508641889146758497605093), SC_(0.7813663700332401491358110853241502394907) }},
      {{ SC_(132.72113037109375), SC_(-132.734405517578125), SC_(-140.9829559326171875), SC_(0.1799965504502371263600372896806522959373), SC_(0.8200034495497628736399627103193477040627) }},
      {{ SC_(135.7470550537109375), SC_(135.8828125), SC_(144.9780426025390625), SC_(0.8407435933512650444605322470236845500409), SC_(0.1592564066487349555394677529763154499591) }},
      {{ SC_(135.9405670166015625), SC_(137.2999725341796875), SC_(146.5579833984375), SC_(0.8427170281446764917815478985727530783284), SC_(0.1572829718553235082184521014272469216716) }},
      {{ SC_(135.9639892578125), SC_(149.560394287109375), SC_(159.643341064453125), SC_(0.8429404231403844461019276218089783926536), SC_(0.1570595768596155538980723781910216073464) }},
      {{ SC_(136.271942138671875), SC_(-163.526336669921875), SC_(-174.5281524658203125), SC_(0.1570438925127796583229779061585298280266), SC_(0.8429561074872203416770220938414701719734) }},
      {{ SC_(138.96575927734375), SC_(-180.655487060546875), SC_(-192.679595947265625), SC_(0.1568729479539667719055022405323108530903), SC_(0.8431270520460332280944977594676891469097) }},
      {{ SC_(139.046600341796875), SC_(208.5699005126953125), SC_(222.5485992431640625), SC_(0.845086369154810191072926652237857351912), SC_(0.154913630845189808927073347762142648088) }},
      {{ SC_(139.81536865234375), SC_(-279.6307373046875), SC_(-299.81915283203125), SC_(0.1362894033659300275403466231025798172725), SC_(0.8637105966340699724596533768974201827275) }},
      {{ SC_(141.154876708984375), SC_(423.464630126953125), SC_(456.40594482421875), SC_(0.8823911704414834681763667937283519019012), SC_(0.1176088295585165318236332062716480980988) }},
      {{ SC_(141.2092437744140625), SC_(-564.83697509765625), SC_(-612.16058349609375), SC_(0.1009591131349694784465979694591174275998), SC_(0.8990408868650305215534020305408825724002) }},
      {{ SC_(141.8730010986328125), SC_(709.364990234375), SC_(777.17333984375), SC_(0.9267321517377437964086387319256785323586), SC_(0.07326784826225620359136126807432146764138) }},
      {{ SC_(142.1407928466796875), SC_(14.21407985687255859375), SC_(16.9308986663818359375), SC_(0.9716930124445638242695229486641864482654), SC_(0.02830698755543617573047705133581355173461) }},
      {{ SC_(145.167816162109375), SC_(-36.29195404052734375), SC_(-43.624359130859375), SC_(0.00353360260058181133615805349145576951833), SC_(0.9964663973994181886638419465085442304817) }},
      {{ SC_(145.390960693359375), SC_(72.6954803466796875), SC_(90.81201171875), SC_(0.9996902434511801120819127684695177885632), SC_(0.000309756548819887918087231530482211436825) }},
      {{ SC_(146.5597686767578125), SC_(-109.919830322265625), SC_(-143.3915863037109375), SC_(2.015420573828870128639231110699342930239e-05), SC_(0.9999798457942617112987136076888930065707) }},
      {{ SC_(148.1294708251953125), SC_(-133.3165130615234375), SC_(-134.787200927734375), SC_(0.4410606059603438079036891188066765050315), SC_(0.5589393940396561920963108811933234949685) }},
      {{ SC_(148.62652587890625), SC_(-147.1402587890625), SC_(-150.06341552734375), SC_(0.3834994019665212445998163679193241461748), SC_(0.6165005980334787554001836320806758538252) }},
      {{ SC_(150.2534332275390625), SC_(-150.103179931640625), SC_(-155.2705535888671875), SC_(0.2952168772407109658835173884363384891592), SC_(0.7047831227592890341164826115636615108408) }},
      {{ SC_(150.745849609375), SC_(-150.745849609375), SC_(-158.137420654296875), SC_(0.2192478107902515304017154908910307097216), SC_(0.7807521892097484695982845091089692902784) }},
      {{ SC_(150.9373626708984375), SC_(150.95245361328125), SC_(159.67718505859375), SC_(0.819669819613424623253995508855550429065), SC_(0.180330180386575376746004491144449570935) }},
      {{ SC_(151.4400787353515625), SC_(151.591522216796875), SC_(161.1355438232421875), SC_(0.8405662241802794202951485500906860959921), SC_(0.1594337758197205797048514499093139040079) }},
      {{ SC_(151.5480499267578125), SC_(153.0635223388671875), SC_(162.776092529296875), SC_(0.8425584011040393402323486388209564080443), SC_(0.1574415988959606597676513611790435919557) }},
      {{ SC_(152.3462677001953125), SC_(167.580902099609375), SC_(178.183807373046875), SC_(0.8427739889132064854846702655678356113818), SC_(0.1572260110867935145153297344321643886182) }},
      {{ SC_(152.750030517578125), SC_(183.300048828125), SC_(194.872344970703125), SC_(0.8427900695522180606061518344038782676814), SC_(0.1572099304477819393938481655961217323186) }},
      {{ SC_(153.1033935546875), SC_(-199.0344085693359375), SC_(-211.586517333984375), SC_(0.1570189149304337531280252058554779217245), SC_(0.8429810850695662468719747941445220782755) }},
      {{ SC_(154.783447265625), SC_(232.1751708984375), SC_(246.83734130859375), SC_(0.844943192403567570763396052955244103971), SC_(0.155056807596432429236603947044755896029) }},
      {{ SC_(155.7795562744140625), SC_(-311.559112548828125), SC_(-332.752960205078125), SC_(0.1363342795901147695317231770561292128059), SC_(0.8636657204098852304682768229438707871941) }},
      {{ SC_(155.833465576171875), SC_(-467.500396728515625), SC_(-501.952667236328125), SC_(0.1175588979195506251296008572818974407098), SC_(0.8824411020804493748703991427181025592902) }},
      {{ SC_(158.4414825439453125), SC_(-633.76593017578125), SC_(-683.641845703125), SC_(0.1008111913635493983543118803699900448204), SC_(0.8991888086364506016456881196300099551796) }},
      {{ SC_(158.71954345703125), SC_(793.59771728515625), SC_(865.0010986328125), SC_(0.9270098267220069738822683626929044682978), SC_(0.07299017327799302611773163730709553170218) }},
      {{ SC_(158.795013427734375), SC_(15.8795013427734375), SC_(18.657436370849609375), SC_(0.9718495582868837841860142886278865994715), SC_(0.02815044171311621581398571137211340052848) }},
      {{ SC_(159.040008544921875), SC_(-39.76000213623046875), SC_(-47.359218597412109375), SC_(0.003427104943685960646316800866785870680051), SC_(0.9965728950563140393536831991332141293199) }},
      {{ SC_(159.45599365234375), SC_(79.727996826171875), SC_(98.6189117431640625), SC_(0.9997126698554915937834976664241599247614), SC_(0.000287330144508406216502333575840075238607) }},
      {{ SC_(159.5857391357421875), SC_(-119.689300537109375), SC_(-154.522125244140625), SC_(1.780296360028319980495500895766825275644e-05), SC_(0.9999821970363997168001950449910423317472) }},
      {{ SC_(159.621185302734375), SC_(-143.6590576171875), SC_(-145.15826416015625), SC_(0.4417643071241765182473614578442729999156), SC_(0.5582356928758234817526385421557270000844) }},
      {{ SC_(160.0561065673828125), SC_(-158.4555511474609375), SC_(-161.4573516845703125), SC_(0.3841539866041050632940487868711941827449), SC_(0.6158460133958949367059512131288058172551) }},
      {{ SC_(161.5062255859375), SC_(-161.3447265625), SC_(-166.6679534912109375), SC_(0.2957088865758827952297766445373411369744), SC_(0.7042911134241172047702233554626588630256) }},
      {{ SC_(161.6351165771484375), SC_(161.6351165771484375), SC_(169.253082275390625), SC_(0.780466816408296829937722882469998068765), SC_(0.219533183591703170062277117530001931235) }},
      {{ SC_(161.946929931640625), SC_(161.963134765625), SC_(170.9622802734375), SC_(0.8194965436733574620900731290907810363677), SC_(0.1805034563266425379099268709092189636323) }},
      {{ SC_(162.8569793701171875), SC_(163.01983642578125), SC_(172.8768768310546875), SC_(0.8404660764783773469174485040522021093442), SC_(0.1595339235216226530825514959477978906558) }},
      {{ SC_(162.9447479248046875), SC_(-164.574188232421875), SC_(-174.604522705078125), SC_(0.1575424483959909318404851228183550185556), SC_(0.8424575516040090681595148771816449814444) }},
      {{ SC_(164.1681671142578125), SC_(-180.584991455078125), SC_(-191.5462799072265625), SC_(0.1573335944854494629142736979246659337814), SC_(0.8426664055145505370857263020753340662186) }},
      {{ SC_(164.24920654296875), SC_(197.09906005859375), SC_(209.0523681640625), SC_(0.8426987091196232350996963931516288297837), SC_(0.1573012908803767649003036068483711702163) }},
      {{ SC_(164.38067626953125), SC_(-213.6948699951171875), SC_(-226.6521148681640625), SC_(0.1571073429860085281224507682808356620294), SC_(0.8428926570139914718775492317191643379706) }},
      {{ SC_(164.69158935546875), SC_(247.037384033203125), SC_(262.112762451171875), SC_(0.844866809969159062758885560659956913554), SC_(0.155133190030840937241114439340043086446) }},
      {{ SC_(166.165740966796875), SC_(-332.33148193359375), SC_(-354.15301513671875), SC_(0.1363546046209669111927130706242072700954), SC_(0.8636453953790330888072869293757927299046) }},
      {{ SC_(167.0017242431640625), SC_(501.00518798828125), SC_(536.56072998046875), SC_(0.8824746044843330736469612185701136118524), SC_(0.1175253955156669263530387814298863881476) }},
      {{ SC_(168.143463134765625), SC_(672.5738525390625), SC_(723.82763671875), SC_(0.8992656987013872665209365356081730016699), SC_(0.1007343012986127334790634643918269983301) }},
      {{ SC_(169.693572998046875), SC_(-848.4678955078125), SC_(-922.11358642578125), SC_(0.0728293297021927102394514390438756567735), SC_(0.9271706702978072897605485609561243432265) }},
      {{ SC_(169.8258819580078125), SC_(16.9825878143310546875), SC_(19.8004093170166015625), SC_(0.9719470387146119542829851768946449119598), SC_(0.02805296128538804571701482310535508804017) }},
      {{ SC_(174.48577880859375), SC_(-43.6214447021484375), SC_(-51.507320404052734375), SC_(0.003322995169190575236751479836974775618462), SC_(0.9966770048308094247632485201630252243815) }},
      {{ SC_(175.35150146484375), SC_(-87.675750732421875), SC_(-107.40569305419921875), SC_(0.0002662223893738321424320630318453652402469), SC_(0.9997337776106261678575679369681546347598) }},
      {{ SC_(175.6861419677734375), SC_(-131.7646026611328125), SC_(-168.2105255126953125), SC_(1.5502329987353507546507657205810707821e-05), SC_(0.9999844976700126464924534923427941892922) }},
      {{ SC_(178.1806640625), SC_(-160.3625946044921875), SC_(-161.905975341796875), SC_(0.4427510840848753942205017300207371637469), SC_(0.5572489159151246057794982699792628362531) }},
      {{ SC_(181.1584014892578125), SC_(-179.3468170166015625), SC_(-182.4870758056640625), SC_(0.3851955828443047286965619499537351163898), SC_(0.6148044171556952713034380500462648836102) }},
      {{ SC_(181.47296142578125), SC_(181.2914886474609375), SC_(186.8789825439453125), SC_(0.7035362100484691927399429102560977978734), SC_(0.2964637899515308072600570897439022021266) }},
      {{ SC_(182.6751861572265625), SC_(182.6751861572265625), SC_(190.7105255126953125), SC_(0.7799873196049647286222313130314984070929), SC_(0.2200126803950352713777686869685015929071) }},
      {{ SC_(183.1471099853515625), SC_(183.1654205322265625), SC_(192.6689605712890625), SC_(0.8192163967452918136616703813674191971081), SC_(0.1807836032547081863383296186325808028919) }},
      {{ SC_(183.4387359619140625), SC_(183.6221771240234375), SC_(194.0174407958984375), SC_(0.8403035276172555322739380106234387661243), SC_(0.1596964723827444677260619893765612338757) }},
      {{ SC_(184.174957275390625), SC_(186.0167083740234375), SC_(196.611968994140625), SC_(0.8423069271382795700398439101444273937711), SC_(0.1576930728617204299601560898555726062289) }},
      {{ SC_(185.8527374267578125), SC_(-204.438018798828125), SC_(-216.026580810546875), SC_(0.1574804038174927854751974225084637112666), SC_(0.8425195961825072145248025774915362887334) }},
      {{ SC_(186.79864501953125), SC_(224.15838623046875), SC_(236.822540283203125), SC_(0.8425392206438456186820694371845737047599), SC_(0.1574607793561543813179305628154262952401) }},
      {{ SC_(186.8021392822265625), SC_(-242.8427734375), SC_(-256.5665283203125), SC_(0.157268032660067217707007392554301053214), SC_(0.842731967339932782292992607445698946786) }},
      {{ SC_(188.0148162841796875), SC_(-282.022216796875), SC_(-298.02532958984375), SC_(0.1552789395983287090937623733357006268049), SC_(0.8447210604016712909062376266642993731951) }},
      {{ SC_(190.0444183349609375), SC_(-380.088836669921875), SC_(-403.2850341796875), SC_(0.1363857890620788955477380353547122412928), SC_(0.8636142109379211044522619646452877587072) }},
      {{ SC_(191.0035247802734375), SC_(573.01055908203125), SC_(610.82342529296875), SC_(0.8825546776651612915449270809923133302827), SC_(0.1174453223348387084550729190076866697173) }},
      {{ SC_(191.4333953857421875), SC_(765.73358154296875), SC_(820.14422607421875), SC_(0.8994307655353378788627687172889911875494), SC_(0.1005692344646621211372312827110088124506) }},
      {{ SC_(191.501373291015625), SC_(-957.5068359375), SC_(-1035.4078369140625), SC_(0.07254550295882910100884475499526303225815), SC_(0.9274544970411708989911552450047369677418) }},
      {{ SC_(191.8582763671875), SC_(19.1858272552490234375), SC_(22.081790924072265625), SC_(0.9721242618485546393356290361951045322104), SC_(0.02787573815144536066437096380489546778959) }},
      {{ SC_(191.89849853515625), SC_(-47.9746246337890625), SC_(-56.171573638916015625), SC_(0.003221111566392305522573892879121826455479), SC_(0.9967788884336076944774261071208781735445) }},
      {{ SC_(191.9488067626953125), SC_(-95.97440338134765625), SC_(-116.54215240478515625), SC_(0.0002481260732563524200219933878692461610213), SC_(0.999751873926743647579978006612130753839) }},
      {{ SC_(192.9777069091796875), SC_(-144.7332763671875), SC_(-182.8341522216796875), SC_(1.358098637444654191572655104301270829943e-05), SC_(0.9999864190136255534580842734489569872917) }},
      {{ SC_(192.9932708740234375), SC_(-173.693939208984375), SC_(-175.2710113525390625), SC_(0.4434359641618019366789276090072593648763), SC_(0.5565640358381980633210723909927406351237) }},
      {{ SC_(193.5389862060546875), SC_(191.6035919189453125), SC_(194.821441650390625), SC_(0.6142723104748303441684413193877427660393), SC_(0.3857276895251696558315586806122572339607) }},
      {{ SC_(193.7735595703125), SC_(193.5797882080078125), SC_(199.3231201171875), SC_(0.7031303801855181023960454440247304541731), SC_(0.2968696198144818976039545559752695458269) }},
      {{ SC_(194.118560791015625), SC_(194.118560791015625), SC_(202.37158203125), SC_(0.7797728872340829673174837038355921015185), SC_(0.2202271127659170326825162961644078984815) }},
      {{ SC_(196.2219390869140625), SC_(-196.2415618896484375), SC_(-206.04248046875), SC_(0.1809237828594511737114522040101156011652), SC_(0.8190762171405488262885477959898843988348) }},
      {{ SC_(197.4919281005859375), SC_(-197.689422607421875), SC_(-208.4357757568359375), SC_(0.1597848828006174813168828984223774741925), SC_(0.8402151171993825186831171015776225258075) }},
      {{ SC_(197.704315185546875), SC_(199.6813507080078125), SC_(210.62042236328125), SC_(0.8422293832834955684228336504298493504347), SC_(0.1577706167165044315771663495701506495653) }},
      {{ SC_(198.576263427734375), SC_(-218.43389892578125), SC_(-230.3740386962890625), SC_(0.1575531385245673058508978138666145574355), SC_(0.8424468614754326941491021861333854425645) }},
      {{ SC_(198.8137054443359375), SC_(238.5764617919921875), SC_(251.6024322509765625), SC_(0.8424688825000982079679215138264048043475), SC_(0.1575311174999017920320784861735951956525) }},
      {{ SC_(199.292266845703125), SC_(-259.079925537109375), SC_(-273.21160888671875), SC_(0.1573382255153084153679636715700757369509), SC_(0.8426617744846915846320363284299242630491) }},
      {{ SC_(232.284637451171875), SC_(348.42694091796875), SC_(366.048248291015625), SC_(0.8445224219835303698101085035756072755625), SC_(0.1554775780164696301898914964243927244375) }},
      {{ SC_(290.68212890625), SC_(581.3642578125), SC_(609.58770751953125), SC_(0.8635682877769042305180745412047783757853), SC_(0.1364317122230957694819254587952216242147) }},
/*
      //
      // These last few values are commented out, the complexity of the implementation
      // depends upon the square of the non-centrality parameter, so these both take
      // a long time to evaluate and are rather hard to evaluate accurately also.
      //
      {{ SC_(9.757655029296875000000000000000000000000e2), SC_(-2.927296386718750000000000000000000000000e3), SC_(-3.009226074218750000000000000000000000000e3), SC_(1.164317566424995639445047413284130115370e-1), SC_(8.835682433575004360554952586715869884630e-1) }}, 
      {{ SC_(1.879048828125000000000000000000000000000e3), SC_(7.516195312500000000000000000000000000000e3), SC_(7.678772949218750000000000000000000000000e3), SC_(9.017566036730798342611358387622429767684e-1), SC_(9.824339632692016573886416123775702323164e-2) }}, 
      {{ SC_(2.308069091796875000000000000000000000000e3), SC_(-1.154034570312500000000000000000000000000e4), SC_(-1.179905078125000000000000000000000000000e4), SC_(6.872608129209766834994044970484572985093e-2), SC_(9.312739187079023316500595502951542701491e-1) }}, 
      {{ SC_(8.064482421875000000000000000000000000000e3), SC_(-8.064482421875000000000000000000000000000e2), SC_(-8.193711547851562500000000000000000000000e2), SC_(2.389575887949156628152767472787355181112e-2), SC_(9.761042411205084337184723252721264481889e-1) }}, 
      {{ SC_(1.567437500000000000000000000000000000000e4), SC_(-3.918593750000000000000000000000000000000e3), SC_(-3.985162353515625000000000000000000000000e3), SC_(1.542392032294953892149510464673239432939e-3), SC_(9.984576079677050461078504895353267605671e-1) }}, 
      {{ SC_(2.000542187500000000000000000000000000000e4), SC_(-1.000271093750000000000000000000000000000e4), SC_(-1.020245312500000000000000000000000000000e4), SC_(4.337531004895530778641649516506912837255e-5), SC_(9.999566246899510446922135835048349308716e-1) }}, 
      {{ SC_(5.348914843750000000000000000000000000000e4), SC_(-4.011685937500000000000000000000000000000e4), SC_(-4.073089843750000000000000000000000000000e4), SC_(3.883382003866549840825255916580316551597e-7), SC_(9.999996116617996133450159174744083419683e-1) }}
      */
   }};
//#undef SC_

