//  (C) Copyright John Maddock 2006.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)


static const boost::array<boost::array<typename table_type<T>::type, 4>, 500> ibeta_derivative_data = { {
{{ SC_(1.1510574072599411010742187500000000000000e-01), SC_(2.7266698837280273437500000000000000000000e+01), SC_(9.1334599256515502929687500000000000000000e-01), SC_(2.4207408975542468276471409063557340041241e-29) }},
{{ SC_(4.6342256665229797363281250000000000000000e-01), SC_(3.4317314624786376953125000000000000000000e+00), SC_(2.4176712334156036376953125000000000000000e-01), SC_(9.7664819482450522256458342803161978618775e-01) }},
{{ SC_(6.7153173685073852539062500000000000000000e-01), SC_(2.3063192367553710937500000000000000000000e+01), SC_(9.0844279527664184570312500000000000000000e-01), SC_(7.7554246601041672683444057212131973997266e-23) }},
{{ SC_(1.1902070045471191406250000000000000000000e+00), SC_(7.2695472717285156250000000000000000000000e+01), SC_(1.9963125884532928466796875000000000000000e-01), SC_(1.5321906748924114891745060032886406946431e-05) }},
{{ SC_(1.5403441190719604492187500000000000000000e+00), SC_(4.0498138427734375000000000000000000000000e+01), SC_(3.4629878401756286621093750000000000000000e-01), SC_(9.7923759539017191739927492689320033465430e-06) }},
{{ SC_(1.5487123727798461914062500000000000000000e+00), SC_(8.1611701965332031250000000000000000000000e+01), SC_(6.7876726388931274414062500000000000000000e-01), SC_(1.4648121492813252292768373177014159640882e-37) }},
{{ SC_(2.2512593269348144531250000000000000000000e+00), SC_(4.8983201980590820312500000000000000000000e+00), SC_(7.9967319965362548828125000000000000000000e-01), SC_(5.8540689042279303280934853157536449193018e-02) }},
{{ SC_(2.8674151897430419921875000000000000000000e+00), SC_(5.9605796813964843750000000000000000000000e+01), SC_(5.7525110244750976562500000000000000000000e-01), SC_(4.1520494356899987293263524909301504576644e-18) }},
{{ SC_(2.9220280647277832031250000000000000000000e+00), SC_(2.6592067718505859375000000000000000000000e+01), SC_(4.7334149479866027832031250000000000000000e-01), SC_(1.5360804982518247618055790218134454683015e-04) }},
{{ SC_(3.0540943145751953125000000000000000000000e+00), SC_(4.2397834777832031250000000000000000000000e+01), SC_(5.4692679643630981445312500000000000000000e-01), SC_(8.0612663701892327894335289230344080268832e-11) }},
{{ SC_(3.1832842826843261718750000000000000000000e+00), SC_(3.1655042648315429687500000000000000000000e+01), SC_(7.7649272978305816650390625000000000000000e-02), SC_(8.8341058727651780743888393582017562906730e+00) }},
{{ SC_(3.2600824832916259765625000000000000000000e+00), SC_(6.2543244361877441406250000000000000000000e+00), SC_(7.4315816164016723632812500000000000000000e-01), SC_(1.0379733790217871357173865887253816637006e-01) }},
{{ SC_(3.3603835105895996093750000000000000000000e+00), SC_(5.2892066955566406250000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.4471713407452094696775820779224978323052e-33) }},
{{ SC_(3.4446079730987548828125000000000000000000e+00), SC_(6.6360549926757812500000000000000000000000e+01), SC_(9.6544884145259857177734375000000000000000e-02), SC_(2.7781298937691931090821146699278519297691e+00) }},
{{ SC_(3.5711679458618164062500000000000000000000e+00), SC_(3.6129398345947265625000000000000000000000e+01), SC_(4.6266771852970123291015625000000000000000e-02), SC_(8.0630029089023351756097144189618087805396e+00) }},
{{ SC_(3.5762732028961181640625000000000000000000e+00), SC_(8.0645103454589843750000000000000000000000e+01), SC_(9.2886126041412353515625000000000000000000e-01), SC_(5.9940422450869549098960555214416305547326e-86) }},
{{ SC_(3.7738864421844482421875000000000000000000e+00), SC_(8.8396858215332031250000000000000000000000e+01), SC_(5.0323975086212158203125000000000000000000e-01), SC_(2.1377651869822463634780753524564708635893e-21) }},
{{ SC_(4.2431135177612304687500000000000000000000e+00), SC_(8.7180511474609375000000000000000000000000e+01), SC_(5.9454411268234252929687500000000000000000e-01), SC_(6.8062834654037274734122915634980312931827e-28) }},
{{ SC_(4.3023800849914550781250000000000000000000e+00), SC_(9.0843360900878906250000000000000000000000e+01), SC_(3.5004875063896179199218750000000000000000e-01), SC_(1.5608126308518008133492289115131279859932e-11) }},
{{ SC_(4.6171388626098632812500000000000000000000e+00), SC_(1.4911397933959960937500000000000000000000e+01), SC_(8.1217654049396514892578125000000000000000e-02), SC_(1.1194404395979094886693390163859136406908e+00) }},
{{ SC_(4.9654426574707031250000000000000000000000e+00), SC_(8.2345542907714843750000000000000000000000e+01), SC_(3.0131623148918151855468750000000000000000e-01), SC_(2.9673202581029389290761763702686503576267e-07) }},
{{ SC_(5.2676992416381835937500000000000000000000e+00), SC_(9.4657722473144531250000000000000000000000e+01), SC_(6.9526332616806030273437500000000000000000e-01), SC_(7.8295573513376509498686599296931122513815e-41) }},
{{ SC_(5.3950119018554687500000000000000000000000e+00), SC_(3.5276241302490234375000000000000000000000e+01), SC_(1.8489784002304077148437500000000000000000e-01), SC_(3.7781645456892386738803801132041850052157e+00) }},
{{ SC_(5.9618859291076660156250000000000000000000e+00), SC_(9.5247200012207031250000000000000000000000e+01), SC_(5.8708602190017700195312500000000000000000e-01), SC_(2.8909997138823406017647215950584284274946e-28) }},
{{ SC_(5.9779543876647949218750000000000000000000e+00), SC_(4.3524570465087890625000000000000000000000e+01), SC_(3.4045168757438659667968750000000000000000e-01), SC_(7.2467962642427209493327424376129419910391e-03) }},
{{ SC_(6.0471181869506835937500000000000000000000e+00), SC_(2.7766407012939453125000000000000000000000e+01), SC_(6.5411365032196044921875000000000000000000e-01), SC_(3.6952018127816630664368058046263404187981e-07) }},
{{ SC_(6.7992763519287109375000000000000000000000e+00), SC_(9.0447486877441406250000000000000000000000e+01), SC_(8.8773733377456665039062500000000000000000e-01), SC_(2.7875020546746494594346164754545861934449e-75) }},
{{ SC_(6.8806104660034179687500000000000000000000e+00), SC_(2.9616764068603515625000000000000000000000e+01), SC_(8.1578749418258666992187500000000000000000e-01), SC_(1.2519441814941828724197920489286372161610e-14) }},
{{ SC_(7.1445455551147460937500000000000000000000e+00), SC_(9.3460266113281250000000000000000000000000e+01), SC_(5.9493660926818847656250000000000000000000e-01), SC_(3.3806876322733292327628646174748719062289e-27) }},
{{ SC_(7.5854291915893554687500000000000000000000e+00), SC_(4.0420852661132812500000000000000000000000e+01), SC_(1.8398940563201904296875000000000000000000e-01), SC_(5.9352775227542433026391305724764114725504e+00) }},
{{ SC_(7.5966687202453613281250000000000000000000e+00), SC_(7.6242134094238281250000000000000000000000e+01), SC_(2.8591042757034301757812500000000000000000e-01), SC_(3.1025894314359612153177644554585512270890e-04) }},
{{ SC_(7.8175530433654785156250000000000000000000e+00), SC_(8.5445098876953125000000000000000000000000e+01), SC_(2.3957851529121398925781250000000000000000e-01), SC_(2.5947254244338476680603761727344934747223e-03) }},
{{ SC_(8.1125764846801757812500000000000000000000e+00), SC_(3.7941886901855468750000000000000000000000e+01), SC_(3.7948089838027954101562500000000000000000e-01), SC_(4.6821088167936976010051494286864725775883e-02) }},
{{ SC_(8.3469820022583007812500000000000000000000e+00), SC_(9.0694412231445312500000000000000000000000e+01), SC_(6.4435368776321411132812500000000000000000e-01), SC_(6.3030072588196834030170112173608791329327e-30) }},
{{ SC_(8.3821382522583007812500000000000000000000e+00), SC_(9.1257751464843750000000000000000000000000e+01), SC_(2.2599919140338897705078125000000000000000e-01), SC_(5.2881469602643104844542650964221707463689e-03) }},
{{ SC_(8.4435853958129882812500000000000000000000e+00), SC_(3.4623340606689453125000000000000000000000e+01), SC_(2.5115874409675598144531250000000000000000e-01), SC_(3.7894245667769801680359258792926483054189e+00) }},
{{ SC_(8.5515785217285156250000000000000000000000e+00), SC_(9.9353477478027343750000000000000000000000e+01), SC_(4.7097623348236083984375000000000000000000e-01), SC_(2.2705544683357531139851779880974016500933e-17) }},
{{ SC_(9.0823287963867187500000000000000000000000e+00), SC_(6.7884831428527832031250000000000000000000e+00), SC_(8.4073317050933837890625000000000000000000e-01), SC_(2.3253553052043743572314085978783936666270e-01) }},
{{ SC_(9.1113471984863281250000000000000000000000e+00), SC_(8.6217231750488281250000000000000000000000e+00), SC_(9.5751106739044189453125000000000000000000e-01), SC_(4.4195677053725254695509680571117699443277e-06) }},
{{ SC_(9.4229335784912109375000000000000000000000e+00), SC_(7.7645378112792968750000000000000000000000e+01), SC_(8.0819469690322875976562500000000000000000e-01), SC_(1.8912473365492082636877902718276687259004e-43) }},
{{ SC_(9.6454534530639648437500000000000000000000e+00), SC_(2.2341995239257812500000000000000000000000e+01), SC_(3.2503104209899902343750000000000000000000e-01), SC_(4.4873628180983870635954156690826834427898e+00) }},
{{ SC_(9.6730031967163085937500000000000000000000e+00), SC_(2.8968938827514648437500000000000000000000e+01), SC_(6.0288280248641967773437500000000000000000e-01), SC_(2.2196350401144129220977327421878629614844e-04) }},
{{ SC_(9.7131776809692382812500000000000000000000e+00), SC_(9.9406852722167968750000000000000000000000e+01), SC_(8.3912998437881469726562500000000000000000e-02), SC_(1.5029593975108844998316495940601529495151e+01) }},
{{ SC_(9.7540397644042968750000000000000000000000e+00), SC_(5.4722057342529296875000000000000000000000e+01), SC_(1.3637771829962730407714843750000000000000e-02), SC_(2.0219479728388344001129177285423984401507e-05) }},
{{ SC_(9.8712282180786132812500000000000000000000e+00), SC_(7.6685409545898437500000000000000000000000e+01), SC_(5.0600647926330566406250000000000000000000e-01), SC_(4.0116702034246323475372693058426121485208e-13) }},
{{ SC_(1.0562920570373535156250000000000000000000e+01), SC_(6.8127136230468750000000000000000000000000e+01), SC_(8.2583439350128173828125000000000000000000e-01), SC_(6.4310333468233385232924679451034802639381e-39) }},
{{ SC_(1.0621634483337402343750000000000000000000e+01), SC_(4.9278961181640625000000000000000000000000e+01), SC_(6.7985177040100097656250000000000000000000e-01), SC_(5.3858309965358079937490625366688470394612e-14) }},
{{ SC_(1.0665277481079101562500000000000000000000e+01), SC_(4.9854419708251953125000000000000000000000e+01), SC_(2.4002853035926818847656250000000000000000e-01), SC_(3.1187513746257366856970775676846723472293e+00) }},
{{ SC_(1.0676186561584472656250000000000000000000e+01), SC_(5.0197441101074218750000000000000000000000e+01), SC_(5.2858030796051025390625000000000000000000e-01), SC_(3.9650283939187534962311144517331442971100e-07) }},
{{ SC_(1.0776901245117187500000000000000000000000e+01), SC_(3.7481258392333984375000000000000000000000e+01), SC_(7.9485189914703369140625000000000000000000e-01), SC_(1.3109221711129630407433152885373626068431e-15) }},
{{ SC_(1.1111922264099121093750000000000000000000e+01), SC_(7.0732154846191406250000000000000000000000e+01), SC_(4.4273400306701660156250000000000000000000e-01), SC_(8.3478045067836009543710006747196699193666e-08) }},
{{ SC_(1.1120275497436523437500000000000000000000e+01), SC_(1.6287212371826171875000000000000000000000e+01), SC_(3.1257674098014831542968750000000000000000e-01), SC_(2.7856134359777401694323253950114592152215e+00) }},
{{ SC_(1.1741765975952148437500000000000000000000e+01), SC_(3.2496353149414062500000000000000000000000e+01), SC_(4.5804336667060852050781250000000000000000e-01), SC_(1.4490615315893460413800248058644705625580e-01) }},
{{ SC_(1.1899767875671386718750000000000000000000e+01), SC_(4.5603282928466796875000000000000000000000e+01), SC_(1.2527024745941162109375000000000000000000e-01), SC_(2.4690575982516011251678784255121134385404e+00) }},
{{ SC_(1.1939624786376953125000000000000000000000e+01), SC_(1.1107936859130859375000000000000000000000e+01), SC_(9.7992765903472900390625000000000000000000e-01), SC_(4.5093593961851700039513260612173877438070e-11) }},
{{ SC_(1.2061161994934082031250000000000000000000e+01), SC_(7.0715972900390625000000000000000000000000e+01), SC_(7.6554024219512939453125000000000000000000e-01), SC_(6.7681695831897014636544674296977262284443e-31) }},
{{ SC_(1.2331892967224121093750000000000000000000e+01), SC_(2.5295597076416015625000000000000000000000e+01), SC_(2.9639115929603576660156250000000000000000e-01), SC_(5.0099622187368652150799464919858918200011e+00) }},
{{ SC_(1.2698681831359863281250000000000000000000e+01), SC_(9.6886779785156250000000000000000000000000e+01), SC_(4.8830057494342327117919921875000000000000e-03), SC_(8.8759085372078204290481694902877166751910e-11) }},
{{ SC_(1.2801440238952636718750000000000000000000e+01), SC_(8.8172546386718750000000000000000000000000e+01), SC_(7.3174923658370971679687500000000000000000e-01), SC_(2.3959684834938466018983877029879801481351e-35) }},
{{ SC_(1.2990620613098144531250000000000000000000e+01), SC_(1.5443841934204101562500000000000000000000e+01), SC_(1.9457593560218811035156250000000000000000e-01), SC_(4.5009556206529124507563739506987037742597e-02) }},
{{ SC_(1.3197329521179199218750000000000000000000e+01), SC_(4.9030147552490234375000000000000000000000e+01), SC_(3.3251503109931945800781250000000000000000e-01), SC_(6.3924992600767308554168553588533170799656e-01) }},
{{ SC_(1.3317100524902343750000000000000000000000e+01), SC_(7.6503977775573730468750000000000000000000e+00), SC_(6.4458608627319335937500000000000000000000e-01), SC_(3.7729335933569342436967490852754916717382e+00) }},
{{ SC_(1.3606855392456054687500000000000000000000e+01), SC_(8.0211143493652343750000000000000000000000e+01), SC_(2.6255598664283752441406250000000000000000e-01), SC_(1.5854052099622158348827849145379430722141e-01) }},
{{ SC_(1.3655313491821289062500000000000000000000e+01), SC_(8.4710968017578125000000000000000000000000e+01), SC_(5.1329821348190307617187500000000000000000e-01), SC_(3.1394723131635399959244980908368501008223e-13) }},
{{ SC_(1.3862444877624511718750000000000000000000e+01), SC_(7.6173118591308593750000000000000000000000e+01), SC_(1.4197215437889099121093750000000000000000e-01), SC_(1.0581979947827440430361070783605737372261e+01) }},
{{ SC_(1.4188633918762207031250000000000000000000e+01), SC_(4.7834840416908264160156250000000000000000e-01), SC_(3.5808108747005462646484375000000000000000e-02), SC_(1.6478079705378913515997329679539301948765e-19) }},
{{ SC_(1.4495479583740234375000000000000000000000e+01), SC_(6.8028709411621093750000000000000000000000e+01), SC_(2.7282574772834777832031250000000000000000e-01), SC_(8.0501710923851700513338638318708020804912e-01) }},
{{ SC_(1.4553898811340332031250000000000000000000e+01), SC_(2.8267330169677734375000000000000000000000e+01), SC_(2.6228553056716918945312500000000000000000e-01), SC_(3.3798927638241715676810397320583363319808e+00) }},
{{ SC_(1.4929400444030761718750000000000000000000e+01), SC_(2.3015605926513671875000000000000000000000e+01), SC_(1.4504030346870422363281250000000000000000e-01), SC_(8.7824944126020821934494175942001425002052e-03) }},
{{ SC_(1.4986544609069824218750000000000000000000e+01), SC_(1.9510740280151367187500000000000000000000e+01), SC_(6.2209290266036987304687500000000000000000e-01), SC_(4.0843389894132075517906564367620589440411e-01) }},
{{ SC_(1.5237802505493164062500000000000000000000e+01), SC_(5.0319004058837890625000000000000000000000e+01), SC_(2.3023304343223571777343750000000000000000e-01), SC_(7.6466348308792206006421445393460304137052e+00) }},
{{ SC_(1.5272119522094726562500000000000000000000e+01), SC_(5.4025207519531250000000000000000000000000e+01), SC_(9.3401730060577392578125000000000000000000e-01), SC_(9.6697969079597332027763688276799076735701e-48) }},
{{ SC_(1.5365672111511230468750000000000000000000e+01), SC_(5.2704280853271484375000000000000000000000e+01), SC_(8.4848290681838989257812500000000000000000e-01), SC_(3.3555888768236523631536725804485448836684e-28) }},
{{ SC_(1.5640495300292968750000000000000000000000e+01), SC_(3.3579792022705078125000000000000000000000e+01), SC_(7.5722450017929077148437500000000000000000e-01), SC_(4.7643880915319515621425791847563266881377e-09) }},
{{ SC_(1.5761308670043945312500000000000000000000e+01), SC_(7.2583892822265625000000000000000000000000e+01), SC_(2.9317358508706092834472656250000000000000e-02), SC_(3.9411391773509578319993812435021064171438e-06) }},
{{ SC_(1.6148475646972656250000000000000000000000e+01), SC_(4.8818401336669921875000000000000000000000e+01), SC_(8.0103451013565063476562500000000000000000e-01), SC_(9.3570301608999178982056298119317060367250e-20) }},
{{ SC_(1.6218229293823242187500000000000000000000e+01), SC_(9.2749282836914062500000000000000000000000e+01), SC_(2.0782151818275451660156250000000000000000e-01), SC_(2.5739867174447437362482762321542673530783e+00) }},
{{ SC_(1.6261173248291015625000000000000000000000e+01), SC_(6.4396095275878906250000000000000000000000e+01), SC_(1.2340660393238067626953125000000000000000e-01), SC_(1.8537807500922160120867600037754217659551e+00) }},
{{ SC_(1.6564872741699218750000000000000000000000e+01), SC_(1.1954717636108398437500000000000000000000e+01), SC_(2.1200314164161682128906250000000000000000e-01), SC_(6.6303227366582271418405264438775646586126e-04) }},
{{ SC_(1.6716840744018554687500000000000000000000e+01), SC_(1.7211780548095703125000000000000000000000e+01), SC_(6.7973470687866210937500000000000000000000e-01), SC_(4.1900742785100916389682918237173900352305e-01) }},
{{ SC_(1.6792715072631835937500000000000000000000e+01), SC_(9.6299751281738281250000000000000000000000e+01), SC_(5.7974660396575927734375000000000000000000e-01), SC_(1.5492459698196544002451823167651068277900e-19) }},
{{ SC_(1.6899003982543945312500000000000000000000e+01), SC_(8.0913719177246093750000000000000000000000e+01), SC_(3.5079205036163330078125000000000000000000e-01), SC_(3.1351872931832876768114155736263625358219e-03) }},
{{ SC_(1.7070804595947265625000000000000000000000e+01), SC_(2.3950246810913085937500000000000000000000e+01), SC_(4.3026438355445861816406250000000000000000e-01), SC_(5.0207574145144834011032035437961338032079e+00) }},
{{ SC_(1.7112106323242187500000000000000000000000e+01), SC_(7.3929756164550781250000000000000000000000e+01), SC_(7.4067318439483642578125000000000000000000e-01), SC_(2.6839767357177156851309455676582340164533e-26) }},
{{ SC_(1.7118667602539062500000000000000000000000e+01), SC_(3.0191310882568359375000000000000000000000e+01), SC_(7.5946711003780364990234375000000000000000e-02), SC_(3.3002660667767896318075366345993455082396e-06) }},
{{ SC_(1.7338861465454101562500000000000000000000e+01), SC_(7.1390388488769531250000000000000000000000e+01), SC_(6.4634835720062255859375000000000000000000e-01), SC_(2.1555968941115736062068426401259950429825e-16) }},
{{ SC_(1.7587440490722656250000000000000000000000e+01), SC_(4.8637111663818359375000000000000000000000e+01), SC_(9.2927074432373046875000000000000000000000e-01), SC_(2.9581341161371130148121184229493853143232e-39) }},
{{ SC_(1.7813245773315429687500000000000000000000e+01), SC_(3.1267694473266601562500000000000000000000e+01), SC_(7.3035782575607299804687500000000000000000e-01), SC_(3.6844513039312539672707106444223185128597e-06) }},
{{ SC_(1.7876619338989257812500000000000000000000e+01), SC_(4.2912654876708984375000000000000000000000e+01), SC_(8.0213123559951782226562500000000000000000e-01), SC_(1.0834081996379378628532762553546156997486e-15) }},
{{ SC_(1.8184701919555664062500000000000000000000e+01), SC_(9.8236053466796875000000000000000000000000e+01), SC_(2.5837007164955139160156250000000000000000e-01), SC_(2.3851851264980663155393806936088843469367e-01) }},
{{ SC_(1.8292245864868164062500000000000000000000e+01), SC_(2.4501924514770507812500000000000000000000e+01), SC_(5.6786483526229858398437500000000000000000e-01), SC_(9.5723547452311438886029647213966011612633e-01) }},
{{ SC_(1.8351116180419921875000000000000000000000e+01), SC_(3.8571052551269531250000000000000000000000e+01), SC_(3.6854773759841918945312500000000000000000e-01), SC_(4.6105923590001697514965238062333747280749e+00) }},
{{ SC_(1.8390779495239257812500000000000000000000e+01), SC_(5.0477100372314453125000000000000000000000e+01), SC_(2.9674619436264038085937500000000000000000e-01), SC_(6.0196468581787789457655977301949020348036e+00) }},
{{ SC_(1.8481632232666015625000000000000000000000e+01), SC_(5.8438224792480468750000000000000000000000e+01), SC_(4.3872296810150146484375000000000000000000e-01), SC_(8.5179927363967466117655525848042395934578e-03) }},
{{ SC_(1.8687259674072265625000000000000000000000e+01), SC_(4.0873115539550781250000000000000000000000e+01), SC_(1.0815110802650451660156250000000000000000e-01), SC_(1.5006107305128679468815015216764954180587e-03) }},
{{ SC_(1.8866197586059570312500000000000000000000e+01), SC_(8.8494262695312500000000000000000000000000e+01), SC_(9.5613896846771240234375000000000000000000e-01), SC_(5.1371978520682994300828597525557877841769e-98) }},
{{ SC_(1.8895500183105468750000000000000000000000e+01), SC_(8.1187400817871093750000000000000000000000e+01), SC_(3.6135786771774291992187500000000000000000e-01), SC_(5.2820946312891493327904318484970728353652e-03) }},
{{ SC_(1.9043327331542968750000000000000000000000e+01), SC_(4.5651042938232421875000000000000000000000e+01), SC_(7.5129193067550659179687500000000000000000e-01), SC_(9.2403628760135804702065631042190185769570e-13) }},
{{ SC_(1.9092369079589843750000000000000000000000e+01), SC_(5.9598098754882812500000000000000000000000e+01), SC_(7.6244509220123291015625000000000000000000e-01), SC_(2.5389758299061316812262112018557718782459e-20) }},
{{ SC_(1.9174524307250976562500000000000000000000e+01), SC_(5.4286212921142578125000000000000000000000e+01), SC_(9.4205635786056518554687500000000000000000e-01), SC_(1.2737605289365943856815490623091441848117e-48) }},
{{ SC_(1.9476428985595703125000000000000000000000e+01), SC_(4.4122348785400390625000000000000000000000e+01), SC_(4.2322281002998352050781250000000000000000e-01), SC_(9.4296683321672019710835172503579785263894e-01) }},
{{ SC_(1.9659524917602539062500000000000000000000e+01), SC_(8.4846778869628906250000000000000000000000e+01), SC_(1.5814177691936492919921875000000000000000e-01), SC_(8.5158736183409697147367753633324199392406e+00) }},
{{ SC_(1.9780982971191406250000000000000000000000e+01), SC_(5.1385921478271484375000000000000000000000e+01), SC_(5.4663729667663574218750000000000000000000e-01), SC_(1.6079307018864949560541689344883407302031e-04) }},
{{ SC_(1.9811840057373046875000000000000000000000e+01), SC_(8.6430747985839843750000000000000000000000e+01), SC_(6.8043857812881469726562500000000000000000e-01), SC_(8.4697252108180999859844258855417483084762e-24) }},
{{ SC_(2.0774229049682617187500000000000000000000e+01), SC_(5.4013801574707031250000000000000000000000e+01), SC_(4.1272526979446411132812500000000000000000e-01), SC_(3.3339124678309507535912413192408141588004e-01) }},
{{ SC_(2.0893491744995117187500000000000000000000e+01), SC_(5.8787704467773437500000000000000000000000e+01), SC_(9.7059571743011474609375000000000000000000e-01), SC_(2.1800966153130640507699932748426440609586e-69) }},
{{ SC_(2.2174673080444335937500000000000000000000e+01), SC_(8.3121429443359375000000000000000000000000e+01), SC_(4.5608720183372497558593750000000000000000e-01), SC_(6.6282915631101227748931000941975707191245e-06) }},
{{ SC_(2.2381193161010742187500000000000000000000e+01), SC_(1.7773896455764770507812500000000000000000e+00), SC_(1.3206009566783905029296875000000000000000e-01), SC_(3.9741404736386063143725973701359026941606e-17) }},
{{ SC_(2.2404003143310546875000000000000000000000e+01), SC_(9.1827659606933593750000000000000000000000e+01), SC_(9.0006387233734130859375000000000000000000e-01), SC_(8.9492624738138863706829947359003606892188e-68) }},
{{ SC_(2.2592178344726562500000000000000000000000e+01), SC_(1.4782900810241699218750000000000000000000e+01), SC_(4.2422434687614440917968750000000000000000e-01), SC_(4.1883814039072615764565886214063024820382e-01) }},
{{ SC_(2.2618766784667968750000000000000000000000e+01), SC_(4.7799575805664062500000000000000000000000e+01), SC_(7.7493298053741455078125000000000000000000e-01), SC_(4.8469187333721450425970128101232185198854e-14) }},
{{ SC_(2.2766429901123046875000000000000000000000e+01), SC_(7.9965316772460937500000000000000000000000e+01), SC_(4.3147069215774536132812500000000000000000e-01), SC_(3.2410192052926632218209313540689177394507e-04) }},
{{ SC_(2.2897697448730468750000000000000000000000e+01), SC_(5.0549854278564453125000000000000000000000e+01), SC_(2.2774152457714080810546875000000000000000e-01), SC_(2.2833187941541481411935392974952547536195e+00) }},
{{ SC_(2.3048816680908203125000000000000000000000e+01), SC_(1.9449537277221679687500000000000000000000e+01), SC_(4.2181909084320068359375000000000000000000e-01), SC_(1.5191260955684216208169944134028314782737e+00) }},
{{ SC_(2.3159439086914062500000000000000000000000e+01), SC_(4.0157146453857421875000000000000000000000e+01), SC_(4.9035245180130004882812500000000000000000e-01), SC_(8.2971724790287950196659598352092383606656e-01) }},
{{ SC_(2.3477991104125976562500000000000000000000e+01), SC_(5.5288116455078125000000000000000000000000e+01), SC_(3.4390515089035034179687500000000000000000e-01), SC_(4.9120535689588021242491975708853077218302e+00) }},
{{ SC_(2.3623058319091796875000000000000000000000e+01), SC_(3.2823646545410156250000000000000000000000e+01), SC_(9.7975039482116699218750000000000000000000e-01), SC_(5.4438894879289930120643786621361413461166e-38) }},
{{ SC_(2.3728357315063476562500000000000000000000e+01), SC_(9.6864036560058593750000000000000000000000e+01), SC_(4.8762014508247375488281250000000000000000e-01), SC_(1.9102102647622726113352476154064664390874e-09) }},
{{ SC_(2.3991615295410156250000000000000000000000e+01), SC_(4.0471110343933105468750000000000000000000e+00), SC_(2.8787621855735778808593750000000000000000e-01), SC_(1.0109668085872759596065255399832967332076e-08) }},
{{ SC_(2.3993202209472656250000000000000000000000e+01), SC_(3.3300525665283203125000000000000000000000e+01), SC_(5.6886672973632812500000000000000000000000e-01), SC_(4.4996899248532949909715205284295964486536e-01) }},
{{ SC_(2.3995252609252929687500000000000000000000e+01), SC_(8.2260498046875000000000000000000000000000e+01), SC_(2.9709973931312561035156250000000000000000e-01), SC_(2.0994063257704952648181582886994320628226e+00) }},
{{ SC_(2.4070703506469726562500000000000000000000e+01), SC_(4.1576251983642578125000000000000000000000e+01), SC_(8.7595522403717041015625000000000000000000e-01), SC_(6.6092636076736408945688826554511946965486e-20) }},
{{ SC_(2.4169128417968750000000000000000000000000e+01), SC_(2.7275302886962890625000000000000000000000e+01), SC_(3.1884643435478210449218750000000000000000e-01), SC_(5.1889840187279112026374904162617718136169e-01) }},
{{ SC_(2.4284959793090820312500000000000000000000e+01), SC_(3.3197727203369140625000000000000000000000e+01), SC_(9.4893020391464233398437500000000000000000e-01), SC_(1.1242183335067400286974287282529164376018e-25) }},
{{ SC_(2.4352497100830078125000000000000000000000e+01), SC_(1.3539125919342041015625000000000000000000e+00), SC_(1.5246278047561645507812500000000000000000e-01), SC_(6.7784565432201535183965569468535652643621e-18) }},
{{ SC_(2.5108385086059570312500000000000000000000e+01), SC_(9.5501754760742187500000000000000000000000e+01), SC_(1.6226607561111450195312500000000000000000e-01), SC_(5.4464944211193479333235558035508797629252e+00) }},
{{ SC_(2.5180610656738281250000000000000000000000e+01), SC_(6.5472358703613281250000000000000000000000e+01), SC_(7.7918928861618041992187500000000000000000e-01), SC_(3.7815687622421514204719222088251602517594e-22) }},
{{ SC_(2.5428216934204101562500000000000000000000e+01), SC_(3.3244827270507812500000000000000000000000e+01), SC_(1.4919906854629516601562500000000000000000e-01), SC_(1.4714826739565438828722835743276904697417e-05) }},
{{ SC_(2.5479015350341796875000000000000000000000e+01), SC_(9.3521430969238281250000000000000000000000e+01), SC_(8.9091414213180541992187500000000000000000e-01), SC_(6.8517229286863813028095216134794128652242e-64) }},
{{ SC_(2.5509511947631835937500000000000000000000e+01), SC_(8.2084075927734375000000000000000000000000e+01), SC_(1.3382300734519958496093750000000000000000e-01), SC_(2.3404029280962216134762653439652292727016e-01) }},
{{ SC_(2.5644100189208984375000000000000000000000e+01), SC_(3.4306179046630859375000000000000000000000e+01), SC_(9.9613505601882934570312500000000000000000e-01), SC_(3.5641059911449806281865371135107106157049e-63) }},
{{ SC_(2.5750823974609375000000000000000000000000e+01), SC_(8.0973449707031250000000000000000000000000e+01), SC_(1.4562442898750305175781250000000000000000e-01), SC_(4.7720744472152342477944770207350518399798e-01) }},
{{ SC_(2.5806468963623046875000000000000000000000e+01), SC_(1.6232851028442382812500000000000000000000e+01), SC_(4.4564163684844970703125000000000000000000e-01), SC_(4.6200022270764762338757432786653828240117e-01) }},
{{ SC_(2.5987041473388671875000000000000000000000e+01), SC_(4.5059542655944824218750000000000000000000e+00), SC_(2.5435674190521240234375000000000000000000e-01), SC_(1.3432971482725805082317841433941720498012e-10) }},
{{ SC_(2.6072799682617187500000000000000000000000e+01), SC_(6.5921058654785156250000000000000000000000e+01), SC_(7.9794883728027343750000000000000000000000e-01), SC_(3.1983364183205155318163430150311602209610e-24) }},
{{ SC_(2.6187118530273437500000000000000000000000e+01), SC_(3.2779777526855468750000000000000000000000e+01), SC_(5.0790750980377197265625000000000000000000e-01), SC_(3.7486263149100291085451188407991609434281e+00) }},
{{ SC_(2.6221174240112304687500000000000000000000e+01), SC_(4.2054123878479003906250000000000000000000e+00), SC_(4.4961112737655639648437500000000000000000e-01), SC_(3.9160750903893793670481241116131252929271e-05) }},
{{ SC_(2.6248222351074218750000000000000000000000e+01), SC_(1.8157297134399414062500000000000000000000e+01), SC_(4.7200959920883178710937500000000000000000e-01), SC_(1.4724421440262287545680118624541748943861e+00) }},
{{ SC_(2.6297128677368164062500000000000000000000e+01), SC_(3.4021968841552734375000000000000000000000e+01), SC_(2.1731612086296081542968750000000000000000e-01), SC_(6.9737114825872575584800840872178224142273e-03) }},
{{ SC_(2.6380290985107421875000000000000000000000e+01), SC_(9.5355176925659179687500000000000000000000e+00), SC_(2.5994440913200378417968750000000000000000e-01), SC_(1.2023724269430634023722742877171176625533e-07) }},
{{ SC_(2.6528089523315429687500000000000000000000e+01), SC_(9.9647506713867187500000000000000000000000e+01), SC_(7.8027403354644775390625000000000000000000e-01), SC_(5.8749655331667704102949630670779792937877e-40) }},
{{ SC_(2.6647150039672851562500000000000000000000e+01), SC_(6.9140052795410156250000000000000000000000e+00), SC_(8.4432435035705566406250000000000000000000e-01), SC_(5.2066361888102294483641361066261994580576e+00) }},
{{ SC_(2.6906160354614257812500000000000000000000e+01), SC_(8.5707244873046875000000000000000000000000e+01), SC_(9.5494788885116577148437500000000000000000e-01), SC_(3.8680535338347812115838066655536557524879e-88) }},
{{ SC_(2.6911941528320312500000000000000000000000e+01), SC_(9.7187736511230468750000000000000000000000e+01), SC_(7.0580369234085083007812500000000000000000e-01), SC_(2.5829050525894153112391706724714705230862e-27) }},
{{ SC_(2.7602508544921875000000000000000000000000e+01), SC_(7.0577423095703125000000000000000000000000e+01), SC_(1.1750591546297073364257812500000000000000e-01), SC_(1.1509750159806849974124406836073093393830e-03) }},
{{ SC_(2.7692296981811523437500000000000000000000e+01), SC_(8.7242881774902343750000000000000000000000e+01), SC_(7.8267715871334075927734375000000000000000e-02), SC_(1.7251885764224589803873074168613430760784e-05) }},
{{ SC_(2.7849822998046875000000000000000000000000e+01), SC_(1.8838197708129882812500000000000000000000e+01), SC_(1.5501900576055049896240234375000000000000e-02), SC_(1.2283480860518369277757446886494377165915e-35) }},
{{ SC_(2.8100528717041015625000000000000000000000e+01), SC_(2.6204881668090820312500000000000000000000e+01), SC_(8.4914439916610717773437500000000000000000e-01), SC_(7.4015157140003732719265256418224254893622e-07) }},
{{ SC_(2.8583902359008789062500000000000000000000e+01), SC_(6.7981979370117187500000000000000000000000e+01), SC_(1.7126956582069396972656250000000000000000e-01), SC_(1.3281911186101250641008306217375065794402e-01) }},
{{ SC_(2.8749816894531250000000000000000000000000e+01), SC_(5.9308696746826171875000000000000000000000e+01), SC_(9.5717126131057739257812500000000000000000e-01), SC_(1.2317417071427980847813345694915332783928e-56) }},
{{ SC_(2.8906457901000976562500000000000000000000e+01), SC_(5.5441427230834960937500000000000000000000e+00), SC_(8.7737619876861572265625000000000000000000e-01), SC_(6.3404189050978286421304092201107010072442e+00) }},
{{ SC_(2.9044067382812500000000000000000000000000e+01), SC_(7.8066945075988769531250000000000000000000e+00), SC_(7.7971142530441284179687500000000000000000e-01), SC_(5.6529394431609880964207853192142153877950e+00) }},
{{ SC_(2.9198408126831054687500000000000000000000e+01), SC_(8.2463165283203125000000000000000000000000e+01), SC_(6.6363912820816040039062500000000000000000e-01), SC_(3.6508036732549262235327811352219720583942e-16) }},
{{ SC_(2.9632080078125000000000000000000000000000e+01), SC_(2.8780498504638671875000000000000000000000e+01), SC_(3.5640951991081237792968750000000000000000e-01), SC_(4.1392931662655831721142069325577844976514e-01) }},
{{ SC_(2.9667585372924804687500000000000000000000e+01), SC_(6.5577987670898437500000000000000000000000e+01), SC_(4.5855104923248291015625000000000000000000e-01), SC_(9.9749104562547586264135658772962857683364e-02) }},
{{ SC_(3.0124633789062500000000000000000000000000e+01), SC_(1.8450843095779418945312500000000000000000e+00), SC_(4.1732531785964965820312500000000000000000e-01), SC_(3.2584499779460045408916249645942921294341e-09) }},
{{ SC_(3.0145496368408203125000000000000000000000e+01), SC_(3.1048995971679687500000000000000000000000e+01), SC_(7.1612906455993652343750000000000000000000e-01), SC_(8.9202634457618879558722542376774662756426e-03) }},
{{ SC_(3.0634948730468750000000000000000000000000e+01), SC_(1.0806191444396972656250000000000000000000e+01), SC_(3.8863095641136169433593750000000000000000e-01), SC_(1.3087533406868719358288711070394727835598e-04) }},
{{ SC_(3.1110229492187500000000000000000000000000e+01), SC_(8.9823160171508789062500000000000000000000e+00), SC_(4.3575510382652282714843750000000000000000e-01), SC_(2.7201014840208243903458854851088767752520e-04) }},
{{ SC_(3.1121503829956054687500000000000000000000e+01), SC_(8.6267814636230468750000000000000000000000e+01), SC_(2.1028804779052734375000000000000000000000e-01), SC_(4.2011443019486037389171496047006534427872e+00) }},
{{ SC_(3.1271890640258789062500000000000000000000e+01), SC_(4.9175216674804687500000000000000000000000e+01), SC_(8.0030041933059692382812500000000000000000e-01), SC_(8.9429697270923485029817394575229288517242e-14) }},
{{ SC_(3.1709947586059570312500000000000000000000e+01), SC_(7.6375000000000000000000000000000000000000e+01), SC_(8.9914172887802124023437500000000000000000e-02), SC_(2.9440549727337358761476388534076746195208e-07) }},
{{ SC_(3.1877830505371093750000000000000000000000e+01), SC_(4.2018993377685546875000000000000000000000e+01), SC_(4.5890295505523681640625000000000000000000e-01), SC_(6.0875869243246121262675189907023765595967e+00) }},
{{ SC_(3.1959974288940429687500000000000000000000e+01), SC_(3.2532787322998046875000000000000000000000e+01), SC_(8.1732153892517089843750000000000000000000e-01), SC_(4.1948616211955510996993344775890704104541e-07) }},
{{ SC_(3.2247180938720703125000000000000000000000e+01), SC_(3.0466350555419921875000000000000000000000e+01), SC_(9.2088270187377929687500000000000000000000e-01), SC_(3.0331244305090637942214338398307836197103e-15) }},
{{ SC_(3.2514568328857421875000000000000000000000e+01), SC_(6.8296646118164062500000000000000000000000e+01), SC_(8.2347548007965087890625000000000000000000e-01), SC_(2.8422001125704004423219989804573718691672e-26) }},
{{ SC_(3.3416305541992187500000000000000000000000e+01), SC_(7.1997093200683593750000000000000000000000e+01), SC_(5.4385107755661010742187500000000000000000e-01), SC_(1.2463574197770709880221144060859172697031e-04) }},
{{ SC_(3.3535682678222656250000000000000000000000e+01), SC_(1.2906617164611816406250000000000000000000e+01), SC_(5.0855785608291625976562500000000000000000e-01), SC_(5.9446337931590739943658891014550594964032e-02) }},
{{ SC_(3.3712265014648437500000000000000000000000e+01), SC_(3.8856979370117187500000000000000000000000e+01), SC_(1.9995288550853729248046875000000000000000e-01), SC_(2.8702375457097315483743344378203256774304e-05) }},
{{ SC_(3.3771942138671875000000000000000000000000e+01), SC_(8.8772613525390625000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.7505492209316887146677636408483739908575e+00) }},
{{ SC_(3.3949340820312500000000000000000000000000e+01), SC_(6.1627227783203125000000000000000000000000e+01), SC_(6.8680679798126220703125000000000000000000e-01), SC_(2.1469499457989785662697137430944357612024e-09) }},
{{ SC_(3.4038574218750000000000000000000000000000e+01), SC_(8.7675743103027343750000000000000000000000e+01), SC_(1.2993355095386505126953125000000000000000e-01), SC_(1.2594457424902665013177704242333860100520e-03) }},
{{ SC_(3.4112461090087890625000000000000000000000e+01), SC_(7.2302421569824218750000000000000000000000e+01), SC_(9.3900763988494873046875000000000000000000e-01), SC_(5.6879412870914692136084315713072692920778e-59) }},
{{ SC_(3.4387702941894531250000000000000000000000e+01), SC_(2.0375970840454101562500000000000000000000e+01), SC_(7.9399561882019042968750000000000000000000e-01), SC_(1.6270911239338789884763554395891212193797e-01) }},
{{ SC_(3.4446243286132812500000000000000000000000e+01), SC_(2.2622739791870117187500000000000000000000e+01), SC_(9.0489047765731811523437500000000000000000e-01), SC_(1.8404498062472159638902882289713677063977e-07) }},
{{ SC_(3.4998374938964843750000000000000000000000e+01), SC_(9.0736473083496093750000000000000000000000e+01), SC_(1.5769731998443603515625000000000000000000e-01), SC_(4.2993970646720066354853577428585611847087e-02) }},
{{ SC_(3.5021800994873046875000000000000000000000e+01), SC_(6.8738579750061035156250000000000000000000e+00), SC_(9.8852270841598510742187500000000000000000e-01), SC_(3.3876698580608716797557014582979072584910e-04) }},
{{ SC_(3.5072711944580078125000000000000000000000e+01), SC_(9.9011001586914062500000000000000000000000e+01), SC_(4.0186783671379089355468750000000000000000e-01), SC_(2.5452174041747784320301357397996399812346e-02) }},
{{ SC_(3.5095237731933593750000000000000000000000e+01), SC_(1.9955120086669921875000000000000000000000e+01), SC_(2.7857038378715515136718750000000000000000e-01), SC_(1.5625874075609776204358613654041274428444e-06) }},
{{ SC_(3.5165950775146484375000000000000000000000e+01), SC_(6.7595376968383789062500000000000000000000e+00), SC_(1.6295583546161651611328125000000000000000e-01), SC_(4.4599553285487170680383695160269218543702e-20) }},
{{ SC_(3.5315856933593750000000000000000000000000e+01), SC_(5.3152570724487304687500000000000000000000e+00), SC_(3.4399533271789550781250000000000000000000e-01), SC_(1.1970130600176088665731643754677197026318e-10) }},
{{ SC_(3.6743663787841796875000000000000000000000e+01), SC_(1.5157416343688964843750000000000000000000e+01), SC_(4.9841421842575073242187500000000000000000e-01), SC_(4.7394625701790201762166533386585322175474e-02) }},
{{ SC_(3.6848457336425781250000000000000000000000e+01), SC_(3.4392974853515625000000000000000000000000e+01), SC_(3.6930984258651733398437500000000000000000e-01), SC_(2.8759504140227955002327509421544772492636e-01) }},
{{ SC_(3.6891654968261718750000000000000000000000e+01), SC_(6.3430332183837890625000000000000000000000e+01), SC_(7.5375372171401977539062500000000000000000e-01), SC_(3.4464390071147174965485687827769438562120e-14) }},
{{ SC_(3.6924678802490234375000000000000000000000e+01), SC_(3.3268566131591796875000000000000000000000e+00), SC_(3.1128391623497009277343750000000000000000e-01), SC_(1.7091672407841305749979849036706999533083e-14) }},
{{ SC_(3.7240974426269531250000000000000000000000e+01), SC_(1.9532476425170898437500000000000000000000e+01), SC_(6.8031901121139526367187500000000000000000e-01), SC_(6.0519874425373459949062455699765035739163e+00) }},
{{ SC_(3.7627220153808593750000000000000000000000e+01), SC_(1.7316303253173828125000000000000000000000e+01), SC_(7.6175504922866821289062500000000000000000e-01), SC_(3.2509032213061197448255671540357588173776e+00) }},
{{ SC_(3.7860939025878906250000000000000000000000e+01), SC_(1.4014384269714355468750000000000000000000e+01), SC_(3.9496871829032897949218750000000000000000e-01), SC_(3.4330289308558721163826354662570171304690e-05) }},
{{ SC_(3.8044582366943359375000000000000000000000e+01), SC_(2.0806806564331054687500000000000000000000e+01), SC_(1.8192884325981140136718750000000000000000e-01), SC_(4.1942321540772519334028498464048497272095e-13) }},
{{ SC_(3.8155845642089843750000000000000000000000e+01), SC_(2.1020906448364257812500000000000000000000e+01), SC_(9.7630649805068969726562500000000000000000e-02), SC_(2.8175484687360277341235407841497924989704e-22) }},
{{ SC_(3.8461910247802734375000000000000000000000e+01), SC_(1.8211762905120849609375000000000000000000e+00), SC_(7.7573508024215698242187500000000000000000e-01), SC_(1.8132706585037648482833121196641243700905e-02) }},
{{ SC_(3.8677120208740234375000000000000000000000e+01), SC_(9.8445259094238281250000000000000000000000e+01), SC_(9.1065651178359985351562500000000000000000e-01), SC_(1.0067909672291991799882116187149409825946e-68) }},
{{ SC_(3.8973884582519531250000000000000000000000e+01), SC_(2.1030187606811523437500000000000000000000e+01), SC_(3.1716775894165039062500000000000000000000e-01), SC_(6.1614450763132017865416029245321623272612e-06) }},
{{ SC_(3.9093780517578125000000000000000000000000e+01), SC_(6.1720489501953125000000000000000000000000e+01), SC_(6.4778119325637817382812500000000000000000e-01), SC_(6.6683281703696661678674184211547832921712e-06) }},
{{ SC_(3.9222702026367187500000000000000000000000e+01), SC_(4.2208766937255859375000000000000000000000e+01), SC_(5.9873566031455993652343750000000000000000e-02), SC_(7.9586997807478457283777904054579494248011e-24) }},
{{ SC_(3.9551521301269531250000000000000000000000e+01), SC_(6.3646858215332031250000000000000000000000e+01), SC_(4.9337750673294067382812500000000000000000e-01), SC_(6.2693749131954187504387397830014702853285e-01) }},
{{ SC_(3.9925777435302734375000000000000000000000e+01), SC_(8.5809928894042968750000000000000000000000e+01), SC_(6.5513253211975097656250000000000000000000e-01), SC_(1.2168366893172231245924691037002446363344e-12) }},
{{ SC_(3.9978263854980468750000000000000000000000e+01), SC_(8.5587516784667968750000000000000000000000e+01), SC_(2.5303068757057189941406250000000000000000e-01), SC_(2.8532381807381334530784375834075246488236e+00) }},
{{ SC_(4.0180801391601562500000000000000000000000e+01), SC_(3.8233295440673828125000000000000000000000e+01), SC_(2.8274503350257873535156250000000000000000e-01), SC_(9.3651669476952390614101261739018978293595e-04) }},
{{ SC_(4.0391212463378906250000000000000000000000e+01), SC_(4.9244197845458984375000000000000000000000e+01), SC_(3.2257848978042602539062500000000000000000e-01), SC_(3.5482352435372493924816476543074861455871e-01) }},
{{ SC_(4.0761920928955078125000000000000000000000e+01), SC_(5.1604782104492187500000000000000000000000e+01), SC_(8.2121193408966064453125000000000000000000e-01), SC_(3.7142827907330839256921689312374780894111e-14) }},
{{ SC_(4.0871982574462890625000000000000000000000e+01), SC_(1.3373639106750488281250000000000000000000e+01), SC_(4.4683906435966491699218750000000000000000e-01), SC_(1.3368500342887448516055042581968459754957e-04) }},
{{ SC_(4.1615859985351562500000000000000000000000e+01), SC_(4.3342967987060546875000000000000000000000e+01), SC_(9.9288201332092285156250000000000000000000e-01), SC_(5.8488508897417336994965895412777037627306e-66) }},
{{ SC_(4.1679946899414062500000000000000000000000e+01), SC_(6.1727912902832031250000000000000000000000e+01), SC_(6.5577512979507446289062500000000000000000e-01), SC_(9.9135986536448704598467204165684240636404e-06) }},
{{ SC_(4.1726703643798828125000000000000000000000e+01), SC_(9.8172309875488281250000000000000000000000e+01), SC_(2.9990172386169433593750000000000000000000e-01), SC_(1.0249439079951555641863748348236435462868e+01) }},
{{ SC_(4.1774410247802734375000000000000000000000e+01), SC_(5.6677742004394531250000000000000000000000e+01), SC_(7.1073275804519653320312500000000000000000e-01), SC_(2.4852462840667047853042644215072867202777e-07) }},
{{ SC_(4.2176128387451171875000000000000000000000e+01), SC_(1.1246451377868652343750000000000000000000e+01), SC_(3.6537606269121170043945312500000000000000e-02), SC_(4.6297554113220731465814804774125757928790e-48) }},
{{ SC_(4.2283561706542968750000000000000000000000e+01), SC_(5.6396492004394531250000000000000000000000e+01), SC_(7.0607548952102661132812500000000000000000e-01), SC_(7.2344202451547738094576198507092967051289e-07) }},
{{ SC_(4.2288570404052734375000000000000000000000e+01), SC_(3.9472770690917968750000000000000000000000e+01), SC_(8.0755025148391723632812500000000000000000e-01), SC_(3.0129356608416643876588701412556355078190e-07) }},
{{ SC_(4.2345291137695312500000000000000000000000e+01), SC_(6.9814689636230468750000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.2172941478561483996854444134444402311096e-25) }},
{{ SC_(4.2416675567626953125000000000000000000000e+01), SC_(7.8190917968750000000000000000000000000000e+01), SC_(4.6252796053886413574218750000000000000000e-01), SC_(4.0167025660333112465965073449965303495564e-01) }},
{{ SC_(4.2434902191162109375000000000000000000000e+01), SC_(3.0012050271034240722656250000000000000000e-01), SC_(9.1574394702911376953125000000000000000000e-01), SC_(1.5128029291444539705547052730485481011623e-01) }},
{{ SC_(4.2525932312011718750000000000000000000000e+01), SC_(7.6996566772460937500000000000000000000000e+01), SC_(8.0008846521377563476562500000000000000000e-01), SC_(8.9671999145630171217144677097213288959842e-24) }},
{{ SC_(4.2572883605957031250000000000000000000000e+01), SC_(9.0002212524414062500000000000000000000000e+01), SC_(9.6190190315246582031250000000000000000000e-01), SC_(2.9372265730391289899395243169788379094103e-91) }},
{{ SC_(4.2825298309326171875000000000000000000000e+01), SC_(7.2689315795898437500000000000000000000000e+01), SC_(7.6295512914657592773437500000000000000000e-01), SC_(4.5739745869619874553586832298663437645355e-17) }},
{{ SC_(4.3020740509033203125000000000000000000000e+01), SC_(6.3306365966796875000000000000000000000000e+01), SC_(4.3617394566535949707031250000000000000000e-01), SC_(6.5939117274196711773341310060824890085437e+00) }},
{{ SC_(4.3141384124755859375000000000000000000000e+01), SC_(7.4994102478027343750000000000000000000000e+01), SC_(2.5758248567581176757812500000000000000000e-01), SC_(3.9508427513445339014225353778575676860726e-01) }},
{{ SC_(4.3165119171142578125000000000000000000000e+01), SC_(3.5932441711425781250000000000000000000000e+01), SC_(6.6931819915771484375000000000000000000000e-01), SC_(5.9194817929321906604426206183914858147566e-01) }},
{{ SC_(4.3239151000976562500000000000000000000000e+01), SC_(2.4431964874267578125000000000000000000000e+01), SC_(6.3979935646057128906250000000000000000000e-01), SC_(6.8109799839413191030211225918848387248011e+00) }},
{{ SC_(4.3569869995117187500000000000000000000000e+01), SC_(4.7301506042480468750000000000000000000000e+01), SC_(4.3530216813087463378906250000000000000000e-01), SC_(5.3869115013496144231466481752651860409533e+00) }},
{{ SC_(4.3585857391357421875000000000000000000000e+01), SC_(4.8861770629882812500000000000000000000000e+01), SC_(3.8577193021774291992187500000000000000000e-01), SC_(1.9844944825450917048644338338457743258931e+00) }},
{{ SC_(4.3874435424804687500000000000000000000000e+01), SC_(1.2589663505554199218750000000000000000000e+01), SC_(9.7222059965133666992187500000000000000000e-02), SC_(1.5545445099390107981507011480269561272053e-31) }},
{{ SC_(4.3886997222900390625000000000000000000000e+01), SC_(6.8040664672851562500000000000000000000000e+01), SC_(4.4127935171127319335937500000000000000000e-01), SC_(4.7902281307366654591957626841822297166169e+00) }},
{{ SC_(4.4008514404296875000000000000000000000000e+01), SC_(4.8337516784667968750000000000000000000000e+01), SC_(8.5304582118988037109375000000000000000000e-01), SC_(4.4000698331515696145394329196876831051332e-15) }},
{{ SC_(4.4267826080322265625000000000000000000000e+01), SC_(6.0423149108886718750000000000000000000000e+01), SC_(2.3999217152595520019531250000000000000000e-01), SC_(2.3738113636549679835836943621768862221151e-03) }},
{{ SC_(4.4558620452880859375000000000000000000000e+01), SC_(4.8756893157958984375000000000000000000000e+01), SC_(1.1120810359716415405273437500000000000000e-01), SC_(2.1820288084972970225002705286277164798839e-16) }},
{{ SC_(4.4678375244140625000000000000000000000000e+01), SC_(7.5578987121582031250000000000000000000000e+01), SC_(3.8735717535018920898437500000000000000000e-01), SC_(8.3380247498056595871798188230974929059753e+00) }},
{{ SC_(4.5013771057128906250000000000000000000000e+01), SC_(9.7391502380371093750000000000000000000000e+01), SC_(9.8172497749328613281250000000000000000000e-01), SC_(1.0828765575103844688135839615353169620069e-129) }},
{{ SC_(4.5054157257080078125000000000000000000000e+01), SC_(7.2049346923828125000000000000000000000000e+01), SC_(2.2388955950736999511718750000000000000000e-01), SC_(5.6866727699926119172867173099803682132681e-03) }},
{{ SC_(4.5092372894287109375000000000000000000000e+01), SC_(3.7850044250488281250000000000000000000000e+01), SC_(3.5322323441505432128906250000000000000000e-01), SC_(1.5334005984014021323961490261921691398760e-02) }},
{{ SC_(4.5379768371582031250000000000000000000000e+01), SC_(4.3693290710449218750000000000000000000000e+01), SC_(6.3310039043426513671875000000000000000000e-01), SC_(4.7716941931250281340550519122861075005383e-01) }},
{{ SC_(4.5742435455322265625000000000000000000000e+01), SC_(9.4440765380859375000000000000000000000000e+00), SC_(8.5588955879211425781250000000000000000000e-01), SC_(7.6751617760041939684523489448369864422024e+00) }},
{{ SC_(4.5872547149658203125000000000000000000000e+01), SC_(5.3322948455810546875000000000000000000000e+01), SC_(9.8236232995986938476562500000000000000000e-01), SC_(8.6463481543149307947658009139336331393609e-63) }},
{{ SC_(4.5884883880615234375000000000000000000000e+01), SC_(2.1377273559570312500000000000000000000000e+01), SC_(4.8866012692451477050781250000000000000000e-01), SC_(3.5467796125687380658608168987276648604464e-02) }},
{{ SC_(4.6072593688964843750000000000000000000000e+01), SC_(5.2976299285888671875000000000000000000000e+01), SC_(7.5471121072769165039062500000000000000000e-01), SC_(5.9803645724969513973141367971399465014304e-08) }},
{{ SC_(4.6091636657714843750000000000000000000000e+01), SC_(4.4642395019531250000000000000000000000000e+01), SC_(9.1712617874145507812500000000000000000000e-01), SC_(4.8883329474135246584560093302229819740976e-22) }},
{{ SC_(4.6244915008544921875000000000000000000000e+01), SC_(4.6901557922363281250000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.9693271702342355881271408548825602800694e-23) }},
{{ SC_(4.6939064025878906250000000000000000000000e+01), SC_(3.8729591369628906250000000000000000000000e+01), SC_(1.9667559862136840820312500000000000000000e-01), SC_(7.0449945697202983948483991044099034029647e-11) }},
{{ SC_(4.7092334747314453125000000000000000000000e+01), SC_(9.0018318176269531250000000000000000000000e+01), SC_(4.2024794220924377441406250000000000000000e-01), SC_(1.6685728824456972169048079390965205220614e+00) }},
{{ SC_(4.7092426300048828125000000000000000000000e+01), SC_(7.4850517272949218750000000000000000000000e+01), SC_(8.0975353717803955078125000000000000000000e-01), SC_(1.6131607452109992751228331307491556197632e-22) }},
{{ SC_(4.7108837127685546875000000000000000000000e+01), SC_(3.1823215484619140625000000000000000000000e+01), SC_(5.8530920743942260742187500000000000000000e-01), SC_(6.9864200376560146407888343475170253215291e+00) }},
{{ SC_(4.7135715484619140625000000000000000000000e+01), SC_(2.4758506774902343750000000000000000000000e+01), SC_(9.2750012874603271484375000000000000000000e-01), SC_(5.2987758231276983842054772128093654979056e-09) }},
{{ SC_(4.7328884124755859375000000000000000000000e+01), SC_(9.8745956420898437500000000000000000000000e+01), SC_(1.6269548237323760986328125000000000000000e-01), SC_(1.7221483539453311927358412487313746400162e-04) }},
{{ SC_(4.7348602294921875000000000000000000000000e+01), SC_(2.1562929153442382812500000000000000000000e+01), SC_(9.3399983644485473632812500000000000000000e-01), SC_(1.3607213571039552265600974202975241131251e-07) }},
{{ SC_(4.7992214202880859375000000000000000000000e+01), SC_(4.0151958465576171875000000000000000000000e+01), SC_(5.4726588726043701171875000000000000000000e-01), SC_(7.4965884003731862081504403298753446123663e+00) }},
{{ SC_(4.8202205657958984375000000000000000000000e+01), SC_(8.7757308959960937500000000000000000000000e+01), SC_(7.6377362012863159179687500000000000000000e-01), SC_(7.0193859297437178760640597548303041387791e-22) }},
{{ SC_(4.8537563323974609375000000000000000000000e+01), SC_(7.9810585021972656250000000000000000000000e+01), SC_(3.4413881599903106689453125000000000000000e-02), SC_(3.5184150054781689366221392007856918003143e-34) }},
{{ SC_(4.8679164886474609375000000000000000000000e+01), SC_(9.1056495666503906250000000000000000000000e+01), SC_(3.8239473104476928710937500000000000000000e-01), SC_(6.7122421525094294379256455487194250384929e+00) }},
{{ SC_(4.8860897064208984375000000000000000000000e+01), SC_(3.4432792663574218750000000000000000000000e+01), SC_(4.8542711138725280761718750000000000000000e-01), SC_(1.2916442713228773013606317273983183835242e+00) }},
{{ SC_(4.8889774322509765625000000000000000000000e+01), SC_(4.1329063415527343750000000000000000000000e+01), SC_(4.9063998460769653320312500000000000000000e-01), SC_(4.6870892799940740151008326329040390138108e+00) }},
{{ SC_(4.8925262451171875000000000000000000000000e+01), SC_(5.4405612945556640625000000000000000000000e+01), SC_(3.0641886591911315917968750000000000000000e-01), SC_(1.7503055401021813349098175172585430013086e-02) }},
{{ SC_(4.8968765258789062500000000000000000000000e+01), SC_(2.0419715881347656250000000000000000000000e+01), SC_(6.8139141798019409179687500000000000000000e-01), SC_(6.3087537736118458529919821815843951881395e+00) }},
{{ SC_(4.8976440429687500000000000000000000000000e+01), SC_(4.5798915863037109375000000000000000000000e+01), SC_(1.0995076596736907958984375000000000000000e-01), SC_(3.3715732371457405439227270325014321549257e-20) }},
{{ SC_(4.8990139007568359375000000000000000000000e+01), SC_(3.1015598297119140625000000000000000000000e+01), SC_(5.7856720685958862304687500000000000000000e-01), SC_(5.8852215101384641138206894082287219435744e+00) }},
{{ SC_(4.9086410522460937500000000000000000000000e+01), SC_(2.4784759521484375000000000000000000000000e+01), SC_(3.0368360877037048339843750000000000000000e-01), SC_(1.1192127605663244612392467045156489404838e-08) }},
{{ SC_(4.9417392730712890625000000000000000000000e+01), SC_(1.2538803815841674804687500000000000000000e+00), SC_(5.3084444999694824218750000000000000000000e-01), SC_(5.8689359534585519820368913701948698127666e-12) }},
{{ SC_(4.9836406707763671875000000000000000000000e+01), SC_(7.7391716003417968750000000000000000000000e+01), SC_(1.2598404288291931152343750000000000000000e-01), SC_(8.4969147936498110610890550919225413727258e-12) }},
{{ SC_(5.0002243041992187500000000000000000000000e+01), SC_(2.5394311904907226562500000000000000000000e+01), SC_(5.4726082086563110351562500000000000000000e-01), SC_(8.0956236022323528134783067946687584018081e-01) }},
{{ SC_(5.0047164916992187500000000000000000000000e+01), SC_(3.2253295898437500000000000000000000000000e+01), SC_(5.8530557155609130859375000000000000000000e-01), SC_(6.6402238951316305375206758033664404218303e+00) }},
{{ SC_(5.0595706939697265625000000000000000000000e+01), SC_(9.4007400512695312500000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.2247545855347926303922819101174934903243e-08) }},
{{ SC_(5.0785827636718750000000000000000000000000e+01), SC_(1.1319253921508789062500000000000000000000e+01), SC_(4.6944367885589599609375000000000000000000e-01), SC_(4.9667994040327841848378935562466006985124e-07) }},
{{ SC_(5.0850868225097656250000000000000000000000e+01), SC_(3.9358985900878906250000000000000000000000e+01), SC_(3.8867628574371337890625000000000000000000e-01), SC_(2.8315600934565322823158912601904772043200e-02) }},
{{ SC_(5.1077156066894531250000000000000000000000e+01), SC_(8.7018676757812500000000000000000000000000e+01), SC_(3.8979986310005187988281250000000000000000e-01), SC_(8.4556846165507290348347627394429539523373e+00) }},
{{ SC_(5.1324951171875000000000000000000000000000e+01), SC_(1.3800132751464843750000000000000000000000e+01), SC_(2.8169915080070495605468750000000000000000e-01), SC_(1.5667422342538823873897005362783182168383e-15) }},
{{ SC_(5.1805210113525390625000000000000000000000e+01), SC_(9.6983718872070312500000000000000000000000e+01), SC_(8.6870783567428588867187500000000000000000e-01), SC_(2.4412901648332526815424870879822980920228e-46) }},
{{ SC_(5.1859493255615234375000000000000000000000e+01), SC_(9.3605506896972656250000000000000000000000e+01), SC_(6.2347322702407836914062500000000000000000e-01), SC_(6.2163281646698500831543954588688963876478e-09) }},
{{ SC_(5.2113578796386718750000000000000000000000e+01), SC_(1.8990549087524414062500000000000000000000e+01), SC_(4.8981541395187377929687500000000000000000e-01), SC_(9.7656090760999989512798396605852317841095e-04) }},
{{ SC_(5.2164985656738281250000000000000000000000e+01), SC_(6.6711410522460937500000000000000000000000e+01), SC_(6.0202175378799438476562500000000000000000e-01), SC_(1.4492533578454786733040614482550518923704e-02) }},
{{ SC_(5.2687583923339843750000000000000000000000e+01), SC_(9.0893653869628906250000000000000000000000e+01), SC_(6.5551233291625976562500000000000000000000e-01), SC_(1.8358769927593297588782991594388793216997e-10) }},
{{ SC_(5.2714275360107421875000000000000000000000e+01), SC_(1.3080546379089355468750000000000000000000e+01), SC_(8.5446554422378540039062500000000000000000e-01), SC_(5.1917694546421905283245568134386492802121e+00) }},
{{ SC_(5.2853317260742187500000000000000000000000e+01), SC_(6.2036003112792968750000000000000000000000e+01), SC_(2.1038085222244262695312500000000000000000e-01), SC_(2.4416013730587238734112699759586823796454e-07) }},
{{ SC_(5.3079753875732421875000000000000000000000e+01), SC_(5.9282386779785156250000000000000000000000e+01), SC_(1.8695391714572906494140625000000000000000e-01), SC_(8.0715289619807188891811623451403765335211e-10) }},
{{ SC_(5.3086429595947265625000000000000000000000e+01), SC_(6.3111991882324218750000000000000000000000e+01), SC_(8.1764596700668334960937500000000000000000e-01), SC_(4.5801308675425737773932545674928118185710e-16) }},
{{ SC_(5.3133392333984375000000000000000000000000e+01), SC_(7.4860916137695312500000000000000000000000e+01), SC_(8.2347303628921508789062500000000000000000e-01), SC_(1.1037188732829501690600442045109924480099e-22) }},
{{ SC_(5.3282558441162109375000000000000000000000e+01), SC_(9.4892509460449218750000000000000000000000e+01), SC_(3.9984267950057983398437500000000000000000e-01), SC_(5.8411542134136956155138479730063575626883e+00) }},
{{ SC_(5.3834239959716796875000000000000000000000e+01), SC_(5.4659194946289062500000000000000000000000e+01), SC_(2.3485642671585083007812500000000000000000e-01), SC_(3.1156569954450478325128700036518351133046e-07) }},
{{ SC_(5.3912647247314453125000000000000000000000e+01), SC_(2.4272365570068359375000000000000000000000e+01), SC_(7.2586637735366821289062500000000000000000e-01), SC_(6.3470709653489012980689728859427054681734e+00) }},
{{ SC_(5.4659313201904296875000000000000000000000e+01), SC_(9.8075675964355468750000000000000000000000e+01), SC_(9.5974802970886230468750000000000000000000e-01), SC_(1.7166214725308320564881080521677665970160e-93) }},
{{ SC_(5.4680572509765625000000000000000000000000e+01), SC_(2.2655132293701171875000000000000000000000e+01), SC_(4.8930370807647705078125000000000000000000e-01), SC_(3.3889636307954371726695737743027305818964e-03) }},
{{ SC_(5.4688148498535156250000000000000000000000e+01), SC_(9.9288131713867187500000000000000000000000e+01), SC_(1.6618931666016578674316406250000000000000e-02), SC_(4.2809512541910687109304803439374301532883e-53) }},
{{ SC_(5.4700885772705078125000000000000000000000e+01), SC_(7.1847000122070312500000000000000000000000e+01), SC_(3.5470265150070190429687500000000000000000e-01), SC_(1.9238636091431312937289421525763986257500e+00) }},
{{ SC_(5.4721553802490234375000000000000000000000e+01), SC_(1.5805758476257324218750000000000000000000e+01), SC_(1.4022982120513916015625000000000000000000e-01), SC_(4.3148047064147335679786530820054381281175e-31) }},
{{ SC_(5.4787086486816406250000000000000000000000e+01), SC_(5.9836887359619140625000000000000000000000e+01), SC_(7.0735079050064086914062500000000000000000e-01), SC_(1.9902692237091654472918485245014478229829e-05) }},
{{ SC_(5.4972362518310546875000000000000000000000e+01), SC_(7.3279869079589843750000000000000000000000e+01), SC_(1.6907313466072082519531250000000000000000e-01), SC_(8.1338073538530084941971385645780818088502e-10) }},
{{ SC_(5.4986019134521484375000000000000000000000e+01), SC_(8.0939120054244995117187500000000000000000e-01), SC_(2.6599407196044921875000000000000000000000e-01), SC_(2.1014327930922678170836759170753682649739e-30) }},
{{ SC_(5.5015636444091796875000000000000000000000e+01), SC_(3.8861515045166015625000000000000000000000e+01), SC_(4.0504088997840881347656250000000000000000e-01), SC_(1.5566069564376157615595618015939269302656e-02) }},
{{ SC_(5.6119979858398437500000000000000000000000e+01), SC_(1.3156156539916992187500000000000000000000e+01), SC_(7.4471831321716308593750000000000000000000e-01), SC_(2.9672827505285656357412689997633247875475e+00) }},
{{ SC_(5.6782161712646484375000000000000000000000e+01), SC_(5.2737148284912109375000000000000000000000e+01), SC_(1.8359279632568359375000000000000000000000e-01), SC_(4.2960642143009112473380992027629109237763e-13) }},
{{ SC_(5.6882362365722656250000000000000000000000e+01), SC_(3.9490821838378906250000000000000000000000e+01), SC_(1.9484481215476989746093750000000000000000e-01), SC_(1.9625142154572974392326819661946048282674e-15) }},
{{ SC_(5.7520858764648437500000000000000000000000e+01), SC_(7.5750366210937500000000000000000000000000e+01), SC_(3.4028568863868713378906250000000000000000e-01), SC_(9.3105555583338499668757161283597620625209e-01) }},
{{ SC_(5.7620937347412109375000000000000000000000e+01), SC_(9.2487594604492187500000000000000000000000e+01), SC_(9.5929545164108276367187500000000000000000e-01), SC_(3.6758750138148928681593305568190401633003e-85) }},
{{ SC_(5.7672149658203125000000000000000000000000e+01), SC_(5.1451957702636718750000000000000000000000e+01), SC_(5.6160134077072143554687500000000000000000e-01), SC_(6.6204237792430799171968827708182679348514e+00) }},
{{ SC_(5.7852508544921875000000000000000000000000e+01), SC_(2.8162733078002929687500000000000000000000e+01), SC_(4.8684296011924743652343750000000000000000e-01), SC_(1.6459583365473918750808952154018613185614e-02) }},
{{ SC_(5.7970458984375000000000000000000000000000e+01), SC_(6.2738437652587890625000000000000000000000e+01), SC_(2.6387652754783630371093750000000000000000e-01), SC_(2.8726240156792687704275894661427950309918e-05) }},
{{ SC_(5.8298637390136718750000000000000000000000e+01), SC_(7.4733123779296875000000000000000000000000e+01), SC_(7.7891981601715087890625000000000000000000e-01), SC_(2.6093345226386055333363912919033144320486e-15) }},
{{ SC_(5.8406932830810546875000000000000000000000e+01), SC_(9.0710861206054687500000000000000000000000e+01), SC_(7.9430508613586425781250000000000000000000e-01), SC_(2.3982644690684666407388050763468492752484e-24) }},
{{ SC_(5.8526409149169921875000000000000000000000e+01), SC_(5.9450359344482421875000000000000000000000e+01), SC_(1.6763903200626373291015625000000000000000e-01), SC_(3.7247512338962787709397634323269714489977e-14) }},
{{ SC_(5.8526771545410156250000000000000000000000e+01), SC_(8.0817550659179687500000000000000000000000e+01), SC_(1.2999321520328521728515625000000000000000e-01), SC_(5.4228153884422672329926904818908154762233e-15) }},
{{ SC_(5.8704471588134765625000000000000000000000e+01), SC_(4.7663806915283203125000000000000000000000e+01), SC_(4.0879029035568237304687500000000000000000e-01), SC_(1.0258476279909512002145224184094124186129e-01) }},
{{ SC_(5.8950744628906250000000000000000000000000e+01), SC_(2.3476560592651367187500000000000000000000e+01), SC_(7.7393972873687744140625000000000000000000e-01), SC_(4.3105243275967862990986331989835816893709e+00) }},
{{ SC_(5.9435623168945312500000000000000000000000e+01), SC_(5.8676498413085937500000000000000000000000e+01), SC_(7.9812604188919067382812500000000000000000e-01), SC_(1.2197812490920156922568629847535636741361e-10) }},
{{ SC_(5.9489608764648437500000000000000000000000e+01), SC_(4.4955608367919921875000000000000000000000e+01), SC_(4.4763964414596557617187500000000000000000e-01), SC_(3.6035697168947685030424147461324884203329e-01) }},
{{ SC_(5.9852367401123046875000000000000000000000e+01), SC_(9.7475440979003906250000000000000000000000e+01), SC_(8.0915629863739013671875000000000000000000e-01), SC_(9.1822181838654136557420348434357595100186e-30) }},
{{ SC_(6.0198192596435546875000000000000000000000e+01), SC_(4.7195678710937500000000000000000000000000e+01), SC_(2.1385136246681213378906250000000000000000e-01), SC_(6.5137790221283405579369403168060205258231e-13) }},
{{ SC_(6.0217048645019531250000000000000000000000e+01), SC_(7.1188079833984375000000000000000000000000e+01), SC_(9.1057389974594116210937500000000000000000e-01), SC_(5.1362243541619879379749649849157937682061e-37) }},
{{ SC_(6.0284309387207031250000000000000000000000e+01), SC_(7.9736412048339843750000000000000000000000e+01), SC_(4.5059654116630554199218750000000000000000e-01), SC_(8.4083360036507965560896404654170835306410e+00) }},
{{ SC_(6.0730392456054687500000000000000000000000e+01), SC_(1.2427266120910644531250000000000000000000e+01), SC_(9.8111158609390258789062500000000000000000e-01), SC_(2.4516343002817252175371211443449945282723e-06) }},
{{ SC_(6.0738922119140625000000000000000000000000e+01), SC_(2.8369390487670898437500000000000000000000e+01), SC_(9.4008004665374755859375000000000000000000e-01), SC_(2.4774305044740991159246202216867217329213e-11) }},
{{ SC_(6.0986663818359375000000000000000000000000e+01), SC_(9.3425056457519531250000000000000000000000e+01), SC_(5.4990518093109130859375000000000000000000e-01), SC_(5.6587739820336499703649900235277999664558e-03) }},
{{ SC_(6.1095863342285156250000000000000000000000e+01), SC_(7.8842372894287109375000000000000000000000e+00), SC_(8.3084553480148315429687500000000000000000e-01), SC_(3.2828869618202828461568781020653413853553e+00) }},
{{ SC_(6.1346073150634765625000000000000000000000e+01), SC_(3.1223007202148437500000000000000000000000e+01), SC_(9.9646168947219848632812500000000000000000e-01), SC_(6.0262473797339706889363941201511803570354e-49) }},
{{ SC_(6.1604469299316406250000000000000000000000e+01), SC_(7.7889770507812500000000000000000000000000e+01), SC_(1.6241228580474853515625000000000000000000e-01), SC_(1.5429040702294308522157943371333264041995e-12) }},
{{ SC_(6.1709087371826171875000000000000000000000e+01), SC_(4.7276912689208984375000000000000000000000e+01), SC_(7.8024941682815551757812500000000000000000e-01), SC_(5.1248774447598528962370261716654057563596e-05) }},
{{ SC_(6.1766635894775390625000000000000000000000e+01), SC_(4.7252525329589843750000000000000000000000e+01), SC_(5.5020135641098022460937500000000000000000e-01), SC_(7.8434536557883965414511731640806674842589e+00) }},
{{ SC_(6.2205513000488281250000000000000000000000e+01), SC_(4.3866683959960937500000000000000000000000e+01), SC_(2.7699527144432067871093750000000000000000e-01), SC_(2.4102479480807732678390617589589418823965e-09) }},
{{ SC_(6.2247509002685546875000000000000000000000e+01), SC_(7.7968940734863281250000000000000000000000e+01), SC_(4.0877896547317504882812500000000000000000e-01), SC_(6.7919636096178850005353524656944260986942e+00) }},
{{ SC_(6.2406009674072265625000000000000000000000e+01), SC_(1.7015228271484375000000000000000000000000e+01), SC_(4.9091500043869018554687500000000000000000e-01), SC_(2.5778093330327695361719923436119162730671e-06) }},
{{ SC_(6.2561859130859375000000000000000000000000e+01), SC_(8.1576904296875000000000000000000000000000e+01), SC_(3.7856256961822509765625000000000000000000e-01), SC_(3.9851725355569265114431585197860993218832e+00) }},
{{ SC_(6.2797336578369140625000000000000000000000e+01), SC_(5.1502372741699218750000000000000000000000e+01), SC_(6.6015344858169555664062500000000000000000e-01), SC_(4.7194560087390958471621567758644318043707e-01) }},
{{ SC_(6.3235927581787109375000000000000000000000e+01), SC_(3.0816703796386718750000000000000000000000e+01), SC_(1.2000879272818565368652343750000000000000e-02), SC_(2.4835020384665058547465638451995486142225e-94) }},
{{ SC_(6.3578670501708984375000000000000000000000e+01), SC_(7.7779403686523437500000000000000000000000e+01), SC_(9.6864354610443115234375000000000000000000e-01), SC_(1.9852507706699521057479887868495587271446e-74) }},
{{ SC_(6.3770908355712890625000000000000000000000e+01), SC_(2.6817638397216796875000000000000000000000e+01), SC_(8.7019973993301391601562500000000000000000e-01), SC_(2.8392967409377034323364513092965235964640e-03) }},
{{ SC_(6.3853073120117187500000000000000000000000e+01), SC_(6.3336330413818359375000000000000000000000e+01), SC_(8.1430339813232421875000000000000000000000e-01), SC_(2.8260596065208773495205822343226573348128e-13) }},
{{ SC_(6.4431808471679687500000000000000000000000e+01), SC_(5.4380546569824218750000000000000000000000e+01), SC_(3.9365050196647644042968750000000000000000e-01), SC_(4.3134981396827993055855962847702533468033e-02) }},
{{ SC_(6.4444282531738281250000000000000000000000e+01), SC_(9.4971458435058593750000000000000000000000e+01), SC_(9.6489202976226806640625000000000000000000e-01), SC_(2.6846463652851937052535875166408627829006e-91) }},
{{ SC_(6.4476455688476562500000000000000000000000e+01), SC_(2.3367544174194335937500000000000000000000e+01), SC_(7.5776433944702148437500000000000000000000e-01), SC_(7.8538497452429594303473069384888257059591e+00) }},
{{ SC_(6.4631301879882812500000000000000000000000e+01), SC_(7.9397499084472656250000000000000000000000e+01), SC_(1.1129163205623626708984375000000000000000e-01), SC_(5.1492929970111896929192693621811485111252e-22) }},
{{ SC_(6.4761764526367187500000000000000000000000e+01), SC_(9.3452194213867187500000000000000000000000e+01), SC_(9.6496987342834472656250000000000000000000e-01), SC_(2.1166806363953016081493588840091731210567e-89) }},
{{ SC_(6.4774597167968750000000000000000000000000e+01), SC_(4.9332683563232421875000000000000000000000e+01), SC_(3.5282713174819946289062500000000000000000e-01), SC_(1.6987925212782495378960683806546306885975e-04) }},
{{ SC_(6.4899147033691406250000000000000000000000e+01), SC_(6.4318099975585937500000000000000000000000e+01), SC_(6.2742161750793457031250000000000000000000e-01), SC_(1.4687078478756282191630637118161405542254e-01) }},
{{ SC_(6.4911552429199218750000000000000000000000e+01), SC_(2.5829589843750000000000000000000000000000e+01), SC_(3.5101729631423950195312500000000000000000e-01), SC_(1.1222146477651588499595599198255946484190e-10) }},
{{ SC_(6.5375732421875000000000000000000000000000e+01), SC_(1.5979039669036865234375000000000000000000e-01), SC_(5.2988898754119873046875000000000000000000e-01), SC_(1.1076153185154592815568000474989150808110e-18) }},
{{ SC_(6.5407905578613281250000000000000000000000e+01), SC_(5.2984195709228515625000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.8458109412624349861263218679006465846276e-13) }},
{{ SC_(6.5444572448730468750000000000000000000000e+01), SC_(9.9450538635253906250000000000000000000000e+01), SC_(8.2085871696472167968750000000000000000000e-01), SC_(2.8488506065700944652223084673754938418091e-31) }},
{{ SC_(6.5509803771972656250000000000000000000000e+01), SC_(7.1070388793945312500000000000000000000000e+01), SC_(1.1963522434234619140625000000000000000000e-01), SC_(1.1677208399724747453768915692675958809747e-22) }},
{{ SC_(6.5547790527343750000000000000000000000000e+01), SC_(1.7386516571044921875000000000000000000000e+01), SC_(6.7688621580600738525390625000000000000000e-02), SC_(4.7409102396470046127741189162461359596635e-58) }},
{{ SC_(6.5574066162109375000000000000000000000000e+01), SC_(7.9792861938476562500000000000000000000000e+01), SC_(4.5155037194490432739257812500000000000000e-02), SC_(2.4173979685235959525347106388227000949968e-45) }},
{{ SC_(6.5685989379882812500000000000000000000000e+01), SC_(1.8081871032714843750000000000000000000000e+01), SC_(6.5581434965133666992187500000000000000000e-01), SC_(2.4362860140459116110220007659765934453206e-01) }},
{{ SC_(6.5960525512695312500000000000000000000000e+01), SC_(4.2221839904785156250000000000000000000000e+01), SC_(6.2251281738281250000000000000000000000000e-01), SC_(8.2760038848666958924299202976572360283515e+00) }},
{{ SC_(6.6194473266601562500000000000000000000000e+01), SC_(6.6230026245117187500000000000000000000000e+01), SC_(9.8746085166931152343750000000000000000000e-01), SC_(6.5537522588613732931774646923749769413727e-85) }},
{{ SC_(6.6200958251953125000000000000000000000000e+01), SC_(2.0595558166503906250000000000000000000000e+01), SC_(9.9011099338531494140625000000000000000000e-01), SC_(1.9229145442842604263978227908485621979254e-19) }},
{{ SC_(6.6633888244628906250000000000000000000000e+01), SC_(7.3779083251953125000000000000000000000000e+01), SC_(7.2052139043807983398437500000000000000000e-01), SC_(8.4011845409645852059788202137101169561265e-08) }},
{{ SC_(6.6652793884277343750000000000000000000000e+01), SC_(1.8547597885131835937500000000000000000000e+01), SC_(7.2698199748992919921875000000000000000000e-01), SC_(3.8276003824171396703179218303305273747214e+00) }},
{{ SC_(6.6783271789550781250000000000000000000000e+01), SC_(3.0382526397705078125000000000000000000000e+01), SC_(9.0019315481185913085937500000000000000000e-01), SC_(1.1574020787709240034900051501803704613060e-06) }},
{{ SC_(6.6917533874511718750000000000000000000000e+01), SC_(8.3144456148147583007812500000000000000000e-01), SC_(7.4996602535247802734375000000000000000000e-01), SC_(2.1308711109671379808858742179157009251629e-07) }},
{{ SC_(6.7180816650390625000000000000000000000000e+01), SC_(6.1374412536621093750000000000000000000000e+01), SC_(8.7844282388687133789062500000000000000000e-01), SC_(1.0333018926471982798126709236886096803277e-20) }},
{{ SC_(6.7533203125000000000000000000000000000000e+01), SC_(5.1010887145996093750000000000000000000000e+01), SC_(9.0737396478652954101562500000000000000000e-01), SC_(1.0766011284765837097498046911459768154073e-19) }},
{{ SC_(6.7612228393554687500000000000000000000000e+01), SC_(4.7471839904785156250000000000000000000000e+01), SC_(8.7676978111267089843750000000000000000000e-01), SC_(1.3693423590309519493815865934521856894880e-12) }},
{{ SC_(6.7873512268066406250000000000000000000000e+01), SC_(3.9873851776123046875000000000000000000000e+01), SC_(5.1311306655406951904296875000000000000000e-02), SC_(9.8820482752710265825158891425168047315910e-57) }},
{{ SC_(6.7901679992675781250000000000000000000000e+01), SC_(8.3242708444595336914062500000000000000000e-01), SC_(9.6769815683364868164062500000000000000000e-01), SC_(5.8517806361571553840406595329056261480712e+00) }},
{{ SC_(6.7913558959960937500000000000000000000000e+01), SC_(2.9905181884765625000000000000000000000000e+01), SC_(4.9249273538589477539062500000000000000000e-01), SC_(2.0641425848930869927810591061075318314562e-03) }},
{{ SC_(6.7970268249511718750000000000000000000000e+01), SC_(2.8184324502944946289062500000000000000000e-01), SC_(1.1908578127622604370117187500000000000000e-01), SC_(1.4487300945971068576484247912755461435601e-62) }},
{{ SC_(6.7972793579101562500000000000000000000000e+01), SC_(2.9196077346801757812500000000000000000000e+01), SC_(5.1082050800323486328125000000000000000000e-01), SC_(5.6992712594883018537303287123865430060058e-03) }},
{{ SC_(6.8197189331054687500000000000000000000000e+01), SC_(5.3472103118896484375000000000000000000000e+01), SC_(5.9286457300186157226562500000000000000000e-01), SC_(6.9495869658948972221309212685610795627087e+00) }},
{{ SC_(6.8336326599121093750000000000000000000000e+01), SC_(9.1371955871582031250000000000000000000000e+01), SC_(9.5949649810791015625000000000000000000000e-01), SC_(4.9716931525707044173239436711601967496841e-80) }},
{{ SC_(6.8677543640136718750000000000000000000000e+01), SC_(3.1250799179077148437500000000000000000000e+01), SC_(3.6325013637542724609375000000000000000000e-01), SC_(3.4145717238362445264422395745032371710109e-09) }},
{{ SC_(6.8921455383300781250000000000000000000000e+01), SC_(7.1610069274902343750000000000000000000000e+01), SC_(2.2182455658912658691406250000000000000000e-01), SC_(3.5887769450233290077919323819214433660736e-10) }},
{{ SC_(6.9482864379882812500000000000000000000000e+01), SC_(1.2518276214599609375000000000000000000000e+01), SC_(8.5607238113880157470703125000000000000000e-02), SC_(5.9624870386178091538350285638123918676325e-59) }},
{{ SC_(6.9514045715332031250000000000000000000000e+01), SC_(4.9061920166015625000000000000000000000000e+01), SC_(8.8600951433181762695312500000000000000000e-01), SC_(2.1111581835300708449156669616105689152990e-14) }},
{{ SC_(6.9594932556152343750000000000000000000000e+01), SC_(6.3450199127197265625000000000000000000000e+01), SC_(8.1159931421279907226562500000000000000000e-01), SC_(7.2373551759797708694404454255728630941698e-12) }},
{{ SC_(6.9810554504394531250000000000000000000000e+01), SC_(8.2285919189453125000000000000000000000000e+01), SC_(7.2668176889419555664062500000000000000000e-01), SC_(4.1688584087411983265592156514176831217047e-10) }},
{{ SC_(6.9874588012695312500000000000000000000000e+01), SC_(6.5445065498352050781250000000000000000000e+00), SC_(5.4410171508789062500000000000000000000000e-01), SC_(3.8862130664941318144811925648088494793438e-11) }},
{{ SC_(6.9907669067382812500000000000000000000000e+01), SC_(4.1266651153564453125000000000000000000000e+01), SC_(1.3615494966506958007812500000000000000000e-01), SC_(8.3561198926092010196985243975253024830862e-31) }},
{{ SC_(6.9988784790039062500000000000000000000000e+01), SC_(7.2180256843566894531250000000000000000000e+00), SC_(8.1189280748367309570312500000000000000000e-01), SC_(4.5802486847014742629964559325198837413484e-01) }},
{{ SC_(7.0109870910644531250000000000000000000000e+01), SC_(1.2064892768859863281250000000000000000000e+01), SC_(7.1849811077117919921875000000000000000000e-01), SC_(9.4985634533683975505338921902996883722683e-02) }},
{{ SC_(7.0604614257812500000000000000000000000000e+01), SC_(7.9727989196777343750000000000000000000000e+01), SC_(7.6059088110923767089843750000000000000000e-02), SC_(8.6974225962894644567443392186319287646160e-36) }},
{{ SC_(7.0928169250488281250000000000000000000000e+01), SC_(6.4978073120117187500000000000000000000000e+01), SC_(9.7700434923171997070312500000000000000000e-01), SC_(4.9577240201593676123651630600108755076860e-65) }},
{{ SC_(7.0936485290527343750000000000000000000000e+01), SC_(9.2087478637695312500000000000000000000000e+01), SC_(1.1255326867103576660156250000000000000000e-01), SC_(6.4699885039317633558749137747799008295644e-23) }},
{{ SC_(7.1121582031250000000000000000000000000000e+01), SC_(1.6755578994750976562500000000000000000000e+01), SC_(4.5097860693931579589843750000000000000000e-01), SC_(2.5367454425104677784017403032623016050121e-10) }},
{{ SC_(7.1269447326660156250000000000000000000000e+01), SC_(7.4690422058105468750000000000000000000000e+01), SC_(5.8442378044128417968750000000000000000000e-01), SC_(6.4316842200001480492569842945346949793307e-01) }},
{{ SC_(7.1503707885742187500000000000000000000000e+01), SC_(9.8699045181274414062500000000000000000000e+00), SC_(5.3397971391677856445312500000000000000000e-01), SC_(9.3829522052572085209386678304640412235138e-10) }},
{{ SC_(7.1835891723632812500000000000000000000000e+01), SC_(2.4557474136352539062500000000000000000000e+01), SC_(8.2192111015319824218750000000000000000000e-01), SC_(2.0018051715134284117283245168456021709502e+00) }},
{{ SC_(7.2122749328613281250000000000000000000000e+01), SC_(2.3076438903808593750000000000000000000000e+01), SC_(5.2741873264312744140625000000000000000000e-01), SC_(1.4824498638585456840462002693980535992674e-04) }},
{{ SC_(7.2175804138183593750000000000000000000000e+01), SC_(4.0750190734863281250000000000000000000000e+01), SC_(9.2939299345016479492187500000000000000000e-01), SC_(2.2674994519327513431358832091386827481630e-16) }},
{{ SC_(7.2243957519531250000000000000000000000000e+01), SC_(7.0472373962402343750000000000000000000000e+01), SC_(6.2039798498153686523437500000000000000000e-01), SC_(2.1747725630513805191968567331981073239265e-01) }},
{{ SC_(7.3024879455566406250000000000000000000000e+01), SC_(7.7290092468261718750000000000000000000000e+01), SC_(7.9361820220947265625000000000000000000000e-01), SC_(1.2481610885007708513254875520262048695968e-14) }},
{{ SC_(7.3033088684082031250000000000000000000000e+01), SC_(1.0073848724365234375000000000000000000000e+01), SC_(4.7669041156768798828125000000000000000000e-01), SC_(4.6964603668866666150077666926265191543460e-13) }},
{{ SC_(7.3172241210937500000000000000000000000000e+01), SC_(1.2984652519226074218750000000000000000000e+01), SC_(3.5172432661056518554687500000000000000000e-01), SC_(9.4271168268578054219136337813916640307999e-20) }},
{{ SC_(7.3785812377929687500000000000000000000000e+01), SC_(1.6669826507568359375000000000000000000000e+01), SC_(6.9910681247711181640625000000000000000000e-01), SC_(2.8088716047723836146747649688070448066271e-01) }},
{{ SC_(7.3842689514160156250000000000000000000000e+01), SC_(7.5592468261718750000000000000000000000000e+01), SC_(9.4479274749755859375000000000000000000000e-01), SC_(5.3975955225615551761942085179967110563720e-51) }},
{{ SC_(7.4313247680664062500000000000000000000000e+01), SC_(4.7475868225097656250000000000000000000000e+01), SC_(5.4044723510742187500000000000000000000000e-02), SC_(4.6872031932512894108846858118357469855550e-59) }},
{{ SC_(7.4407424926757812500000000000000000000000e+01), SC_(6.8980125427246093750000000000000000000000e+01), SC_(5.4705417156219482421875000000000000000000e-01), SC_(7.6535757124896259807826578386298316642325e+00) }},
{{ SC_(7.4469284057617187500000000000000000000000e+01), SC_(6.2343555450439453125000000000000000000000e+01), SC_(3.6092463135719299316406250000000000000000e-01), SC_(7.4491023250125869288251689669226648862451e-04) }},
{{ SC_(7.4815162658691406250000000000000000000000e+01), SC_(9.8837944030761718750000000000000000000000e+01), SC_(2.2349761426448822021484375000000000000000e-01), SC_(1.5275367994117251780587832426189296523236e-07) }},
{{ SC_(7.5126708984375000000000000000000000000000e+01), SC_(8.2124595642089843750000000000000000000000e+01), SC_(1.3308273255825042724609375000000000000000e-01), SC_(5.1198335805402858538596874026995054633637e-23) }},
{{ SC_(7.5372909545898437500000000000000000000000e+01), SC_(5.6155746459960937500000000000000000000000e+01), SC_(1.8165481090545654296875000000000000000000e-01), SC_(2.7671308152776185391001243422470972609985e-21) }},
{{ SC_(7.5468666076660156250000000000000000000000e+01), SC_(8.0753097534179687500000000000000000000000e+01), SC_(1.1328122019767761230468750000000000000000e-01), SC_(6.0895596504515786798822977566447704469869e-28) }},
{{ SC_(7.5720024108886718750000000000000000000000e+01), SC_(3.9232044219970703125000000000000000000000e+01), SC_(1.7394778132438659667968750000000000000000e-01), SC_(2.6429732243514617076144842498025562957578e-28) }},
{{ SC_(7.5774017333984375000000000000000000000000e+01), SC_(7.4064727783203125000000000000000000000000e+01), SC_(5.3247254341840744018554687500000000000000e-02), SC_(3.2547646365757536865638895866749092386292e-52) }},
{{ SC_(7.6550003051757812500000000000000000000000e+01), SC_(1.4891699552536010742187500000000000000000e+00), SC_(9.5502203702926635742187500000000000000000e-01), SC_(4.9121847179113264600825589308331833261966e+00) }},
{{ SC_(7.6551681518554687500000000000000000000000e+01), SC_(5.1216425895690917968750000000000000000000e+00), SC_(1.0082841664552688598632812500000000000000e-01), SC_(5.9695492346715607392929903148333146128729e-68) }},
{{ SC_(7.7015975952148437500000000000000000000000e+01), SC_(9.7094413757324218750000000000000000000000e+01), SC_(9.1720193624496459960937500000000000000000e-01), SC_(3.1608781254343798369088749239894863747534e-55) }},
{{ SC_(7.7028549194335937500000000000000000000000e+01), SC_(7.0825759887695312500000000000000000000000e+01), SC_(9.8838055133819580078125000000000000000000e-01), SC_(2.2384137594034738839446116472328757114741e-91) }},
{{ SC_(7.7491043090820312500000000000000000000000e+01), SC_(9.7700202941894531250000000000000000000000e+01), SC_(2.4360062181949615478515625000000000000000e-01), SC_(1.0236987475627469426421206616988346030813e-06) }},
{{ SC_(7.7571266174316406250000000000000000000000e+01), SC_(3.0361396789550781250000000000000000000000e+01), SC_(3.8162028789520263671875000000000000000000e-01), SC_(9.0517323228622996745607507623620471580426e-11) }},
{{ SC_(7.7880218505859375000000000000000000000000e+01), SC_(4.5893627166748046875000000000000000000000e+01), SC_(8.3123117685317993164062500000000000000000e-01), SC_(8.1824921990359636646940635653187489672052e-06) }},
{{ SC_(7.7905174255371093750000000000000000000000e+01), SC_(2.8658658981323242187500000000000000000000e+01), SC_(5.3287231922149658203125000000000000000000e-01), SC_(1.0892862729571705956304871869416474541917e-03) }},
{{ SC_(7.7916725158691406250000000000000000000000e+01), SC_(3.5634513854980468750000000000000000000000e+01), SC_(1.8846313655376434326171875000000000000000e-01), SC_(1.2172529386027125131929113415582225567820e-28) }},
{{ SC_(7.8022743225097656250000000000000000000000e+01), SC_(6.6928512573242187500000000000000000000000e+01), SC_(3.7867152690887451171875000000000000000000e-01), SC_(5.2381824222379070594694549209013762637158e-03) }},
{{ SC_(7.8025207519531250000000000000000000000000e+01), SC_(8.7736389160156250000000000000000000000000e+01), SC_(3.1661877036094665527343750000000000000000e-01), SC_(2.3540705053854639244284420625882839319229e-03) }},
{{ SC_(7.8051963806152343750000000000000000000000e+01), SC_(4.4895187377929687500000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.0641667391983286104728643302533685519616e-13) }},
{{ SC_(7.8473930358886718750000000000000000000000e+01), SC_(2.1510904312133789062500000000000000000000e+01), SC_(9.2338734865188598632812500000000000000000e-01), SC_(1.8065289589911113135404449390446310525580e-03) }},
{{ SC_(7.9220733642578125000000000000000000000000e+01), SC_(8.7843063354492187500000000000000000000000e+01), SC_(4.2149920016527175903320312500000000000000e-02), SC_(2.5765778125138012332134496703813616609758e-59) }},
{{ SC_(7.9428451538085937500000000000000000000000e+01), SC_(4.3611755371093750000000000000000000000000e+01), SC_(2.0814725756645202636718750000000000000000e-01), SC_(1.9421729093463205662729775038788966092279e-23) }},
{{ SC_(7.9483139038085937500000000000000000000000e+01), SC_(9.1711791992187500000000000000000000000000e+01), SC_(3.9238122105598449707031250000000000000000e-01), SC_(1.7603006881168363110062143679562903556089e+00) }},
{{ SC_(7.9519996643066406250000000000000000000000e+01), SC_(3.6441252231597900390625000000000000000000e+00), SC_(1.0674210637807846069335937500000000000000e-01), SC_(8.6051208478502405547006045913562173578661e-71) }},
{{ SC_(7.9618385314941406250000000000000000000000e+01), SC_(5.8284641265869140625000000000000000000000e+01), SC_(5.0554800033569335937500000000000000000000e-01), SC_(2.2145295880742629476970337135629356638327e+00) }},
{{ SC_(8.0006851196289062500000000000000000000000e+01), SC_(6.6011947631835937500000000000000000000000e+01), SC_(2.5516960024833679199218750000000000000000e-01), SC_(7.2657317319521319987033147957870643016396e-12) }},
{{ SC_(8.0028045654296875000000000000000000000000e+01), SC_(2.9702943801879882812500000000000000000000e+01), SC_(3.4542635083198547363281250000000000000000e-02), SC_(1.4009629433947858874133970581943583856833e-88) }},
{{ SC_(8.0033058166503906250000000000000000000000e+01), SC_(4.7273212432861328125000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(9.2997657791728824476233841255314794081444e+00) }},
{{ SC_(8.0101463317871093750000000000000000000000e+01), SC_(7.6293144226074218750000000000000000000000e+01), SC_(4.7306776046752929687500000000000000000000e-01), SC_(6.1872763331841809398618911685797588225235e+00) }},
{{ SC_(8.0336441040039062500000000000000000000000e+01), SC_(3.9698181152343750000000000000000000000000e+01), SC_(6.5200346708297729492187500000000000000000e-01), SC_(8.3494920544684245892730421655378821097974e+00) }},
{{ SC_(8.0548942565917968750000000000000000000000e+01), SC_(4.8840187072753906250000000000000000000000e+01), SC_(5.5831295251846313476562500000000000000000e-01), SC_(2.9743312557571137178663567681196506071362e+00) }},
{{ SC_(8.1158050537109375000000000000000000000000e+01), SC_(1.9987287521362304687500000000000000000000e+01), SC_(3.9879864454269409179687500000000000000000e-01), SC_(6.8820477121972114432554905022550902968418e-15) }},
{{ SC_(8.1428482055664062500000000000000000000000e+01), SC_(2.9983171463012695312500000000000000000000e+01), SC_(1.4937907457351684570312500000000000000000e-01), SC_(1.0038926847387451185705290913476764713291e-40) }},
{{ SC_(8.1472366333007812500000000000000000000000e+01), SC_(1.3547700881958007812500000000000000000000e+01), SC_(2.9181505087763071060180664062500000000000e-03), SC_(1.0701226692879219164869601837775782759316e-187) }},
{{ SC_(8.1730323791503906250000000000000000000000e+01), SC_(3.6318645477294921875000000000000000000000e+01), SC_(2.4421386420726776123046875000000000000000e-01), SC_(1.6711998938815448578211453992867685534121e-22) }},
{{ SC_(8.1754707336425781250000000000000000000000e+01), SC_(2.3188861846923828125000000000000000000000e+01), SC_(6.1608308553695678710937500000000000000000e-01), SC_(1.2158214935397156216696540650318026511939e-02) }},
{{ SC_(8.1762771606445312500000000000000000000000e+01), SC_(3.6086071014404296875000000000000000000000e+01), SC_(3.9228779077529907226562500000000000000000e-01), SC_(2.6148205695688057027257526696979179491274e-09) }},
{{ SC_(8.1776062011718750000000000000000000000000e+01), SC_(3.2673664093017578125000000000000000000000e+01), SC_(7.9738438129425048828125000000000000000000e-01), SC_(1.2798030911387809963992614817654126813206e+00) }},
{{ SC_(8.1814857482910156250000000000000000000000e+01), SC_(6.5524458885192871093750000000000000000000e+00), SC_(6.0427105426788330078125000000000000000000e-01), SC_(1.6318897198316535645103412075542824461294e-10) }},
{{ SC_(8.1998123168945312500000000000000000000000e+01), SC_(7.2445388793945312500000000000000000000000e+01), SC_(8.2126384973526000976562500000000000000000e-01), SC_(2.5336912767108652766176883008526393492793e-14) }},
{{ SC_(8.2119407653808593750000000000000000000000e+01), SC_(3.2251075744628906250000000000000000000000e+01), SC_(3.4439349174499511718750000000000000000000e-01), SC_(3.4922863502005477120609044600049269760390e-14) }},
{{ SC_(8.2345787048339843750000000000000000000000e+01), SC_(8.2190330505371093750000000000000000000000e+01), SC_(8.4527403116226196289062500000000000000000e-02), SC_(3.4623262515372063977497540029185665836016e-41) }},
{{ SC_(8.2437629699707031250000000000000000000000e+01), SC_(5.3209751129150390625000000000000000000000e+01), SC_(7.8193098306655883789062500000000000000000e-01), SC_(3.7894012087162019323268087264395037934832e-04) }},
{{ SC_(8.2531379699707031250000000000000000000000e+01), SC_(5.0591938018798828125000000000000000000000e+01), SC_(6.4399653673171997070312500000000000000000e-01), SC_(8.2370151022885160801509642168532799553863e+00) }},
{{ SC_(8.2581695556640625000000000000000000000000e+01), SC_(4.6247421264648437500000000000000000000000e+01), SC_(2.3056511580944061279296875000000000000000e-01), SC_(5.3317143225384131460737652827816567985406e-21) }},
{{ SC_(8.3082862854003906250000000000000000000000e+01), SC_(7.9359756469726562500000000000000000000000e+01), SC_(1.6573216021060943603515625000000000000000e-01), SC_(1.1122692647959433991572034285872405446914e-21) }},
{{ SC_(8.3137977600097656250000000000000000000000e+01), SC_(1.8908418655395507812500000000000000000000e+01), SC_(6.4915060997009277343750000000000000000000e-01), SC_(7.5127665207344919770939688035427980550110e-03) }},
{{ SC_(8.3291679382324218750000000000000000000000e+01), SC_(6.9262528419494628906250000000000000000000e+00), SC_(9.9406909942626953125000000000000000000000e-01), SC_(1.5840005120278626793175860827830050882039e-03) }},
{{ SC_(8.4071723937988281250000000000000000000000e+01), SC_(9.8852157592773437500000000000000000000000e+01), SC_(1.4791423082351684570312500000000000000000e-01), SC_(3.0471357920599268550579496336487184485679e-21) }},
{{ SC_(8.4192916870117187500000000000000000000000e+01), SC_(1.1192586421966552734375000000000000000000e+00), SC_(9.9353539943695068359375000000000000000000e-01), SC_(4.8403448105886963761235077905291313326728e+01) }},
{{ SC_(8.4430877685546875000000000000000000000000e+01), SC_(8.8599815368652343750000000000000000000000e+01), SC_(4.2214545607566833496093750000000000000000e-01), SC_(2.3503158576328961301014087229512282010392e+00) }},
{{ SC_(8.4439216613769531250000000000000000000000e+01), SC_(7.9010177612304687500000000000000000000000e+01), SC_(9.0272581577301025390625000000000000000000e-01), SC_(8.2186624302624795854193488927156784427652e-34) }},
{{ SC_(8.4912933349609375000000000000000000000000e+01), SC_(2.1192432403564453125000000000000000000000e+01), SC_(4.8039492219686508178710937500000000000000e-02), SC_(1.5592755026569287608226975912574159791670e-88) }},
{{ SC_(8.5303108215332031250000000000000000000000e+01), SC_(5.3393310546875000000000000000000000000000e+01), SC_(2.7609747648239135742187500000000000000000e-01), SC_(1.0702775588043855000590538311371113109087e-14) }},
{{ SC_(8.5552284240722656250000000000000000000000e+01), SC_(2.5282335281372070312500000000000000000000e+01), SC_(7.5752788782119750976562500000000000000000e-01), SC_(8.9763565585542429927086595217057943791382e+00) }},
{{ SC_(8.5944229125976562500000000000000000000000e+01), SC_(6.1091621398925781250000000000000000000000e+01), SC_(5.5292588472366333007812500000000000000000e-01), SC_(7.1441156422657831179211485019330553999494e+00) }},
{{ SC_(8.6869468688964843750000000000000000000000e+01), SC_(6.7951972961425781250000000000000000000000e+01), SC_(2.4792282283306121826171875000000000000000e-01), SC_(1.5824176870066665891259849548980369295992e-14) }},
{{ SC_(8.6929222106933593750000000000000000000000e+01), SC_(7.7557029724121093750000000000000000000000e+00), SC_(2.6304498314857482910156250000000000000000e-01), SC_(8.8055939603021198633967944963957077869246e-40) }},
{{ SC_(8.7537155151367187500000000000000000000000e+01), SC_(1.2038167953491210937500000000000000000000e+01), SC_(8.6269187927246093750000000000000000000000e-01), SC_(9.6754843208298534261348904324496355292255e+00) }},
{{ SC_(8.7594284057617187500000000000000000000000e+01), SC_(1.6520583629608154296875000000000000000000e+00), SC_(4.0426808595657348632812500000000000000000e-01), SC_(1.1231445136268581200070343689108513597652e-31) }},
{{ SC_(8.7965377807617187500000000000000000000000e+01), SC_(3.2669925689697265625000000000000000000000e+01), SC_(7.9730015993118286132812500000000000000000e-01), SC_(2.4035939533061130957300812428580482467362e+00) }},
{{ SC_(8.8186653137207031250000000000000000000000e+01), SC_(8.9952907562255859375000000000000000000000e+00), SC_(7.4817681312561035156250000000000000000000e-01), SC_(1.9788988156402239782374287926307579051035e-03) }},
{{ SC_(8.8516799926757812500000000000000000000000e+01), SC_(9.5922157287597656250000000000000000000000e+01), SC_(5.0371235609054565429687500000000000000000e-01), SC_(8.7756889071697534932123575040368828157339e+00) }},
{{ SC_(8.8651191711425781250000000000000000000000e+01), SC_(5.0236236572265625000000000000000000000000e+01), SC_(5.7379728555679321289062500000000000000000e-01), SC_(2.7754941621432523142380551649041510290887e+00) }},
{{ SC_(8.9090324401855468750000000000000000000000e+01), SC_(4.2316513061523437500000000000000000000000e+01), SC_(1.3808752596378326416015625000000000000000e-01), SC_(6.0242004066476170565831229547519281396874e-43) }},
{{ SC_(8.9092247009277343750000000000000000000000e+01), SC_(3.5534870147705078125000000000000000000000e+01), SC_(5.4018402099609375000000000000000000000000e-01), SC_(2.7594240751544251759328792574886828120401e-03) }},
{{ SC_(9.0005386352539062500000000000000000000000e+01), SC_(3.4383953094482421875000000000000000000000e+01), SC_(3.1117120385169982910156250000000000000000e-01), SC_(4.1249063387510756986049304274893846554731e-19) }},
{{ SC_(9.0271606445312500000000000000000000000000e+01), SC_(3.0182731628417968750000000000000000000000e+01), SC_(3.0189713835716247558593750000000000000000e-01), SC_(5.4747359197998070787832729462705715331608e-22) }},
{{ SC_(9.0372055053710937500000000000000000000000e+01), SC_(3.8475521087646484375000000000000000000000e+01), SC_(5.3838860988616943359375000000000000000000e-01), SC_(6.5777488268313690647312401785163211246905e-03) }},
{{ SC_(9.0472221374511718750000000000000000000000e+01), SC_(2.6447654724121093750000000000000000000000e+01), SC_(5.4976862668991088867187500000000000000000e-01), SC_(2.1736901957849623824264050603302808492280e-05) }},
{{ SC_(9.0488090515136718750000000000000000000000e+01), SC_(7.2665443420410156250000000000000000000000e+01), SC_(4.3880048394203186035156250000000000000000e-01), SC_(1.2616381139189838464657834140472614854950e-01) }},
{{ SC_(9.0579193115234375000000000000000000000000e+01), SC_(8.3500854492187500000000000000000000000000e+01), SC_(4.7337622381746768951416015625000000000000e-03), SC_(2.1723391745559527386433473147299327074233e-156) }},
{{ SC_(9.0630813598632812500000000000000000000000e+01), SC_(8.4808883666992187500000000000000000000000e+01), SC_(7.9522043466567993164062500000000000000000e-01), SC_(3.5649423215245792374405011332160230832898e-14) }},
{{ SC_(9.1064758300781250000000000000000000000000e+01), SC_(1.3299603462219238281250000000000000000000e+01), SC_(2.5813889503479003906250000000000000000000e-01), SC_(7.1571418848817411510071706797391778608129e-38) }},
{{ SC_(9.1328681945800781250000000000000000000000e+01), SC_(1.8066270351409912109375000000000000000000e+00), SC_(5.0482052564620971679687500000000000000000e-01), SC_(3.2668011878208295560081663306956401924691e-24) }},
{{ SC_(9.1333732604980468750000000000000000000000e+01), SC_(5.5826877593994140625000000000000000000000e+01), SC_(2.2905406355857849121093750000000000000000e-01), SC_(5.9923071336983634266285927568368247385693e-22) }},
{{ SC_(9.1337585449218750000000000000000000000000e+01), SC_(2.2103404998779296875000000000000000000000e+01), SC_(8.1931026652455329895019531250000000000000e-03), SC_(8.9527602299720584133014002377904013510044e-165) }},
{{ SC_(9.1573554992675781250000000000000000000000e+01), SC_(6.3976333618164062500000000000000000000000e+01), SC_(4.0567062795162200927734375000000000000000e-02), SC_(8.8951380352128378070508423350281556702890e-82) }},
{{ SC_(9.1599121093750000000000000000000000000000e+01), SC_(6.5521324157714843750000000000000000000000e+01), SC_(9.1258627176284790039062500000000000000000e-01), SC_(7.1635259936475851070669218751430165306657e-26) }},
{{ SC_(9.1719367980957031250000000000000000000000e+01), SC_(6.9523284912109375000000000000000000000000e+01), SC_(1.7079097032546997070312500000000000000000e-01), SC_(1.1704501405156758933577947983004764597931e-27) }},
{{ SC_(9.1742431640625000000000000000000000000000e+01), SC_(8.0176300048828125000000000000000000000000e+01), SC_(9.5022708177566528320312500000000000000000e-01), SC_(6.6108794598679262629431058171901316161529e-54) }},
{{ SC_(9.2033203125000000000000000000000000000000e+01), SC_(3.9246906280517578125000000000000000000000e+01), SC_(6.9485914707183837890625000000000000000000e-01), SC_(9.7293793382634092108753468274303389281230e+00) }},
{{ SC_(9.2337966918945312500000000000000000000000e+01), SC_(6.4455055236816406250000000000000000000000e+01), SC_(4.3591499328613281250000000000000000000000e-01), SC_(6.1947532068979857233942991078734599363266e-03) }},
{{ SC_(9.2885414123535156250000000000000000000000e+01), SC_(2.4413827896118164062500000000000000000000e+01), SC_(4.7481119632720947265625000000000000000000e-01), SC_(1.0632460621713978759553761211229516079979e-10) }},
{{ SC_(9.2926368713378906250000000000000000000000e+01), SC_(2.1723785400390625000000000000000000000000e+01), SC_(1.5452297031879425048828125000000000000000e-01), SC_(2.1413257713800732944221748368602415056544e-52) }},
{{ SC_(9.2938598632812500000000000000000000000000e+01), SC_(4.5849689483642578125000000000000000000000e+01), SC_(3.8050779700279235839843750000000000000000e-01), SC_(4.7424310990301854688895557923043968940536e-10) }},
{{ SC_(9.3399322509765625000000000000000000000000e+01), SC_(6.8135955810546875000000000000000000000000e+01), SC_(4.9749460071325302124023437500000000000000e-02), SC_(1.8183558571443092811277392449146138363927e-74) }},
{{ SC_(9.3401069641113281250000000000000000000000e+01), SC_(9.6496635437011718750000000000000000000000e+01), SC_(1.8903611600399017333984375000000000000000e-01), SC_(1.1333723070206938959921225347273399481907e-18) }},
{{ SC_(9.3900154113769531250000000000000000000000e+01), SC_(2.4007595062255859375000000000000000000000e+01), SC_(4.0397173166275024414062500000000000000000e-01), SC_(2.3867689411699371620121138796491004753951e-16) }},
{{ SC_(9.4205055236816406250000000000000000000000e+01), SC_(9.5494338989257812500000000000000000000000e+01), SC_(3.3718892931938171386718750000000000000000e-01), SC_(4.5644035937282749960423051404689736348119e-04) }},
{{ SC_(9.4273696899414062500000000000000000000000e+01), SC_(1.3122184753417968750000000000000000000000e+01), SC_(7.0939391851425170898437500000000000000000e-01), SC_(1.0728558150263590338355935009558786469551e-03) }},
{{ SC_(9.4362266540527343750000000000000000000000e+01), SC_(7.5628166198730468750000000000000000000000e+01), SC_(8.6930525302886962890625000000000000000000e-01), SC_(3.1895006110267162132266597008435035029088e-21) }},
{{ SC_(9.4478721618652343750000000000000000000000e+01), SC_(4.7944283485412597656250000000000000000000e+00), SC_(3.0198290944099426269531250000000000000000e-01), SC_(1.1506881513533761247867332725756449041417e-41) }},
{{ SC_(9.4517410278320312500000000000000000000000e+01), SC_(2.5958876609802246093750000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.9708735737463313346168739191588833336326e+01) }},
{{ SC_(9.5022209167480468750000000000000000000000e+01), SC_(4.9058906555175781250000000000000000000000e+01), SC_(9.5445640385150909423828125000000000000000e-02), SC_(2.9386956924095644345298672909662830963359e-58) }},
{{ SC_(9.5163047790527343750000000000000000000000e+01), SC_(8.7805053710937500000000000000000000000000e+01), SC_(6.8924558162689208984375000000000000000000e-01), SC_(1.4614950185254178308286552254212048028564e-04) }},
{{ SC_(9.5613456726074218750000000000000000000000e+01), SC_(6.5196868896484375000000000000000000000000e+01), SC_(3.3778563141822814941406250000000000000000e-01), SC_(2.8713702158865765280365457021387606631988e-09) }},
{{ SC_(9.5716697692871093750000000000000000000000e+01), SC_(1.0986175537109375000000000000000000000000e+01), SC_(3.3365238457918167114257812500000000000000e-02), SC_(2.7684429313564583372136306476066738974168e-125) }},
{{ SC_(9.5750686645507812500000000000000000000000e+01), SC_(9.9646133422851562500000000000000000000000e+01), SC_(1.7872119322419166564941406250000000000000e-02), SC_(7.3794537964533440984997279003077911288729e-108) }},
{{ SC_(9.5769393920898437500000000000000000000000e+01), SC_(7.2490600585937500000000000000000000000000e+01), SC_(8.7244158983230590820312500000000000000000e-01), SC_(6.4260835203298953010053747051410528643206e-20) }},
{{ SC_(9.5929138183593750000000000000000000000000e+01), SC_(5.8095668792724609375000000000000000000000e+01), SC_(1.3871058821678161621093750000000000000000e-01), SC_(3.6745900409996784824019087439808608810436e-41) }},
{{ SC_(9.5949241638183593750000000000000000000000e+01), SC_(5.0366271972656250000000000000000000000000e+01), SC_(4.3119497597217559814453125000000000000000e-02), SC_(4.8705691631943498848282578847428638545877e-90) }},
{{ SC_(9.5974395751953125000000000000000000000000e+01), SC_(5.7375465393066406250000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.7503051233694582094345085784055455487545e-45) }},
{{ SC_(9.6189811706542968750000000000000000000000e+01), SC_(9.7992561340332031250000000000000000000000e+01), SC_(2.4015194177627563476562500000000000000000e-01), SC_(2.2618467590737784781921207935768959473941e-12) }},
{{ SC_(9.6308853149414062500000000000000000000000e+01), SC_(6.0592819213867187500000000000000000000000e+01), SC_(4.8866885900497436523437500000000000000000e-01), SC_(6.8799356264808171441193506271892969546316e-02) }},
{{ SC_(9.6488853454589843750000000000000000000000e+01), SC_(9.6769493103027343750000000000000000000000e+01), SC_(1.8548998981714248657226562500000000000000e-02), SC_(3.0480885787268922411353998954441410635121e-108) }},
{{ SC_(9.6864929199218750000000000000000000000000e+01), SC_(3.3233909606933593750000000000000000000000e+01), SC_(8.2262271642684936523437500000000000000000e-01), SC_(1.1554821371226023420039230191697965414221e+00) }},
{{ SC_(9.7059280395507812500000000000000000000000e+01), SC_(9.8110969543457031250000000000000000000000e+01), SC_(3.1929660588502883911132812500000000000000e-02), SC_(1.3828686860030582606826849047372484102628e-86) }},
{{ SC_(9.7297454833984375000000000000000000000000e+01), SC_(1.4221720695495605468750000000000000000000e+01), SC_(6.2565600872039794921875000000000000000000e-01), SC_(2.3728590690560645610905281094562161182908e-07) }},
{{ SC_(9.7868064880371093750000000000000000000000e+01), SC_(2.3240036010742187500000000000000000000000e+01), SC_(5.8099859952926635742187500000000000000000e-01), SC_(5.1034515317314536394378489182115547670301e-06) }},
{{ SC_(9.7974838256835937500000000000000000000000e+01), SC_(3.5463813781738281250000000000000000000000e+01), SC_(4.3892610073089599609375000000000000000000e-01), SC_(3.4129412415006435628855297705102803304699e-10) }},
{{ SC_(9.8163795471191406250000000000000000000000e+01), SC_(4.9786941528320312500000000000000000000000e+01), SC_(7.5581431388854980468750000000000000000000e-01), SC_(5.1684890204924104671133789171334600330920e-01) }},
{{ SC_(9.8266342163085937500000000000000000000000e+01), SC_(8.9943603515625000000000000000000000000000e+01), SC_(7.9222810268402099609375000000000000000000e-01), SC_(3.0084147185345254528946160757134693746693e-14) }},
{{ SC_(9.8305252075195312500000000000000000000000e+01), SC_(5.5438030242919921875000000000000000000000e+01), SC_(7.1124464273452758789062500000000000000000e-01), SC_(1.8159391820216849764806036334255957151066e+00) }},
{{ SC_(9.8406372070312500000000000000000000000000e+01), SC_(2.9338825225830078125000000000000000000000e+01), SC_(6.7955178022384643554687500000000000000000e-01), SC_(6.6679595295298114418740621511018917032121e-01) }},
{{ SC_(9.8798194885253906250000000000000000000000e+01), SC_(7.6924316406250000000000000000000000000000e+01), SC_(4.9859434366226196289062500000000000000000e-01), SC_(2.5149566066288050636345105459253065128216e+00) }},
{{ SC_(9.9613471984863281250000000000000000000000e+01), SC_(4.4758438110351562500000000000000000000000e+01), SC_(2.3735985159873962402343750000000000000000e-01), SC_(2.6347262424091585263638769476038839175100e-28) }},
{{ SC_(9.9908042907714843750000000000000000000000e+01), SC_(6.7421295166015625000000000000000000000000e+01), SC_(7.3282539844512939453125000000000000000000e-01), SC_(9.3305680599232682384330960864840802401330e-03) }}
}};

